/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix;

import com.google.common.cache.CacheBuilder;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.Manifest;
import net.minecraft.launchwrapper.LaunchClassLoader;

public final class LaunchWrapperRuntimeFix {
    private LaunchWrapperRuntimeFix() {
    }

    public static void weakenResourceCache() {
        try {
            LaunchClassLoader loader = (LaunchClassLoader)LaunchWrapperRuntimeFix.class.getClassLoader();
            Field resourceCacheField = ReflectionHelper.findField(LaunchClassLoader.class, (String[])new String[]{"resourceCache"});
            Map oldResourceCache = (Map)resourceCacheField.get(loader);
            ConcurrentMap newResourceCache = CacheBuilder.newBuilder().weakValues().build().asMap();
            newResourceCache.putAll(oldResourceCache);
            resourceCacheField.set(loader, newResourceCache);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removePackageManifestMap() {
        try {
            LaunchClassLoader loader = (LaunchClassLoader)LaunchWrapperRuntimeFix.class.getClassLoader();
            Field pmField = ReflectionHelper.findField(LaunchClassLoader.class, (String[])new String[]{"packageManifests"});
            pmField.set(loader, new Map<Package, Manifest>(){

                @Override
                public int size() {
                    return 0;
                }

                @Override
                public boolean isEmpty() {
                    return true;
                }

                @Override
                public boolean containsKey(Object o) {
                    return false;
                }

                @Override
                public boolean containsValue(Object o) {
                    return false;
                }

                @Override
                public Manifest get(Object o) {
                    return null;
                }

                @Override
                public Manifest put(Package o, Manifest o2) {
                    return o2;
                }

                @Override
                public Manifest remove(Object o) {
                    return null;
                }

                @Override
                public void putAll(Map map) {
                }

                @Override
                public void clear() {
                }

                @Override
                public Set keySet() {
                    return Collections.emptySet();
                }

                @Override
                public Collection values() {
                    return Collections.emptySet();
                }

                @Override
                public Set<Map.Entry<Package, Manifest>> entrySet() {
                    return Collections.emptySet();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

