/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.ghostbuster;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import pl.asie.foamfix.FoamFixMod;
import pl.asie.foamfix.bugfixmod.coremod.BugfixModClassTransformer;

public class GhostBusterLogger {
    public static boolean debugChunkProviding = false;
    public static boolean countNotifyBlock = false;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static FileOutputStream fos;
    private static OutputStreamWriter osw;
    private static BufferedWriter bwr;

    public static void saveLogFile() {
        if (fos != null) {
            try {
                bwr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                osw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                fos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            bwr = null;
            osw = null;
            fos = null;
        }
    }

    private static void log(String s, boolean header) {
        if (BugfixModClassTransformer.instance.settings.gbDebuggerLogFile == null) {
            FoamFixMod.logger.info(s);
        } else {
            if (fos == null) {
                try {
                    fos = new FileOutputStream(BugfixModClassTransformer.instance.settings.gbDebuggerLogFile, true);
                    osw = new OutputStreamWriter(fos);
                    bwr = new BufferedWriter(osw);
                    bwr.write(String.format("--- Started logging at %s ---%n", DATE_FORMAT.format(new Date())));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                if (header) {
                    bwr.write(String.format("[%s] %s%n", DATE_FORMAT.format(new Date()), s));
                } else {
                    bwr.write(String.format("%s%n", s));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void logFlush() {
        if (bwr != null) {
            try {
                bwr.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void onProvideChunk(ChunkProviderServer server, int x, int z) {
        if (debugChunkProviding) {
            Chunk chunk = (Chunk)server.field_73244_f.func_76164_a(ChunkCoordIntPair.func_77272_a((int)x, (int)z));
            if (chunk != null) {
                return;
            }
            if (!server.field_73251_h.getPersistentChunks().containsKey((Object)new ChunkCoordIntPair(x, z))) {
                int i = 0;
                StackTraceElement[] stea = new Throwable().getStackTrace();
                if (stea.length > 3 && stea[3].toString().startsWith("net.minecraft.world.WorldServer.func_147456_g")) {
                    i = -1;
                }
                if (i >= 0 && !countNotifyBlock) {
                    for (StackTraceElement ste : stea) {
                        if (!ste.toString().startsWith("net.minecraft.world.World.markAndNotifyBlock")) continue;
                        i = -1;
                        break;
                    }
                }
                if (i >= 0) {
                    GhostBusterLogger.log("Block in chunk [" + x + ", " + z + "] may be ghostloaded!", true);
                    for (StackTraceElement ste : stea) {
                        try {
                            Class<?> c = GhostBusterLogger.class.getClassLoader().loadClass(ste.getClassName());
                            if (MinecraftServer.class.isAssignableFrom(c)) break;
                            if (i++ <= 1) continue;
                            GhostBusterLogger.log("- " + ste.toString(), false);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    GhostBusterLogger.logFlush();
                }
            }
        }
    }
}

