/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.repack.com.unascribed.ears;

import com.google.common.base.Charsets;
import com.google.common.collect.Iterables;
import com.google.common.io.BaseEncoding;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.ImageBufferDownload;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;
import pl.asie.foamfix.repack.com.unascribed.ears.LayerEars;
import pl.asie.foamfix.repack.com.unascribed.ears.ModelTransBox;
import pl.asie.foamfix.repack.com.unascribed.ears.common.EarsCommon;
import pl.asie.foamfix.repack.com.unascribed.ears.common.EarsFeatures;
import pl.asie.foamfix.repack.com.unascribed.ears.common.debug.EarsLog;
import pl.asie.foamfix.repack.com.unascribed.ears.common.legacy.AWTEarsImage;
import pl.asie.foamfix.repack.com.unascribed.ears.common.util.EarsStorage;

public class Ears {
    public static final Map<ITextureObject, EarsFeatures> earsSkinFeatures = new WeakHashMap<ITextureObject, EarsFeatures>();
    private static LayerEars layer;
    public static ModelRenderer slimLeftArm;
    public static ModelRenderer slimRightArm;
    public static ModelRenderer fatLeftArm;
    public static ModelRenderer fatRightArm;
    private static final MethodHandle setAreaOpaque;
    private static final MethodHandle setAreaTransparent;
    private static final MethodHandle gImageHeight;
    private static final MethodHandle sImageHeight;
    private static final MethodHandle gImageWidth;
    private static final MethodHandle sImageWidth;
    private static final MethodHandle sImageData;

    public Ears() {
        if (EarsLog.DEBUG) {
            EarsLog.debugva("Platform", "Initialized - {} / Forge {}; Side={}", Loader.instance().getMCVersionString(), ForgeVersion.getVersion(), FMLCommonHandler.instance().getSide());
        }
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        layer = new LayerEars();
    }

    public static void amendPlayerRenderer(RenderPlayer rp) {
        EarsLog.debug("Platform", "Hacking 64x64 skin support into player model");
        ModelBiped model = new ModelBiped(0.0f, 0.0f, 64, 64);
        ReflectionHelper.setPrivateValue(RendererLivingEntity.class, (Object)rp, (Object)model, (String[])new String[]{"field_77045_g", "mainModel"});
        rp.field_77109_a = model;
        model.field_78089_u = 32;
        model.field_78122_k = new ModelRenderer((ModelBase)model, 0, 0);
        model.field_78122_k.func_78790_a(-5.0f, 0.0f, -1.0f, 10, 16, 1, 0.0f);
        model.field_78089_u = 64;
        model.field_78114_d.field_78804_l.remove(0);
        ModelTransBox.addBoxTo(model.field_78114_d, 32, 0, -4.0f, -8.0f, -4.0f, 8, 8, 8, 0.5f);
        model.field_78113_g = new ModelRenderer((ModelBase)model, 32, 48);
        model.field_78113_g.func_78790_a(-1.0f, -2.0f, -2.0f, 4, 12, 4, 0.0f);
        model.field_78113_g.func_78793_a(5.0f, 2.0f, 0.0f);
        model.field_78124_i = new ModelRenderer((ModelBase)model, 16, 48);
        model.field_78124_i.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, 0.0f);
        model.field_78124_i.func_78793_a(1.9f, 12.0f, 0.0f);
        fatLeftArm = model.field_78113_g;
        fatRightArm = model.field_78112_f;
        slimLeftArm = new ModelRenderer((ModelBase)model, 32, 48);
        slimLeftArm.func_78790_a(-1.0f, -2.0f, -2.0f, 3, 12, 4, 0.0f);
        slimLeftArm.func_78793_a(5.0f, 2.5f, 0.0f);
        slimRightArm = new ModelRenderer((ModelBase)model, 40, 16);
        slimRightArm.func_78790_a(-2.0f, -2.0f, -2.0f, 3, 12, 4, 0.0f);
        slimRightArm.func_78793_a(-5.0f, 2.5f, 0.0f);
    }

    @SubscribeEvent
    public void onRenderPlayerPre(RenderPlayerEvent.Pre e) {
        Ears.beforeRender(e.renderer, e.entityPlayer);
    }

    @SubscribeEvent
    public void onRenderPlayerPost(RenderPlayerEvent.Specials.Post e) {
        EarsLog.debug("Platform:Renderer", "RenderPlayerEvent.Specials.Post player={}, renderer={}, partialTicks={}", (Object)e.entityPlayer, (Object)e.renderer, e.partialRenderTick);
        layer.doRenderLayer(e.renderer, (AbstractClientPlayer)e.entityPlayer, e.entityPlayer.field_70722_aY + (e.entityPlayer.field_70721_aZ - e.entityPlayer.field_70722_aY) * e.partialRenderTick, e.partialRenderTick);
    }

    public static BufferedImage interceptParseUserSkin(ImageBufferDownload subject, BufferedImage image) {
        EarsLog.debug("Platform:Inject", "parseUserSkin({}, {})", (Object)subject, (Object)image);
        if (image == null) {
            EarsLog.debug("Platform:Inject", "parseUserSkin(...): Image is null");
            return null;
        }
        Ears.setImageWidth(subject, 64);
        Ears.setImageHeight(subject, 64);
        BufferedImage newImg = new BufferedImage(64, 64, 2);
        Graphics g = newImg.getGraphics();
        g.drawImage(image, 0, 0, null);
        if (image.getHeight() == 32) {
            EarsLog.debug("Platform:Inject", "parseUserSkin(...): Upgrading legacy skin");
            g.drawImage(newImg, 24, 48, 20, 52, 4, 16, 8, 20, null);
            g.drawImage(newImg, 28, 48, 24, 52, 8, 16, 12, 20, null);
            g.drawImage(newImg, 20, 52, 16, 64, 8, 20, 12, 32, null);
            g.drawImage(newImg, 24, 52, 20, 64, 4, 20, 8, 32, null);
            g.drawImage(newImg, 28, 52, 24, 64, 0, 20, 4, 32, null);
            g.drawImage(newImg, 32, 52, 28, 64, 12, 20, 16, 32, null);
            g.drawImage(newImg, 40, 48, 36, 52, 44, 16, 48, 20, null);
            g.drawImage(newImg, 44, 48, 40, 52, 48, 16, 52, 20, null);
            g.drawImage(newImg, 36, 52, 32, 64, 48, 20, 52, 32, null);
            g.drawImage(newImg, 40, 52, 36, 64, 44, 20, 48, 32, null);
            g.drawImage(newImg, 44, 52, 40, 64, 40, 20, 44, 32, null);
            g.drawImage(newImg, 48, 52, 44, 64, 52, 20, 56, 32, null);
        }
        g.dispose();
        EarsStorage.put(newImg, EarsStorage.Key.ALFALFA, EarsCommon.preprocessSkin(new AWTEarsImage(newImg)));
        Ears.setImageData(subject, ((DataBufferInt)newImg.getRaster().getDataBuffer()).getData());
        EarsCommon.carefullyStripAlpha((_x1, _y1, _x2, _y2) -> Ears.setAreaOpaque(subject, _x1, _y1, _x2, _y2), true);
        Ears.setAreaTransparent(subject, 32, 0, 64, 32);
        Ears.setAreaTransparent(subject, 0, 32, 16, 48);
        Ears.setAreaTransparent(subject, 16, 32, 40, 48);
        Ears.setAreaTransparent(subject, 40, 32, 56, 48);
        Ears.setAreaTransparent(subject, 0, 48, 16, 64);
        Ears.setAreaTransparent(subject, 48, 48, 64, 64);
        return newImg;
    }

    public static void checkSkin(ThreadDownloadImageData tdid, BufferedImage img) {
        EarsLog.debug("Platform:Inject", "Process player skin");
        earsSkinFeatures.put((ITextureObject)tdid, EarsFeatures.detect(new AWTEarsImage(img), EarsStorage.get(img, EarsStorage.Key.ALFALFA)));
    }

    public static void beforeRender(RenderPlayer rp, EntityPlayer player) {
        boolean slim = false;
        PropertyMap props = player.func_146103_bH().getProperties();
        if (props.containsKey((Object)"textures")) {
            if (props.containsKey((Object)"com.unascribed.ears.legacySlim")) {
                Property p = (Property)Iterables.getFirst((Iterable)props.get((Object)"com.unascribed.ears.legacySlim"), null);
                slim = p != null && p.getValue().equals("true");
            } else {
                Property p = (Property)Iterables.getFirst((Iterable)props.get((Object)"textures"), null);
                if (p != null) {
                    JsonElement meta;
                    JsonElement skin;
                    JsonElement ele;
                    JsonObject payload = (JsonObject)new Gson().fromJson(new String(BaseEncoding.base64().decode((CharSequence)p.getValue()), Charsets.UTF_8), JsonObject.class);
                    if (payload.has("textures") && (ele = payload.get("textures")).isJsonObject() && ele.getAsJsonObject().has("SKIN") && (skin = ele.getAsJsonObject().get("SKIN")).isJsonObject() && skin.getAsJsonObject().has("metadata") && (meta = skin.getAsJsonObject().get("metadata")).isJsonObject() && meta.getAsJsonObject().has("model")) {
                        slim = "slim".equals(meta.getAsJsonObject().get("model").getAsString());
                    }
                    props.put((Object)"com.unascribed.ears.legacySlim", (Object)new Property("com.unascribed.ears.legacySlim", slim ? "true" : "false"));
                }
            }
        }
        if (slim) {
            rp.field_77109_a.field_78113_g = slimLeftArm;
            rp.field_77109_a.field_78112_f = slimRightArm;
        } else {
            rp.field_77109_a.field_78113_g = fatLeftArm;
            rp.field_77109_a.field_78112_f = fatRightArm;
        }
    }

    public static void renderFirstPersonArm(RenderPlayer rp, EntityPlayer player) {
        layer.renderRightArm(rp, (AbstractClientPlayer)player);
    }

    private static int getImageWidth(ImageBufferDownload subject) {
        try {
            return gImageWidth.invokeExact(subject);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static int getImageHeight(ImageBufferDownload subject) {
        try {
            return gImageHeight.invokeExact(subject);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static void setImageWidth(ImageBufferDownload subject, int i) {
        try {
            sImageWidth.invokeExact(subject, i);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static void setImageHeight(ImageBufferDownload subject, int i) {
        try {
            sImageHeight.invokeExact(subject, i);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static void setImageData(ImageBufferDownload subject, int[] data) {
        try {
            sImageData.invokeExact(subject, data);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static void setAreaOpaque(ImageBufferDownload subject, int x1, int y1, int x2, int y2) {
        try {
            EarsLog.debug("Platform:Inject", "stripAlpha({}, {}, {}, {}, {})", (Object)subject, x1, y1, x2, y2);
            setAreaOpaque.invokeExact(subject, x1, y1, x2, y2);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static void setAreaTransparent(ImageBufferDownload subject, int x1, int y1, int x2, int y2) {
        try {
            setAreaTransparent.invokeExact(subject, x1, y1, x2, y2);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            Method saom = ReflectionHelper.findMethod(ImageBufferDownload.class, null, (String[])new String[]{"func_78433_b", "setAreaOpaque"}, (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
            saom.setAccessible(true);
            setAreaOpaque = MethodHandles.lookup().unreflect(saom);
            Method satm = ReflectionHelper.findMethod(ImageBufferDownload.class, null, (String[])new String[]{"func_78434_a", "setAreaTransparent"}, (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
            satm.setAccessible(true);
            setAreaTransparent = MethodHandles.lookup().unreflect(satm);
            Field ihf = ReflectionHelper.findField(ImageBufferDownload.class, (String[])new String[]{"field_78437_c", "imageHeight"});
            ihf.setAccessible(true);
            gImageHeight = MethodHandles.lookup().unreflectGetter(ihf);
            sImageHeight = MethodHandles.lookup().unreflectSetter(ihf);
            Field iwf = ReflectionHelper.findField(ImageBufferDownload.class, (String[])new String[]{"field_78436_b", "imageWidth"});
            iwf.setAccessible(true);
            gImageWidth = MethodHandles.lookup().unreflectGetter(iwf);
            sImageWidth = MethodHandles.lookup().unreflectSetter(iwf);
            Field idf = ReflectionHelper.findField(ImageBufferDownload.class, (String[])new String[]{"field_78438_a", "imageData"});
            idf.setAccessible(true);
            sImageData = MethodHandles.lookup().unreflectSetter(idf);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }
}

