/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.repack.com.unascribed.ears;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import pl.asie.foamfix.repack.com.unascribed.ears.Ears;
import pl.asie.foamfix.repack.com.unascribed.ears.common.EarsCommon;
import pl.asie.foamfix.repack.com.unascribed.ears.common.EarsFeatures;
import pl.asie.foamfix.repack.com.unascribed.ears.common.debug.EarsLog;
import pl.asie.foamfix.repack.com.unascribed.ears.common.legacy.PartiallyUnmanagedEarsRenderDelegate;
import pl.asie.foamfix.repack.com.unascribed.ears.common.render.EarsRenderDelegate;
import pl.asie.foamfix.repack.com.unascribed.ears.common.util.Decider;

public class LayerEars {
    private RenderPlayer render;
    private float tickDelta;
    private final PartiallyUnmanagedEarsRenderDelegate<AbstractClientPlayer, ModelRenderer> delegate = new PartiallyUnmanagedEarsRenderDelegate<AbstractClientPlayer, ModelRenderer>(){

        @Override
        protected boolean isVisible(ModelRenderer modelPart) {
            return modelPart.field_78806_j;
        }

        @Override
        public boolean isSlim() {
            return ((LayerEars)LayerEars.this).render.field_77109_a.field_78113_g == Ears.slimLeftArm;
        }

        @Override
        protected EarsFeatures getEarsFeatures() {
            ResourceLocation skin = ((AbstractClientPlayer)this.peer).func_110306_p();
            ITextureObject tex = Minecraft.func_71410_x().func_110434_K().func_110581_b(skin);
            if (Ears.earsSkinFeatures.containsKey(tex) && !((AbstractClientPlayer)this.peer).func_82150_aj()) {
                return Ears.earsSkinFeatures.get(tex);
            }
            return EarsFeatures.DISABLED;
        }

        @Override
        protected void doBindSkin() {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(((AbstractClientPlayer)this.peer).func_110306_p());
        }

        @Override
        protected void doBindAux(EarsRenderDelegate.TexSource src, byte[] pngData) {
            if (pngData == null) {
                GL11.glBindTexture((int)3553, (int)0);
            } else {
                ResourceLocation skin = ((AbstractClientPlayer)this.peer).func_110306_p();
                ResourceLocation id = new ResourceLocation(skin.func_110624_b(), src.addSuffix(skin.func_110623_a()));
                if (Minecraft.func_71410_x().func_110434_K().func_110581_b(id) == null) {
                    try {
                        Minecraft.func_71410_x().func_110434_K().func_110579_a(id, (ITextureObject)new DynamicTexture(ImageIO.read(new ByteArrayInputStream(pngData))));
                    }
                    catch (IOException e) {
                        Minecraft.func_71410_x().func_110434_K().func_110579_a(id, (ITextureObject)TextureUtil.field_111001_a);
                    }
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(id);
            }
        }

        @Override
        protected void doAnchorTo(EarsRenderDelegate.BodyPart part, ModelRenderer modelPart) {
            modelPart.func_78794_c(0.0625f);
            ModelBox cuboid = (ModelBox)modelPart.field_78804_l.get(0);
            GL11.glScalef((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GL11.glTranslatef((float)cuboid.field_78252_a, (float)cuboid.field_78249_e, (float)cuboid.field_78251_c);
        }

        @Override
        protected Decider<EarsRenderDelegate.BodyPart, ModelRenderer> decideModelPart(Decider<EarsRenderDelegate.BodyPart, ModelRenderer> d) {
            ModelBiped model = ((LayerEars)LayerEars.this).render.field_77109_a;
            return d.map(EarsRenderDelegate.BodyPart.HEAD, model.field_78116_c).map(EarsRenderDelegate.BodyPart.LEFT_ARM, model.field_78113_g).map(EarsRenderDelegate.BodyPart.LEFT_LEG, model.field_78124_i).map(EarsRenderDelegate.BodyPart.RIGHT_ARM, model.field_78112_f).map(EarsRenderDelegate.BodyPart.RIGHT_LEG, model.field_78123_h).map(EarsRenderDelegate.BodyPart.TORSO, model.field_78115_e);
        }

        @Override
        protected void beginQuad() {
            Tessellator.field_78398_a.func_78371_b(7);
        }

        @Override
        protected void addVertex(float x, float y, int z, float r, float g, float b, float a, float u, float v, float nX, float nY, float nZ) {
            Tessellator.field_78398_a.func_78369_a(r, g, b, a);
            Tessellator.field_78398_a.func_78375_b(nX, nY, nZ);
            Tessellator.field_78398_a.func_78374_a((double)x, (double)y, (double)z, (double)u, (double)v);
        }

        @Override
        protected void drawQuad() {
            Tessellator.field_78398_a.func_78381_a();
        }

        @Override
        public float getTime() {
            return (float)((AbstractClientPlayer)this.peer).field_70173_aa + LayerEars.this.tickDelta;
        }

        @Override
        public boolean isFlying() {
            return ((AbstractClientPlayer)this.peer).field_71075_bZ.field_75100_b;
        }

        @Override
        public boolean isGliding() {
            return false;
        }

        @Override
        public boolean isJacketEnabled() {
            return true;
        }

        @Override
        public boolean isWearingBoots() {
            ItemStack feet = ((AbstractClientPlayer)this.peer).field_71071_by.func_70440_f(0);
            return feet != null && feet.func_77973_b() instanceof ItemArmor;
        }

        @Override
        public boolean isWearingChestplate() {
            ItemStack chest = ((AbstractClientPlayer)this.peer).field_71071_by.func_70440_f(2);
            return chest != null && chest.func_77973_b() instanceof ItemArmor;
        }

        @Override
        public boolean isWearingElytra() {
            return false;
        }

        @Override
        public boolean needsSecondaryLayersDrawn() {
            return true;
        }

        @Override
        public float getHorizontalSpeed() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).field_70141_P, ((AbstractClientPlayer)this.peer).field_70140_Q, LayerEars.this.tickDelta);
        }

        @Override
        public float getLimbSwing() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).field_70722_aY, ((AbstractClientPlayer)this.peer).field_70721_aZ, LayerEars.this.tickDelta);
        }

        @Override
        public float getStride() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).field_71107_bF, ((AbstractClientPlayer)this.peer).field_71109_bG, LayerEars.this.tickDelta);
        }

        @Override
        public float getBodyYaw() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).field_70760_ar, ((AbstractClientPlayer)this.peer).field_70761_aq, LayerEars.this.tickDelta);
        }

        @Override
        public double getCapeX() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).field_71091_bM, ((AbstractClientPlayer)this.peer).field_71094_bP, LayerEars.this.tickDelta);
        }

        @Override
        public double getCapeY() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).field_71096_bN, ((AbstractClientPlayer)this.peer).field_71095_bQ, LayerEars.this.tickDelta);
        }

        @Override
        public double getCapeZ() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).field_71097_bO, ((AbstractClientPlayer)this.peer).field_71085_bR, LayerEars.this.tickDelta);
        }

        @Override
        public double getX() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).field_70169_q, ((AbstractClientPlayer)this.peer).field_70165_t, LayerEars.this.tickDelta);
        }

        @Override
        public double getY() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).field_70167_r, ((AbstractClientPlayer)this.peer).field_70163_u, LayerEars.this.tickDelta);
        }

        @Override
        public double getZ() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).field_70166_s, ((AbstractClientPlayer)this.peer).field_70161_v, LayerEars.this.tickDelta);
        }
    };

    public void doRenderLayer(RenderPlayer render, AbstractClientPlayer entity, float limbDistance, float partialTicks) {
        EarsLog.debug("Platform:Renderer", "render({}, {}, {})", (Object)entity, limbDistance, partialTicks);
        this.render = render;
        this.tickDelta = partialTicks;
        this.delegate.render(entity);
    }

    public void renderRightArm(RenderPlayer render, AbstractClientPlayer entity) {
        EarsLog.debug("Platform:Renderer", "renderRightArm({}, {})", (Object)render, (Object)entity);
        this.render = render;
        this.tickDelta = 0.0f;
        this.delegate.render(entity, EarsRenderDelegate.BodyPart.RIGHT_ARM);
    }
}

