/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.repack.com.unascribed.ears.api;

import pl.asie.foamfix.repack.com.unascribed.ears.api.EarsAnchorPart;

public enum EarsFeatureType {
    EARS(EarsAnchorPart.HEAD),
    HORN(EarsAnchorPart.HEAD),
    SNOUT(EarsAnchorPart.HEAD),
    CLAW_LEFT_ARM(EarsAnchorPart.LEFT_ARM),
    CLAW_RIGHT_ARM(EarsAnchorPart.RIGHT_ARM),
    CLAW_LEFT_LEG(EarsAnchorPart.LEFT_LEG),
    CLAW_RIGHT_LEG(EarsAnchorPart.RIGHT_LEG),
    TAIL(EarsAnchorPart.TORSO),
    WINGS(EarsAnchorPart.TORSO),
    CAPE(EarsAnchorPart.TORSO),
    OTHER_HEAD(EarsAnchorPart.HEAD),
    OTHER_TORSO(EarsAnchorPart.TORSO);

    private final EarsAnchorPart anchor;

    private EarsFeatureType(EarsAnchorPart anchor) {
        this.anchor = anchor;
    }

    public EarsAnchorPart getAnchor() {
        return this.anchor;
    }

    public boolean isAnchoredTo(EarsAnchorPart part) {
        return this.anchor == part;
    }

    public boolean isAnchoredToAnyArm() {
        return this.isAnchoredTo(EarsAnchorPart.LEFT_ARM) || this.isAnchoredTo(EarsAnchorPart.RIGHT_ARM);
    }

    public boolean isAnchoredToAnyLeg() {
        return this.isAnchoredTo(EarsAnchorPart.LEFT_LEG) || this.isAnchoredTo(EarsAnchorPart.RIGHT_LEG);
    }
}

