/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.repack.com.unascribed.ears.common;

import pl.asie.foamfix.repack.com.unascribed.ears.common.Alfalfa;
import pl.asie.foamfix.repack.com.unascribed.ears.common.EarsFeaturesParserV0;
import pl.asie.foamfix.repack.com.unascribed.ears.common.EarsFeaturesParserV1;
import pl.asie.foamfix.repack.com.unascribed.ears.common.EarsImage;
import pl.asie.foamfix.repack.com.unascribed.ears.common.debug.EarsLog;

public class EarsFeatures {
    public static final EarsFeatures DISABLED = new EarsFeatures();
    public final boolean enabled;
    public final EarMode earMode;
    public final EarAnchor earAnchor;
    public final boolean claws;
    public final boolean horn;
    public final TailMode tailMode;
    public final int tailSegments;
    public final float tailBend0;
    public final float tailBend1;
    public final float tailBend2;
    public final float tailBend3;
    public final int snoutOffset;
    public final int snoutWidth;
    public final int snoutHeight;
    public final int snoutDepth;
    public final float chestSize;
    public final WingMode wingMode;
    public final boolean animateWings;
    public final boolean capeEnabled;
    public final Alfalfa alfalfa;

    private EarsFeatures() {
        this.enabled = false;
        this.earMode = EarMode.NONE;
        this.earAnchor = EarAnchor.CENTER;
        this.claws = false;
        this.horn = false;
        this.tailMode = TailMode.NONE;
        this.tailSegments = 0;
        this.tailBend0 = 0.0f;
        this.tailBend1 = 0.0f;
        this.tailBend2 = 0.0f;
        this.tailBend3 = 0.0f;
        this.snoutOffset = 0;
        this.snoutWidth = 0;
        this.snoutHeight = 0;
        this.snoutDepth = 0;
        this.chestSize = 0.0f;
        this.wingMode = WingMode.NONE;
        this.animateWings = true;
        this.capeEnabled = false;
        this.alfalfa = Alfalfa.NONE;
    }

    public EarsFeatures(EarMode earMode, EarAnchor earAnchor, boolean claws, boolean horn, TailMode tailMode, int tailSegments, float tailBend0, float tailBend1, float tailBend2, float tailBend3, int snoutOffset, int snoutWidth, int snoutHeight, int snoutDepth, float chestSize, WingMode wingMode, boolean animateWings, boolean capeEnabled, Alfalfa alfalfa) {
        this.enabled = true;
        this.earMode = earMode;
        this.earAnchor = earAnchor;
        this.claws = claws;
        this.horn = horn;
        this.tailMode = tailMode;
        this.tailSegments = tailSegments;
        this.tailBend0 = tailBend0;
        this.tailBend1 = tailBend1;
        this.tailBend2 = tailBend2;
        this.tailBend3 = tailBend3;
        this.snoutOffset = snoutOffset;
        this.snoutWidth = snoutWidth;
        this.snoutHeight = snoutHeight;
        this.snoutDepth = snoutDepth;
        this.chestSize = chestSize;
        this.wingMode = wingMode;
        this.animateWings = animateWings;
        this.capeEnabled = false;
        this.alfalfa = alfalfa;
    }

    public static EarsFeatures detect(EarsImage img, Alfalfa alfalfa) {
        EarsLog.debug("Common:Features", "detect({}, {})", (Object)img, (Object)alfalfa);
        if (img.getHeight() == 64) {
            int first = img.getARGB(0, 32) & 0xFFFFFF;
            if (first == EarsFeaturesParserV0.MAGIC) {
                return EarsFeaturesParserV0.parse(img, alfalfa);
            }
            if (first == 15344897) {
                return EarsFeaturesParserV1.parse(img, alfalfa);
            }
            EarsLog.debug("Common:Features", "detect(...): Could not find v0 (Pixelwise, #3F23D8) or v1 (Binary, #EA2501) data indicator at 0, 32 - found #{} instead. Disabling", EarsFeaturesParserV0.upperHex32Dbg(img.getARGB(0, 32)));
            return DISABLED;
        }
        EarsLog.debug("Common:Features", "detect(...): Legacy skin, ignoring");
        return DISABLED;
    }

    public String toString() {
        if (!this.enabled) {
            return "EarsFeatures.DISABLED";
        }
        return "EarsFeatures[earMode=" + (Object)((Object)this.earMode) + ", earAnchor=" + (Object)((Object)this.earAnchor) + ", claws=" + this.claws + ", horn=" + this.horn + ", tailMode=" + (Object)((Object)this.tailMode) + ", tailBend0=" + this.tailBend0 + ", tailBend1=" + this.tailBend1 + ", tailBend2=" + this.tailBend2 + ", tailBend3=" + this.tailBend3 + ", snoutOffset=" + this.snoutOffset + ", snoutWidth=" + this.snoutWidth + ", snoutHeight=" + this.snoutHeight + ", snoutDepth=" + this.snoutDepth + (this.chestSize > 0.0f ? ", chestSize=" + this.chestSize : "") + ", wingMode=" + (Object)((Object)this.wingMode) + ", animateWings=" + this.animateWings + ", alfalfa=" + this.alfalfa + "]";
    }

    public static enum WingMode {
        NONE,
        SYMMETRIC_DUAL,
        SYMMETRIC_SINGLE,
        ASYMMETRIC_L,
        ASYMMETRIC_R;

    }

    public static enum TailMode {
        NONE,
        DOWN,
        BACK,
        UP,
        VERTICAL;

    }

    public static enum EarAnchor {
        CENTER,
        FRONT,
        BACK;

    }

    public static enum EarMode {
        NONE,
        ABOVE,
        SIDES,
        BEHIND,
        AROUND,
        FLOPPY,
        CROSS,
        OUT,
        TALL,
        TALL_CROSS;

    }
}

