/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.repack.com.unascribed.ears.common.agent.mini;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import pl.asie.foamfix.repack.com.unascribed.ears.common.agent.mini.PatchContext;
import pl.asie.foamfix.repack.com.unascribed.ears.common.agent.mini.annotation.Patch;
import pl.asie.foamfix.repack.com.unascribed.ears.common.debug.EarsLog;

public abstract class MiniTransformer {
    private final Set<String> classes = new HashSet<String>();
    private final Map<String, List<PatchMethod>> methods = new HashMap<String, List<PatchMethod>>();
    private final Set<String> requiredMethods = new HashSet<String>();

    public MiniTransformer() {
        for (Patch.Class a : (Patch.Class[])this.getClass().getAnnotationsByType(Patch.Class.class)) {
            this.classes.add(a.value().replace('.', '/'));
        }
        for (final Method m : this.getClass().getMethods()) {
            final String name = m.getName();
            for (Patch.Method a : (Patch.Method[])m.getAnnotationsByType(Patch.Method.class)) {
                String desc = a.value();
                if (!this.methods.containsKey(desc)) {
                    this.methods.put(desc, new ArrayList());
                }
                final boolean frames = m.getAnnotation(Patch.Method.AffectsControlFlow.class) != null;
                this.methods.get(desc).add(new PatchMethod(){

                    @Override
                    public boolean patch(PatchContext ctx) throws Throwable {
                        try {
                            m.invoke((Object)MiniTransformer.this, ctx);
                        }
                        catch (InvocationTargetException e) {
                            throw e.getCause();
                        }
                        return frames;
                    }

                    public String toString() {
                        return name;
                    }
                });
                if (m.getAnnotation(Patch.Method.Optional.class) != null) continue;
                this.requiredMethods.add(desc);
            }
        }
    }

    public final byte[] transform(String className, byte[] basicClass) {
        if (!this.classes.contains(className = className.replace('.', '/'))) {
            return basicClass;
        }
        ClassReader reader = new ClassReader(basicClass);
        ClassNode clazz = new ClassNode();
        reader.accept((ClassVisitor)clazz, 0);
        boolean frames = false;
        ArrayList<String> foundMethods = new ArrayList<String>();
        HashSet<String> requiredsNotSeen = new HashSet<String>(this.requiredMethods.size());
        requiredsNotSeen.addAll(this.requiredMethods);
        for (Object mn : clazz.methods) {
            String name = ((MethodNode)mn).name + ((MethodNode)mn).desc;
            foundMethods.add(name);
            List<PatchMethod> li = this.methods.get(name);
            if (li != null) {
                for (PatchMethod pm : li) {
                    try {
                        PatchContext ctx = new PatchContext((MethodNode)mn);
                        frames |= pm.patch(ctx);
                        ctx.finish();
                    }
                    catch (Throwable t) {
                        throw new Error("Failed to patch " + className + "." + ((MethodNode)mn).name + ((MethodNode)mn).desc + " via " + pm, t);
                    }
                    EarsLog.debug("Common:Agent", "[{}] Successfully transformed {}.{}{} via {}", (Object)this.getClass().getName(), className, ((MethodNode)mn).name, ((MethodNode)mn).desc, pm);
                }
            }
            requiredsNotSeen.remove(name);
        }
        if (!requiredsNotSeen.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            msg.append(requiredsNotSeen.size());
            msg.append(" required method");
            msg.append(requiredsNotSeen.size() == 1 ? " was" : "s were");
            msg.append(" not found while patching ");
            msg.append(className);
            msg.append("!");
            for (String name : requiredsNotSeen) {
                msg.append(" ");
                msg.append(name);
                msg.append(",");
            }
            msg.deleteCharAt(msg.length() - 1);
            msg.append("\nThe following methods were found:");
            for (String name : foundMethods) {
                msg.append(" ");
                msg.append(name);
                msg.append(",");
            }
            msg.deleteCharAt(msg.length() - 1);
            String msgS = msg.toString();
            EarsLog.debug("Common:Agent", "[{}] {}", (Object)this.getClass().getName(), (Object)msgS);
            throw new Error(msgS);
        }
        int flags = 1;
        if (frames) {
            flags |= 2;
        }
        ClassWriter writer = new ClassWriter(flags);
        clazz.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    protected static InsnNode NOP() {
        return new InsnNode(0);
    }

    protected static InsnNode ACONST_NULL() {
        return new InsnNode(1);
    }

    protected static InsnNode ICONST_M1() {
        return new InsnNode(2);
    }

    protected static InsnNode ICONST_0() {
        return new InsnNode(3);
    }

    protected static InsnNode ICONST_1() {
        return new InsnNode(4);
    }

    protected static InsnNode ICONST_2() {
        return new InsnNode(5);
    }

    protected static InsnNode ICONST_3() {
        return new InsnNode(6);
    }

    protected static InsnNode ICONST_4() {
        return new InsnNode(7);
    }

    protected static InsnNode ICONST_5() {
        return new InsnNode(8);
    }

    protected static InsnNode LCONST_0() {
        return new InsnNode(9);
    }

    protected static InsnNode LCONST_1() {
        return new InsnNode(10);
    }

    protected static InsnNode FCONST_0() {
        return new InsnNode(11);
    }

    protected static InsnNode FCONST_1() {
        return new InsnNode(12);
    }

    protected static InsnNode FCONST_2() {
        return new InsnNode(13);
    }

    protected static InsnNode DCONST_0() {
        return new InsnNode(14);
    }

    protected static InsnNode DCONST_1() {
        return new InsnNode(15);
    }

    protected static IntInsnNode BIPUSH(int i) {
        return new IntInsnNode(16, i);
    }

    protected static IntInsnNode SIPUSH(int i) {
        return new IntInsnNode(17, i);
    }

    protected static LdcInsnNode LDC(int v) {
        return new LdcInsnNode((Object)v);
    }

    protected static LdcInsnNode LDC(float v) {
        return new LdcInsnNode((Object)Float.valueOf(v));
    }

    protected static LdcInsnNode LDC(long v) {
        return new LdcInsnNode((Object)v);
    }

    protected static LdcInsnNode LDC(double v) {
        return new LdcInsnNode((Object)v);
    }

    protected static LdcInsnNode LDC(String v) {
        return new LdcInsnNode((Object)v);
    }

    protected static LdcInsnNode LDC(Type v) {
        return new LdcInsnNode((Object)v);
    }

    protected static VarInsnNode ILOAD(int var) {
        return new VarInsnNode(21, var);
    }

    protected static VarInsnNode LLOAD(int var) {
        return new VarInsnNode(22, var);
    }

    protected static VarInsnNode FLOAD(int var) {
        return new VarInsnNode(23, var);
    }

    protected static VarInsnNode DLOAD(int var) {
        return new VarInsnNode(24, var);
    }

    protected static VarInsnNode ALOAD(int var) {
        return new VarInsnNode(25, var);
    }

    protected static InsnNode IALOAD() {
        return new InsnNode(46);
    }

    protected static InsnNode LALOAD() {
        return new InsnNode(47);
    }

    protected static InsnNode FALOAD() {
        return new InsnNode(48);
    }

    protected static InsnNode DALOAD() {
        return new InsnNode(49);
    }

    protected static InsnNode AALOAD() {
        return new InsnNode(50);
    }

    protected static InsnNode BALOAD() {
        return new InsnNode(51);
    }

    protected static InsnNode CALOAD() {
        return new InsnNode(52);
    }

    protected static InsnNode SALOAD() {
        return new InsnNode(53);
    }

    protected static VarInsnNode ISTORE(int var) {
        return new VarInsnNode(54, var);
    }

    protected static VarInsnNode LSTORE(int var) {
        return new VarInsnNode(55, var);
    }

    protected static VarInsnNode FSTORE(int var) {
        return new VarInsnNode(56, var);
    }

    protected static VarInsnNode DSTORE(int var) {
        return new VarInsnNode(57, var);
    }

    protected static VarInsnNode ASTORE(int var) {
        return new VarInsnNode(58, var);
    }

    protected static InsnNode IASTORE() {
        return new InsnNode(79);
    }

    protected static InsnNode LASTORE() {
        return new InsnNode(80);
    }

    protected static InsnNode FASTORE() {
        return new InsnNode(81);
    }

    protected static InsnNode DASTORE() {
        return new InsnNode(82);
    }

    protected static InsnNode AASTORE() {
        return new InsnNode(83);
    }

    protected static InsnNode BASTORE() {
        return new InsnNode(84);
    }

    protected static InsnNode CASTORE() {
        return new InsnNode(85);
    }

    protected static InsnNode SASTORE() {
        return new InsnNode(86);
    }

    protected static InsnNode POP() {
        return new InsnNode(87);
    }

    protected static InsnNode POP2() {
        return new InsnNode(88);
    }

    protected static InsnNode DUP() {
        return new InsnNode(89);
    }

    protected static InsnNode DUP_X1() {
        return new InsnNode(90);
    }

    protected static InsnNode DUP_X2() {
        return new InsnNode(91);
    }

    protected static InsnNode DUP2() {
        return new InsnNode(92);
    }

    protected static InsnNode DUP2_X1() {
        return new InsnNode(93);
    }

    protected static InsnNode DUP2_X2() {
        return new InsnNode(94);
    }

    protected static InsnNode SWAP() {
        return new InsnNode(95);
    }

    protected static InsnNode IADD() {
        return new InsnNode(96);
    }

    protected static InsnNode LADD() {
        return new InsnNode(97);
    }

    protected static InsnNode FADD() {
        return new InsnNode(98);
    }

    protected static InsnNode DADD() {
        return new InsnNode(99);
    }

    protected static InsnNode ISUB() {
        return new InsnNode(100);
    }

    protected static InsnNode LSUB() {
        return new InsnNode(101);
    }

    protected static InsnNode FSUB() {
        return new InsnNode(102);
    }

    protected static InsnNode DSUB() {
        return new InsnNode(103);
    }

    protected static InsnNode IMUL() {
        return new InsnNode(104);
    }

    protected static InsnNode LMUL() {
        return new InsnNode(105);
    }

    protected static InsnNode FMUL() {
        return new InsnNode(106);
    }

    protected static InsnNode DMUL() {
        return new InsnNode(107);
    }

    protected static InsnNode IDIV() {
        return new InsnNode(108);
    }

    protected static InsnNode LDIV() {
        return new InsnNode(109);
    }

    protected static InsnNode FDIV() {
        return new InsnNode(110);
    }

    protected static InsnNode DDIV() {
        return new InsnNode(111);
    }

    protected static InsnNode IREM() {
        return new InsnNode(112);
    }

    protected static InsnNode LREM() {
        return new InsnNode(113);
    }

    protected static InsnNode FREM() {
        return new InsnNode(114);
    }

    protected static InsnNode DREM() {
        return new InsnNode(115);
    }

    protected static InsnNode INEG() {
        return new InsnNode(116);
    }

    protected static InsnNode LNEG() {
        return new InsnNode(117);
    }

    protected static InsnNode FNEG() {
        return new InsnNode(118);
    }

    protected static InsnNode DNEG() {
        return new InsnNode(119);
    }

    protected static InsnNode ISHL() {
        return new InsnNode(120);
    }

    protected static InsnNode LSHL() {
        return new InsnNode(121);
    }

    protected static InsnNode ISHR() {
        return new InsnNode(122);
    }

    protected static InsnNode LSHR() {
        return new InsnNode(123);
    }

    protected static InsnNode IUSHR() {
        return new InsnNode(124);
    }

    protected static InsnNode LUSHR() {
        return new InsnNode(125);
    }

    protected static InsnNode IAND() {
        return new InsnNode(126);
    }

    protected static InsnNode LAND() {
        return new InsnNode(127);
    }

    protected static InsnNode IOR() {
        return new InsnNode(128);
    }

    protected static InsnNode LOR() {
        return new InsnNode(129);
    }

    protected static InsnNode IXOR() {
        return new InsnNode(130);
    }

    protected static InsnNode LXOR() {
        return new InsnNode(131);
    }

    protected static IincInsnNode IINC(int var, int incr) {
        return new IincInsnNode(var, incr);
    }

    protected static InsnNode I2L() {
        return new InsnNode(133);
    }

    protected static InsnNode I2F() {
        return new InsnNode(134);
    }

    protected static InsnNode I2D() {
        return new InsnNode(135);
    }

    protected static InsnNode L2I() {
        return new InsnNode(136);
    }

    protected static InsnNode L2F() {
        return new InsnNode(137);
    }

    protected static InsnNode L2D() {
        return new InsnNode(138);
    }

    protected static InsnNode F2I() {
        return new InsnNode(139);
    }

    protected static InsnNode F2L() {
        return new InsnNode(140);
    }

    protected static InsnNode F2D() {
        return new InsnNode(141);
    }

    protected static InsnNode D2I() {
        return new InsnNode(142);
    }

    protected static InsnNode D2L() {
        return new InsnNode(143);
    }

    protected static InsnNode D2F() {
        return new InsnNode(144);
    }

    protected static InsnNode I2B() {
        return new InsnNode(145);
    }

    protected static InsnNode I2C() {
        return new InsnNode(146);
    }

    protected static InsnNode I2S() {
        return new InsnNode(147);
    }

    protected static InsnNode LCMP() {
        return new InsnNode(148);
    }

    protected static InsnNode FCMPL() {
        return new InsnNode(149);
    }

    protected static InsnNode FCMPG() {
        return new InsnNode(150);
    }

    protected static InsnNode DCMPL() {
        return new InsnNode(151);
    }

    protected static InsnNode DCMPG() {
        return new InsnNode(152);
    }

    protected static JumpInsnNode IFEQ(LabelNode label) {
        return new JumpInsnNode(153, label);
    }

    protected static JumpInsnNode IFNE(LabelNode label) {
        return new JumpInsnNode(154, label);
    }

    protected static JumpInsnNode IFLT(LabelNode label) {
        return new JumpInsnNode(155, label);
    }

    protected static JumpInsnNode IFGE(LabelNode label) {
        return new JumpInsnNode(156, label);
    }

    protected static JumpInsnNode IFGT(LabelNode label) {
        return new JumpInsnNode(157, label);
    }

    protected static JumpInsnNode IFLE(LabelNode label) {
        return new JumpInsnNode(158, label);
    }

    protected static JumpInsnNode IF_ICMPEQ(LabelNode label) {
        return new JumpInsnNode(159, label);
    }

    protected static JumpInsnNode IF_ICMPNE(LabelNode label) {
        return new JumpInsnNode(160, label);
    }

    protected static JumpInsnNode IF_ICMPLT(LabelNode label) {
        return new JumpInsnNode(161, label);
    }

    protected static JumpInsnNode IF_ICMPGE(LabelNode label) {
        return new JumpInsnNode(162, label);
    }

    protected static JumpInsnNode IF_ICMPGT(LabelNode label) {
        return new JumpInsnNode(163, label);
    }

    protected static JumpInsnNode IF_ICMPLE(LabelNode label) {
        return new JumpInsnNode(164, label);
    }

    protected static JumpInsnNode IF_ACMPEQ(LabelNode label) {
        return new JumpInsnNode(165, label);
    }

    protected static JumpInsnNode IF_ACMPNE(LabelNode label) {
        return new JumpInsnNode(166, label);
    }

    protected static JumpInsnNode GOTO(LabelNode label) {
        return new JumpInsnNode(167, label);
    }

    protected static JumpInsnNode JSR(LabelNode label) {
        return new JumpInsnNode(168, label);
    }

    protected static VarInsnNode RET(int i) {
        return new VarInsnNode(169, i);
    }

    protected static TableSwitchInsnNode TABLESWITCH(int min, int max, LabelNode dflt, LabelNode ... labels) {
        return new TableSwitchInsnNode(min, max, dflt, labels);
    }

    protected static LookupSwitchInsnNode LOOKUPSWITCH(LabelNode dflt, int[] keys, LabelNode[] labels) {
        return new LookupSwitchInsnNode(dflt, keys, labels);
    }

    protected static InsnNode IRETURN() {
        return new InsnNode(172);
    }

    protected static InsnNode LRETURN() {
        return new InsnNode(173);
    }

    protected static InsnNode FRETURN() {
        return new InsnNode(174);
    }

    protected static InsnNode DRETURN() {
        return new InsnNode(175);
    }

    protected static InsnNode ARETURN() {
        return new InsnNode(176);
    }

    protected static InsnNode RETURN() {
        return new InsnNode(177);
    }

    protected static FieldInsnNode GETSTATIC(String owner, String name, String desc) {
        return new FieldInsnNode(178, owner, name, desc);
    }

    protected static FieldInsnNode PUTSTATIC(String owner, String name, String desc) {
        return new FieldInsnNode(179, owner, name, desc);
    }

    protected static FieldInsnNode GETFIELD(String owner, String name, String desc) {
        return new FieldInsnNode(180, owner, name, desc);
    }

    protected static FieldInsnNode PUTFIELD(String owner, String name, String desc) {
        return new FieldInsnNode(181, owner, name, desc);
    }

    protected static MethodInsnNode INVOKEVIRTUAL(String owner, String name, String desc) {
        return new MethodInsnNode(182, owner, name, desc);
    }

    protected static MethodInsnNode INVOKESPECIAL(String owner, String name, String desc) {
        return new MethodInsnNode(183, owner, name, desc);
    }

    protected static MethodInsnNode INVOKESTATIC(String owner, String name, String desc) {
        return new MethodInsnNode(184, owner, name, desc);
    }

    protected static MethodInsnNode INVOKEINTERFACE(String owner, String name, String desc) {
        return new MethodInsnNode(185, owner, name, desc);
    }

    protected static InvokeDynamicInsnNode INVOKEDYNAMIC(String name, String desc, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        return new InvokeDynamicInsnNode(name, desc, bootstrapMethodHandle, bootstrapMethodArguments);
    }

    protected static TypeInsnNode NEW(String desc) {
        return new TypeInsnNode(187, desc);
    }

    protected static IntInsnNode NEWARRAY(int i) {
        return new IntInsnNode(188, i);
    }

    protected static TypeInsnNode ANEWARRAY(String desc) {
        return new TypeInsnNode(189, desc);
    }

    protected static InsnNode ARRAYLENGTH() {
        return new InsnNode(190);
    }

    protected static InsnNode ATHROW() {
        return new InsnNode(191);
    }

    protected static TypeInsnNode CHECKCAST(String desc) {
        return new TypeInsnNode(192, desc);
    }

    protected static TypeInsnNode INSTANCEOF(String desc) {
        return new TypeInsnNode(193, desc);
    }

    protected static InsnNode MONITORENTER() {
        return new InsnNode(194);
    }

    protected static InsnNode MONITOREXIT() {
        return new InsnNode(195);
    }

    protected static MultiANewArrayInsnNode MULTIANEWARRAY(String desc, int dim) {
        return new MultiANewArrayInsnNode(desc, dim);
    }

    protected static JumpInsnNode IFNULL(LabelNode label) {
        return new JumpInsnNode(198, label);
    }

    protected static JumpInsnNode IFNONNULL(LabelNode label) {
        return new JumpInsnNode(199, label);
    }

    private static interface PatchMethod {
        public boolean patch(PatchContext var1) throws Throwable;
    }
}

