/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.repack.com.unascribed.ears.common.debug;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pl.asie.foamfix.repack.com.unascribed.ears.common.EarsVersion;
import pl.asie.foamfix.repack.com.unascribed.ears.common.debug.EarsLogImpl;

public class EarsLog {
    public static final boolean DEBUG = EarsLogImpl.checkDebug();
    private static final Set<String> ONLY_DEBUG = EarsLogImpl.checkOnlyDebug();
    private static final Pattern BRACES_PATTERN = Pattern.compile("{}", 16);
    private static final long START = System.nanoTime();
    private static final long NANOS_TO_SECONDS = 1000000000L;
    private static final long NANOS_TO_MILLIS = 1000000L;

    public static boolean shouldLog(String tag) {
        return DEBUG && (ONLY_DEBUG == null || ONLY_DEBUG.contains(tag));
    }

    public static void debugva(String tag, String fmt, Object ... arg) {
        if (EarsLog.shouldLog(tag)) {
            StringBuffer buf = new StringBuffer();
            Matcher m = BRACES_PATTERN.matcher(fmt);
            int i = 0;
            while (m.find()) {
                m.appendReplacement(buf, arg != null && i < arg.length ? String.valueOf(arg[i]).replace("\\", "\\\\").replace("$", "\\$") : "{}");
                ++i;
            }
            m.appendTail(buf);
            long diff = System.nanoTime() - START;
            int secs = (int)(diff / 1000000000L);
            int millis = (int)(diff / 1000000L % 1000L);
            if (arg != null && arg.length > 0 && arg[arg.length - 1] instanceof Throwable) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ((Throwable)arg[arg.length - 1]).printStackTrace(pw);
                pw.flush();
                EarsLogImpl.log(sw.toString().trim());
            }
            EarsLogImpl.log(EarsLogImpl.buildMsg(secs, millis, tag, buf.toString()));
        }
    }

    public static void debug(String tag, String fmt) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, new Object[0]);
        }
    }

    public static void debug(String tag, String fmt, Object arg1) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1);
        }
    }

    public static void debug(String tag, String fmt, boolean arg1) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1);
        }
    }

    public static void debug(String tag, String fmt, int arg1) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1);
        }
    }

    public static void debug(String tag, String fmt, int arg1, Object arg2) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2);
        }
    }

    public static void debug(String tag, String fmt, Object arg1, Object arg2) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2);
        }
    }

    public static void debug(String tag, String fmt, Object arg1, float arg2) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, Float.valueOf(arg2));
        }
    }

    public static void debug(String tag, String fmt, Object arg1, Object arg2, float arg3) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, Float.valueOf(arg3));
        }
    }

    public static void debug(String tag, String fmt, int arg1, Object arg2, boolean arg3) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3);
        }
    }

    public static void debug(String tag, String fmt, Object arg1, Object arg2, Object arg3) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3);
        }
    }

    public static void debug(String tag, String fmt, int arg1, Object arg2, Object arg3) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3);
        }
    }

    public static void debug(String tag, String fmt, Object arg1, float arg2, float arg3) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, Float.valueOf(arg2), Float.valueOf(arg3));
        }
    }

    public static void debug(String tag, String fmt, float arg1, float arg2, float arg3) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, Float.valueOf(arg1), Float.valueOf(arg2), Float.valueOf(arg3));
        }
    }

    public static void debug(String tag, String fmt, int arg1, int arg2, Object arg3) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3);
        }
    }

    public static void debug(String tag, String fmt, float arg1, float arg2, float arg3, float arg4) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, Float.valueOf(arg1), Float.valueOf(arg2), Float.valueOf(arg3), Float.valueOf(arg4));
        }
    }

    public static void debug(String tag, String fmt, Object arg1, float arg2, float arg3, float arg4) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, Float.valueOf(arg2), Float.valueOf(arg3), Float.valueOf(arg4));
        }
    }

    public static void debug(String tag, String fmt, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3, arg4);
        }
    }

    public static void debug(String tag, String fmt, Object arg1, float arg2, float arg3, float arg4, float arg5) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, Float.valueOf(arg2), Float.valueOf(arg3), Float.valueOf(arg4), Float.valueOf(arg5));
        }
    }

    public static void debug(String tag, String fmt, Object arg1, int arg2, int arg3, int arg4, int arg5) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3, arg4, arg5);
        }
    }

    public static void debug(String tag, String fmt, int arg1, int arg2, int arg3, int arg4, boolean arg5) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3, arg4, arg5);
        }
    }

    public static void debug(String tag, String fmt, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3, arg4, arg5);
        }
    }

    public static void debug(String tag, String fmt, Object arg1, int arg2, int arg3, int arg4, int arg5, boolean arg6) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3, arg4, arg5, arg6);
        }
    }

    public static void debug(String tag, String fmt, Object arg1, Object arg2, int arg3, int arg4, int arg5, int arg6) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3, arg4, arg5, arg6);
        }
    }

    public static void debug(String tag, String fmt, int arg1, int arg2, int arg3, int arg4, Object arg5, Object arg6) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3, arg4, arg5, arg6);
        }
    }

    public static void debug(String tag, String fmt, int arg1, int arg2, int arg3, int arg4, Object arg5, Object arg6, Object arg7) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
        }
    }

    public static void debug(String tag, String fmt, Object arg1, float arg2, float arg3, float arg4, float arg5, float arg6, float arg7, float arg8) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, Float.valueOf(arg2), Float.valueOf(arg3), Float.valueOf(arg4), Float.valueOf(arg5), Float.valueOf(arg6), Float.valueOf(arg7), Float.valueOf(arg8));
        }
    }

    public static void debug(String tag, String fmt, Object arg1, Object arg2, int arg3, Object arg4, float arg5, float arg6, float arg7, float arg8, float arg9, float arg10) {
        if (EarsLog.shouldLog(tag)) {
            EarsLog.debugva(tag, fmt, arg1, arg2, arg3, arg4, Float.valueOf(arg5), Float.valueOf(arg6), Float.valueOf(arg7), Float.valueOf(arg8), Float.valueOf(arg9), Float.valueOf(arg10));
        }
    }

    static {
        if (DEBUG) {
            if (EarsVersion.PLATFORM != null) {
                EarsLog.debug("Common", "Hello, World! Ears Common v{}, {} Platform v{}", (Object)"1.4.2", (Object)EarsVersion.PLATFORM_KIND, (Object)EarsVersion.PLATFORM);
            } else {
                EarsLog.debug("Common", "Hello, World! Ears Common v{}", "1.4.2");
            }
            if (ONLY_DEBUG != null) {
                EarsLog.debug("Common", "Debugging is enabled with allowed tags {}", ONLY_DEBUG);
            } else {
                EarsLog.debug("Common", "Debugging is enabled with all tags");
            }
        }
    }
}

