/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.repack.com.unascribed.ears.common.util;

import java.io.IOException;
import java.io.OutputStream;

public final class Slice {
    private final byte[] arr;
    private final int ofs;
    private final int len;

    public Slice(byte[] arr) {
        this(arr, 0, arr.length);
    }

    public Slice(byte[] arr, int ofs, int len) {
        if (ofs < 0) {
            throw new IllegalArgumentException("offset cannot be negative");
        }
        if (ofs > arr.length) {
            throw new IllegalArgumentException("offset cannot be > length");
        }
        if (ofs + len > arr.length) {
            throw new IllegalArgumentException("slice cannot extend past the end of the array");
        }
        this.arr = arr;
        this.ofs = ofs;
        this.len = len;
    }

    public byte get(int idx) {
        if (idx >= this.len) {
            throw new IndexOutOfBoundsException(idx + " >= " + this.len);
        }
        return this.arr[this.ofs + idx];
    }

    public int size() {
        return this.len;
    }

    public Slice slice(int offset, int length) {
        return new Slice(this.arr, this.ofs + offset, length);
    }

    public Slice slice(int offset) {
        return new Slice(this.arr, this.ofs + offset, this.arr.length - (this.ofs + offset));
    }

    public byte[] toByteArray() {
        return Slice.of(this.arr, this.ofs, this.len);
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.arr, this.ofs, this.len);
    }

    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.len; ++i) {
            hashCode = 31 * hashCode + this.get(i);
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Slice other = (Slice)obj;
        if (this.len != other.len) {
            return false;
        }
        for (int i = 0; i < this.len; ++i) {
            if (this.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(byte[] bys) {
        return this.equals(bys, 0, bys.length);
    }

    public boolean equals(byte[] bys, int ofs, int len) {
        if (ofs < 0 || len < 0 || ofs + len > bys.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len != this.len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.get(i) == bys[ofs + i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int a = 0;
        int b = 0;
        for (int i = 0; i < this.size(); ++i) {
            a = (a + (this.get(i) & 0xFF)) % 65521;
            b = (b + a) % 65521;
        }
        return "[" + this.len + " bytes; a32(" + Integer.toHexString(b << 16 | a) + ")]";
    }

    public static byte[] of(byte[] arr, int ofs, int len) {
        byte[] dst = new byte[len];
        System.arraycopy(arr, ofs, dst, 0, len);
        return dst;
    }
}

