/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.doggystyle;

import com.seiferware.minecraft.doggystyle.EventController;
import com.seiferware.minecraft.doggystyle.items.CreativeTabDoggyStyle;
import com.seiferware.minecraft.doggystyle.utils.CommonProxy;
import com.seiferware.minecraft.doggystyle.utils.UpdateManager;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWood;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Logger;

@Mod(modid="doggystyle", version="1.1.3.99")
public class DoggyStyle {
    public static final boolean DEBUG_MODE;
    public static final String MODID = "doggystyle";
    public static final String[] SUPPORTED_WOODS;
    public static final String VERSION;
    public static final SimpleNetworkWrapper networkChannel;
    private static final String CLIENT_PROXY = "com.seiferware.minecraft.doggystyle.utils.ClientProxy";
    private static final String SERVER_PROXY = "com.seiferware.minecraft.doggystyle.utils.ServerProxy";
    public static Block BLOCK_DOG_HOUSE;
    public static Block BLOCK_HYDRANT;
    public static Block[] BLOCK_HERD_STAFF;
    public static Item ITEM_DOG_WHISTLE;
    public static DoggyStyle instance;
    public static Logger logger;
    @SidedProxy(clientSide="com.seiferware.minecraft.doggystyle.utils.ClientProxy", serverSide="com.seiferware.minecraft.doggystyle.utils.ServerProxy")
    public static CommonProxy proxy;
    private static Config config;
    private static Random rand;
    private static CreativeTabs tab;
    private static UpdateManager updater;

    public DoggyStyle() {
        instance = this;
    }

    public static Config getConfig() {
        return config;
    }

    public static Random getRand() {
        if (rand == null) {
            rand = proxy.getRand();
        }
        return rand;
    }

    public static CreativeTabs getTab() {
        return tab;
    }

    public static UpdateManager getUpdater() {
        return updater;
    }

    public static void sendDebugMessage(World world, String text) {
        boolean client = world.field_72995_K;
        DoggyStyle.sendDebugMessage((client ? "[Client]" : "[Server]") + " " + text);
    }

    public static void sendDebugMessage(String text) {
        if (!DEBUG_MODE) {
            return;
        }
        MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText("[DoggyStyle] " + text));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        EventController ec = new EventController();
        MinecraftForge.EVENT_BUS.register((Object)ec);
        FMLCommonHandler.instance().bus().register((Object)ec);
        tab = new CreativeTabDoggyStyle(CreativeTabs.getNextID(), MODID);
        proxy.registerBlocks();
        proxy.registerItems();
        proxy.registerMobs();
        proxy.registerMobRenderers();
        proxy.registerPackets();
        proxy.createRecipes();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        FMLInterModComms.sendRuntimeMessage((Object)MODID, (String)"VersionChecker", (String)"addVersionCheck", (String)"http://www.thegoldvane.com/modsupport/doggystyle/version.json");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (!Loader.isModLoaded((String)"VersionChecker")) {
            updater.checkForUpdates();
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        int spawnWeight = config.getInt("spawnChance", "World", 8, 0, 25, "How likely a dog is to spawn compared to other creatures. Set to 0 to disable spawning.");
        int spawnMin = config.getInt("spawnMin", "World", 1, 1, 10, "Minimum number of dogs that will spawn in a group.");
        int spawnMax = config.getInt("spawnMax", "World", 3, spawnMin, 10, "Maximum number of dogs that will spawn in a group.");
        boolean requireWhistle = config.getBoolean("requireWhistle", "Items", true, "Whether a dog whistle is required to open the dog menu. If false, an empty hand may also be used.");
        DoggyStyle.config.setSpawnWeight(spawnWeight);
        DoggyStyle.config.setSpawnMin(spawnMin);
        DoggyStyle.config.setSpawnMax(spawnMax);
        DoggyStyle.config.setRequireWhistle(requireWhistle);
        config.save();
    }

    static {
        SUPPORTED_WOODS = BlockWood.field_150096_a;
        BLOCK_HERD_STAFF = new Block[5];
        config = new Config();
        updater = new UpdateManager();
        InputStream in = DoggyStyle.class.getResourceAsStream("/doggystyle-version.properties");
        Properties props = new Properties();
        String v = "UNKNOWN_VERSION";
        String build = "?";
        boolean d = false;
        if (in != null) {
            try {
                props.load(in);
                build = props.getProperty("BUILD_NUMBER");
                v = props.getProperty("MAJOR_VERSION") + "." + props.getProperty("MINOR_VERSION") + "." + props.getProperty("REVISION_NUMBER") + "." + build;
                d = Boolean.parseBoolean(props.getProperty("DEBUG_MODE"));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        VERSION = v;
        DEBUG_MODE = d;
        networkChannel = NetworkRegistry.INSTANCE.newSimpleChannel(MODID + build);
    }

    public static class Config {
        private boolean requireWhistle = true;
        private int spawnMax = 3;
        private int spawnMin = 1;
        private int spawnWeight = 8;

        public boolean getRequireWhistle() {
            return this.requireWhistle;
        }

        public void setRequireWhistle(boolean requireWhistle) {
            this.requireWhistle = requireWhistle;
        }

        public int getSpawnMax() {
            return this.spawnMax;
        }

        public void setSpawnMax(int spawnMax) {
            this.spawnMax = spawnMax;
        }

        public int getSpawnMin() {
            return this.spawnMin;
        }

        public void setSpawnMin(int spawnMin) {
            this.spawnMin = spawnMin;
        }

        public int getSpawnWeight() {
            return this.spawnWeight;
        }

        public void setSpawnWeight(int spawnWeight) {
            this.spawnWeight = spawnWeight;
        }
    }
}

