/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.doggystyle.ai;

import com.seiferware.minecraft.doggystyle.entity.EntityDog;
import com.seiferware.minecraft.doggystyle.tileentity.TileEntityHerdStaff;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;

public class DogAIHerd
extends EntityAIBase {
    private final EntityDog target;
    private final PathNavigate nav;
    private PathNavigate victimNav;
    private static final int STAGE_SEARCHING = 0;
    private static final int STAGE_MEETING = 1;
    private static final int STAGE_RETURNING = 2;
    private static final int STAGE_FINISHED = 3;
    private int stage;
    private int radius = 2;
    private TileEntityHerdStaff staff;
    private EntityAnimal victim;
    private Class<? extends EntityAnimal> animalClass;
    private int updateTick;
    private final Set<EntityLiving> blackList = new HashSet<EntityLiving>();

    public DogAIHerd(EntityDog target) {
        this.target = target;
        this.func_75248_a(7);
        this.nav = target.func_70661_as();
    }

    public boolean func_75250_a() {
        if (this.target.getBehavior() == 5 && this.target.func_110175_bO()) {
            ChunkCoordinates cc = this.target.func_110172_bL();
            TileEntity tile = this.target.field_70170_p.func_147438_o(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c);
            if (tile instanceof TileEntityHerdStaff) {
                this.staff = (TileEntityHerdStaff)tile;
                return true;
            }
        }
        return false;
    }

    public void func_75251_c() {
        this.setStage(0);
        this.animalClass = null;
        this.staff = null;
        this.nav.func_75499_g();
    }

    public void func_75249_e() {
        this.setStage(0);
        switch (this.staff.getAnimalType()) {
            case 4: {
                this.animalClass = EntityChicken.class;
                break;
            }
            case 1: {
                this.animalClass = EntitySheep.class;
                break;
            }
            case 2: {
                this.animalClass = EntityCow.class;
                break;
            }
            case 3: {
                this.animalClass = EntityPig.class;
            }
        }
    }

    public boolean func_75253_b() {
        return this.target.getBehavior() == 5 && this.target.func_70638_az() == null && this.stage != 3 && !this.staff.func_145837_r() && this.target.func_110172_bL() != null && this.target.func_110172_bL().field_71574_a == this.staff.field_145851_c && this.target.func_110172_bL().field_71572_b == this.staff.field_145848_d && this.target.func_110172_bL().field_71573_c == this.staff.field_145849_e;
    }

    private void lookForVictim() {
        if (--this.updateTick <= 0) {
            this.updateTick = 10;
            AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)this.target.field_70165_t, (double)this.target.field_70163_u, (double)this.target.field_70161_v, (double)this.target.field_70165_t, (double)this.target.field_70163_u, (double)this.target.field_70161_v);
            List victims = this.target.field_70170_p.func_72872_a(this.animalClass, aabb.func_72314_b((double)this.radius, 5.0, (double)this.radius));
            double dis = Double.MAX_VALUE;
            EntityLiving acVic = null;
            for (EntityLiving victim : victims) {
                double vicDis;
                if (this.blackList.contains(victim) || !(victim.func_70092_e((double)this.staff.field_145851_c, (double)this.staff.field_145848_d, (double)this.staff.field_145849_e) > 36.0) || !((vicDis = victim.func_70068_e((Entity)this.target)) < dis)) continue;
                acVic = victim;
                dis = vicDis;
            }
            if (this.animalClass.isInstance(acVic)) {
                if (!this.nav.func_75497_a(acVic, 1.0)) {
                    this.blackList.add(acVic);
                    return;
                }
                this.victim = (EntityAnimal)acVic;
                this.victimNav = this.victim.func_70661_as();
                this.setStage(1);
                this.followVictim();
            } else if ((float)this.radius < this.nav.func_111269_d()) {
                this.radius *= 2;
            } else {
                this.target.playDogSound("whine");
                this.setStage(0);
                this.updateTick = 60;
            }
        }
    }

    private void setStage(int stage) {
        switch (stage) {
            case 0: {
                this.radius = 2;
                this.victim = null;
                this.updateTick = 0;
                this.blackList.clear();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.target.playDogSound("bark");
                break;
            }
            case 3: {
                this.target.setBehavior(1);
                if (this.victimNav == null) break;
                this.victimNav.func_75499_g();
            }
        }
        this.stage = stage;
        this.updateTick = 0;
    }

    private void followVictim() {
        if (--this.updateTick <= 0 || this.nav.func_75500_f()) {
            this.updateTick = 10;
            if (this.victim == null || this.victim.field_70128_L) {
                this.setStage(0);
                return;
            }
            if (this.stage == 2) {
                Vec3 close;
                if (this.target.func_70068_e((Entity)this.victim) > 25.0) {
                    this.setStage(1);
                } else if (this.victim.func_70092_e((double)this.staff.field_145851_c, (double)this.staff.field_145848_d, (double)this.staff.field_145849_e) < 3.0) {
                    this.setStage(3);
                } else if ((this.victimNav.func_75500_f() || this.target.func_70681_au().nextInt(20) == 0) && (close = RandomPositionGenerator.func_75464_a((EntityCreature)this.victim, (int)2, (int)2, (Vec3)Vec3.func_72443_a((double)this.staff.field_145851_c, (double)this.staff.field_145848_d, (double)this.staff.field_145849_e))) != null) {
                    this.victimNav.func_75492_a(close.field_72450_a, close.field_72448_b, close.field_72449_c, 1.0);
                }
            }
            if (this.stage == 1 && this.target.func_70068_e((Entity)this.victim) <= 4.0) {
                this.setStage(2);
            }
            if (this.target.func_70068_e((Entity)this.victim) >= 4.0) {
                if (!this.nav.func_75500_f()) {
                    this.nav.func_75499_g();
                }
                this.nav.func_75497_a((Entity)this.victim, 1.0);
            }
        }
    }

    public void func_75246_d() {
        switch (this.stage) {
            case 0: {
                this.lookForVictim();
                break;
            }
            case 1: 
            case 2: {
                this.followVictim();
            }
        }
    }
}

