/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.doggystyle.ai;

import com.seiferware.minecraft.doggystyle.entity.EntityDog;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;

public class DogAIRoam
extends EntityAIBase {
    private static final int ACTION_NOTHING = 0;
    private static final int ACTION_RELAX = 2;
    private static final int ACTION_WALK = 1;
    private final EntityDog target;
    private int action;
    private double lookX;
    private double lookZ;
    private int position;
    private int time;

    public DogAIRoam(EntityDog target) {
        this.target = target;
        this.func_75248_a(7);
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    public boolean func_75252_g() {
        return true;
    }

    public void func_75251_c() {
        this.target.setRoamPosition(0);
        this.target.func_70661_as().func_75499_g();
        this.action = 0;
    }

    public boolean func_75250_a() {
        return this.target.getBehavior() == 0 && this.target.func_70638_az() == null;
    }

    public void func_75249_e() {
        this.func_75246_d();
    }

    private void startRelax() {
        double dir = Math.PI * 2 * this.target.func_70681_au().nextDouble();
        this.lookX = Math.cos(dir);
        this.lookZ = Math.sin(dir);
        this.time = 80 + this.target.func_70681_au().nextInt(200);
        this.position = this.target.func_70681_au().nextInt(3);
        this.target.setRoamPosition(this.position);
        this.target.func_70661_as().func_75499_g();
        this.action = 2;
    }

    private void startWalk() {
        Vec3 vec3;
        if (this.target.func_110173_bK()) {
            vec3 = RandomPositionGenerator.func_75463_a((EntityCreature)this.target, (int)10, (int)7);
        } else {
            ChunkCoordinates chunkcoordinates = this.target.func_110172_bL();
            vec3 = RandomPositionGenerator.func_75464_a((EntityCreature)this.target, (int)16, (int)7, (Vec3)Vec3.func_72443_a((double)chunkcoordinates.field_71574_a, (double)chunkcoordinates.field_71572_b, (double)chunkcoordinates.field_71573_c));
        }
        if (vec3 != null) {
            double xPosition = vec3.field_72450_a;
            double yPosition = vec3.field_72448_b;
            double zPosition = vec3.field_72449_c;
            double speed = 1.0;
            this.target.setRoamPosition(0);
            this.target.func_70661_as().func_75492_a(xPosition, yPosition, zPosition, speed);
            this.action = 1;
        }
    }

    private void updateRelax() {
        if (--this.time <= 0) {
            this.action = 0;
        }
        this.target.func_70671_ap().func_75650_a(this.target.field_70165_t + this.lookX, this.target.field_70163_u + (double)this.target.func_70047_e(), this.target.field_70161_v + this.lookZ, 10.0f, (float)this.target.func_70646_bf());
        this.target.setRoamPosition(this.position);
    }

    public void func_75246_d() {
        switch (this.action) {
            case 2: {
                this.updateRelax();
                break;
            }
            case 1: {
                this.updateWalk();
                break;
            }
            default: {
                if (this.target.func_70681_au().nextBoolean()) {
                    this.startRelax();
                    break;
                }
                this.startWalk();
            }
        }
    }

    private void updateWalk() {
        if (this.target.func_70661_as().func_75500_f()) {
            this.action = 0;
        }
    }
}

