/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.doggystyle.blocks;

import com.seiferware.minecraft.doggystyle.DoggyStyle;
import com.seiferware.minecraft.doggystyle.entity.EntityDog;
import com.seiferware.minecraft.doggystyle.tileentity.TileEntityDogHouse;
import com.seiferware.minecraft.utils.blocks.EasierBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DogHouse
extends EasierBlock
implements ITileEntityProvider {
    private String myWood;

    public DogHouse() {
        this("oak");
    }

    public DogHouse(String wood) {
        super(Material.field_151575_d);
        this.func_149722_s().func_149672_a(field_149766_f).func_149663_c("dog_house").func_149658_d("planks_" + wood);
        this.myWood = wood;
    }

    public TileEntity func_149915_a(World world, int metaData) {
        return new TileEntityDogHouse();
    }

    public Item func_149694_d(World p_149694_1_, int p_149694_2_, int p_149694_3_, int p_149694_4_) {
        return super.func_149694_d(p_149694_1_, p_149694_2_, p_149694_3_, p_149694_4_);
    }

    public String func_149732_F() {
        return StatCollector.func_74838_a((String)"tile.dog_house.name") + " " + this.myWood;
    }

    public int func_149645_b() {
        return -2;
    }

    public String getWood() {
        return this.myWood;
    }

    public boolean func_149637_q() {
        return false;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntityDogHouse tileEntity = (TileEntityDogHouse)world.func_147438_o(x, y, z);
        if (tileEntity != null && tileEntity.getOwnerId().equals(player.func_110124_au().toString())) {
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == Items.field_151100_aR && !player.func_70093_af()) {
                ItemStack itemstack = player.func_70694_bm();
                int color = BlockColored.func_150032_b((int)itemstack.func_77960_j());
                tileEntity.setRoofColor(color);
                if (!player.field_71075_bZ.field_75098_d) {
                    --itemstack.field_77994_a;
                }
                if (itemstack.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
            } else if (tileEntity.getContainsDog()) {
                if (!tileEntity.isDogHealing()) {
                    if (!world.field_72995_K) {
                        tileEntity.releaseDog(player);
                    }
                } else if (!world.field_72995_K) {
                    tileEntity.playHurtSound();
                }
            } else if (player.func_70093_af()) {
                this.simpleBreak(world, x, y, z);
            } else if (tileEntity.getDogId().equals("")) {
                player.openGui((Object)DoggyStyle.instance, 3, world, x, y, z);
            }
            return true;
        }
        if (tileEntity != null && !tileEntity.getOwnerId().equals("")) {
            if (!world.field_72995_K) {
                // empty if block
            }
            return true;
        }
        if (player.func_70694_bm() == null || player.func_70694_bm().field_77994_a == 0) {
            if (!world.field_72995_K) {
                this.simpleBreak(world, x, y, z);
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack item) {
        super.func_149689_a(world, x, y, z, player, item);
        int dir = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
        TileEntityDogHouse tileEntity = (TileEntityDogHouse)world.func_147438_o(x, y, z);
        int color = tileEntity.getRoofColor();
        world.func_72921_c(x, y, z, color, 2);
        tileEntity.setFront(dir);
        tileEntity.setRoofColor(item.func_77960_j());
        tileEntity.setWood(this.myWood);
        if (player instanceof EntityPlayer) {
            tileEntity.setOwner((EntityPlayer)player);
        }
    }

    @Override
    public void func_149670_a(World world, int x, int y, int z, Entity collider) {
        if (!world.field_72995_K && collider instanceof EntityDog) {
            TileEntityDogHouse tileEntity = (TileEntityDogHouse)world.func_147438_o(x, y, z);
            EntityDog dog = (EntityDog)collider;
            if (tileEntity != null && !"".equals(tileEntity.getDogId()) && dog.getDogId().equals(tileEntity.getDogId()) && dog.getBehavior() == 3) {
                tileEntity.absorbDog(dog);
            }
        }
    }

    public boolean func_149646_a(IBlockAccess p_149646_1_, int p_149646_2_, int p_149646_3_, int p_149646_4_, int p_149646_5_) {
        return false;
    }

    @Override
    public void simpleBreak(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityDogHouse) {
            this.func_149642_a(world, x, y, z, new ItemStack((Block)this, 1, ((TileEntityDogHouse)tile).getRoofColor()));
            world.func_147468_f(x, y, z);
            world.func_147475_p(x, y, z);
        } else {
            super.simpleBreak(world, x, y, z);
        }
    }
}

