/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.doggystyle.blocks;

import com.seiferware.minecraft.doggystyle.DoggyStyle;
import com.seiferware.minecraft.doggystyle.tileentity.TileEntityHerdStaff;
import com.seiferware.minecraft.utils.blocks.EasierBlock;
import java.util.ArrayList;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class HerdStaff
extends EasierBlock
implements ITileEntityProvider {
    public static final int ANIMAL_SHEEP = 1;
    public static final int ANIMAL_COW = 2;
    public static final int ANIMAL_PIG = 3;
    public static final int ANIMAL_CHICKEN = 4;
    public static final String[] animalName = new String[]{null, "sheep", "cow", "pig", "chicken"};
    private final int animal;

    public HerdStaff(int animal) {
        super(Material.field_151575_d);
        this.animal = animal;
        this.func_149676_a(0.4f, 0.0f, 0.4f, 0.6f, 1.3125f, 0.6f);
        this.func_149663_c("herdStaff_" + animalName[animal]);
        this.func_149658_d("planks_oak");
    }

    public TileEntity func_149915_a(World w, int i) {
        TileEntityHerdStaff te = new TileEntityHerdStaff();
        te.setAnimalType(this.animal);
        return te;
    }

    public int func_149645_b() {
        return -2;
    }

    public boolean func_149637_q() {
        return false;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack item) {
        super.func_149689_a(world, x, y, z, player, item);
        world.func_72921_c(x, y, z, this.animal, 2);
        if (player instanceof EntityPlayer) {
            ((EntityPlayer)player).openGui((Object)DoggyStyle.instance, 4, world, x, y, z);
        }
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        player.openGui((Object)DoggyStyle.instance, 4, world, x, y, z);
        return true;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> res = new ArrayList<ItemStack>();
        res.add(new ItemStack(DoggyStyle.BLOCK_HERD_STAFF[this.animal]));
        return res;
    }
}

