/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.doggystyle.breeds;

import com.seiferware.minecraft.doggystyle.DoggyStyle;
import com.seiferware.minecraft.doggystyle.breeds.BreedAiredaleTerrier;
import com.seiferware.minecraft.doggystyle.breeds.BreedAmericanStaffordshireTerrier;
import com.seiferware.minecraft.doggystyle.breeds.BreedBeagle;
import com.seiferware.minecraft.doggystyle.breeds.BreedBerneseMountainDog;
import com.seiferware.minecraft.doggystyle.breeds.BreedBloodhound;
import com.seiferware.minecraft.doggystyle.breeds.BreedBoxer;
import com.seiferware.minecraft.doggystyle.breeds.BreedBullTerrier;
import com.seiferware.minecraft.doggystyle.breeds.BreedCardiganCorgi;
import com.seiferware.minecraft.doggystyle.breeds.BreedChihuahua;
import com.seiferware.minecraft.doggystyle.breeds.BreedDachshund;
import com.seiferware.minecraft.doggystyle.breeds.BreedDalmatian;
import com.seiferware.minecraft.doggystyle.breeds.BreedDoberman;
import com.seiferware.minecraft.doggystyle.breeds.BreedEnglishMastiff;
import com.seiferware.minecraft.doggystyle.breeds.BreedFrenchBulldog;
import com.seiferware.minecraft.doggystyle.breeds.BreedGermanShepherd;
import com.seiferware.minecraft.doggystyle.breeds.BreedGreatDane;
import com.seiferware.minecraft.doggystyle.breeds.BreedHusky;
import com.seiferware.minecraft.doggystyle.breeds.BreedJackRussellTerrier;
import com.seiferware.minecraft.doggystyle.breeds.BreedLabrador;
import com.seiferware.minecraft.doggystyle.breeds.BreedMiniaturePinscher;
import com.seiferware.minecraft.doggystyle.breeds.BreedMiniatureSchnauzer;
import com.seiferware.minecraft.doggystyle.breeds.BreedPembrokeCorgi;
import com.seiferware.minecraft.doggystyle.breeds.BreedPoodle;
import com.seiferware.minecraft.doggystyle.breeds.BreedPug;
import com.seiferware.minecraft.doggystyle.breeds.BreedStBernard;
import com.seiferware.minecraft.doggystyle.breeds.BreedToyPoodle;
import com.seiferware.minecraft.doggystyle.breeds.BreedWeimaraner;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.model.ModelBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public abstract class Breed {
    public static final int breedPembrokeCorgi = 0;
    public static final int breedBeagle = 1;
    public static final int breedDoberman = 2;
    public static final int breedChihuahua = 3;
    public static final int breedDalmatian = 4;
    public static final int breedGermanShepherd = 5;
    public static final int breedGreatDane = 6;
    public static final int breedHusky = 7;
    public static final int breedLabrador = 8;
    public static final int breedStBernard = 9;
    public static final int breedPoodle = 10;
    public static final int breedBoxer = 11;
    public static final int breedDachshund = 12;
    public static final int breedEnglishMastiff = 13;
    public static final int breedWeimaraner = 14;
    public static final int breedBullTerrier = 15;
    public static final int breedToyPoodle = 16;
    public static final int breedJackRussellTerrier = 17;
    public static final int breedFrenchBullDog = 18;
    public static final int breedCardiganCorgi = 19;
    public static final int breedAiredaleTerrier = 20;
    public static final int breedPug = 21;
    public static final int breedBerneseMountainDog = 22;
    public static final int breedAmericanStaffordshireTerrier = 23;
    public static final int breedBloodhound = 24;
    public static final int breedMiniaturePinscher = 25;
    public static final int breedMiniatureSchnauzer = 26;
    public static final String soundsBig = "doggystyle:mob.dogbig";
    public static final String soundsNormal = "mob.wolf";
    public static final String soundsSmall = "doggystyle:mob.dogsmall";
    protected static final float SIZE_HUGE = 1.0f;
    protected static final float SIZE_LARGE = 0.85f;
    protected static final float SIZE_MEDIUM = 0.7f;
    protected static final float SIZE_SMALL = 0.55f;
    protected static final float SIZE_TINY = 0.4f;
    protected static Breed[] breeds = new Breed[27];
    public static final BreedFilter FILTER_LARGE = new BreedFilter(){

        @Override
        public boolean applies(Breed breed) {
            return breed.getScale() >= 0.85f;
        }
    };
    public static final BreedFilter FILTER_MEDIUM = new BreedFilter(){

        @Override
        public boolean applies(Breed breed) {
            return breed.getScale() > 0.55f && breed.getScale() < 0.85f;
        }
    };
    public static final BreedFilter FILTER_SMALL = new BreedFilter(){

        @Override
        public boolean applies(Breed breed) {
            return breed.getScale() <= 0.55f;
        }
    };
    public static final BreedFilter FILTER_WILD_SPAWN = null;

    public static Breed getBreed(int id) {
        return breeds[id % breeds.length];
    }

    public static int getBreedCount() {
        return breeds.length;
    }

    public static Breed getMateBreed(Breed mom, Breed dad) {
        if (mom == null) {
            return dad;
        }
        if (dad == null) {
            return mom;
        }
        if (dad == mom) {
            return mom;
        }
        return null;
    }

    public static Breed getRandomBreed() {
        return Breed.getRandomBreed(null);
    }

    public static Breed getRandomBreed(BreedFilter filter) {
        if (filter == null) {
            return Breed.getBreed(DoggyStyle.getRand().nextInt(Breed.getBreedCount()));
        }
        ArrayList<Breed> breedList = new ArrayList<Breed>();
        for (Breed breed : breeds) {
            if (!filter.applies(breed)) continue;
            breedList.add(breed);
        }
        if (breedList.isEmpty()) {
            return null;
        }
        return (Breed)breedList.get(DoggyStyle.getRand().nextInt(breedList.size()));
    }

    public abstract int getBreedId();

    @SideOnly(value=Side.CLIENT)
    public abstract ResourceLocation getCoat(int var1);

    public abstract int getCoatCount();

    public abstract int getEggColor();

    public abstract int getEggSpotColor();

    public int getMaxLevel(int skill) {
        return 0;
    }

    public int getMinLevel(int skill) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract ModelBase getModel();

    public String getName() {
        return StatCollector.func_74838_a((String)("entity.doggystyle." + this.getUnlocalizedName() + ".name"));
    }

    public float getScale() {
        return 0.7f;
    }

    public String getSoundSet() {
        return soundsNormal;
    }

    public abstract String getUnlocalizedName();

    public boolean isDyeable() {
        return false;
    }

    public boolean isShearable() {
        return false;
    }

    static {
        Breed.breeds[0] = new BreedPembrokeCorgi();
        Breed.breeds[1] = new BreedBeagle();
        Breed.breeds[2] = new BreedDoberman();
        Breed.breeds[3] = new BreedChihuahua();
        Breed.breeds[4] = new BreedDalmatian();
        Breed.breeds[5] = new BreedGermanShepherd();
        Breed.breeds[6] = new BreedGreatDane();
        Breed.breeds[7] = new BreedHusky();
        Breed.breeds[8] = new BreedLabrador();
        Breed.breeds[9] = new BreedStBernard();
        Breed.breeds[10] = new BreedPoodle();
        Breed.breeds[11] = new BreedBoxer();
        Breed.breeds[12] = new BreedDachshund();
        Breed.breeds[13] = new BreedEnglishMastiff();
        Breed.breeds[14] = new BreedWeimaraner();
        Breed.breeds[15] = new BreedBullTerrier();
        Breed.breeds[16] = new BreedToyPoodle();
        Breed.breeds[17] = new BreedJackRussellTerrier();
        Breed.breeds[18] = new BreedFrenchBulldog();
        Breed.breeds[19] = new BreedCardiganCorgi();
        Breed.breeds[20] = new BreedAiredaleTerrier();
        Breed.breeds[21] = new BreedPug();
        Breed.breeds[22] = new BreedBerneseMountainDog();
        Breed.breeds[23] = new BreedAmericanStaffordshireTerrier();
        Breed.breeds[24] = new BreedBloodhound();
        Breed.breeds[25] = new BreedMiniaturePinscher();
        Breed.breeds[26] = new BreedMiniatureSchnauzer();
    }

    public static interface BreedFilter {
        public boolean applies(Breed var1);
    }
}

