/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.doggystyle.entity;

import com.seiferware.minecraft.doggystyle.DoggyStyle;
import com.seiferware.minecraft.doggystyle.ai.DogAIFollowMom;
import com.seiferware.minecraft.doggystyle.ai.DogAIFollowOwner;
import com.seiferware.minecraft.doggystyle.ai.DogAIHerd;
import com.seiferware.minecraft.doggystyle.ai.DogAIMode;
import com.seiferware.minecraft.doggystyle.ai.DogAIRoam;
import com.seiferware.minecraft.doggystyle.ai.DogAISit;
import com.seiferware.minecraft.doggystyle.ai.DogAISkill;
import com.seiferware.minecraft.doggystyle.breeds.Breed;
import com.seiferware.minecraft.doggystyle.skills.DogSkill;
import com.seiferware.minecraft.doggystyle.tileentity.TileEntityDogHouse;
import com.seiferware.minecraft.doggystyle.utils.DogData;
import com.seiferware.minecraft.doggystyle.utils.DogSkills;
import com.seiferware.minecraft.utils.data.EntityData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.IShearable;

public class EntityDog
extends EntityTameable
implements IShearable {
    public static final int behaveRoam = 0;
    public static final int behaveStay = 1;
    public static final int behaveFollow = 2;
    public static final int behaveGoHome = 3;
    public static final int behaveLieDown = 4;
    public static final int behaveActiveSkill = 5;
    public static final int originSpawn = 0;
    public static final int originEgg = 1;
    public static final int originBreed = 2;
    public static final int originHydrant = 3;
    public static final int positionHouse = -1;
    public static final int positionStanding = 0;
    public static final int positionSitting = 1;
    public static final int positionProne = 2;
    public static final int valueCollarColor = 0;
    public static final int valueBehavior = 1;
    public static final int valueBreed = 2;
    public static final int valueCoat = 3;
    public static final int valueHasCollar = 4;
    public static final int valueGeneration = 5;
    public static final int valueHomeX = 6;
    public static final int valueHomeY = 7;
    public static final int valueHomeZ = 8;
    public static final int valueHasHome = 9;
    public static final int valueRoamPointX = 10;
    public static final int valueRoamPointY = 11;
    public static final int valueRoamPointZ = 12;
    public static final int valueRoamPointDistance = 13;
    public static final int valueOrigin = 14;
    public static final int valueGender = 15;
    public static final int valuePosition = 16;
    public static final int valueDogId = 17;
    public static final int valueOwnerName = 18;
    public static final int valueDyeColor = 19;
    public static final int valueDyePresent = 20;
    public static final int valueSheared = 21;
    public static final int valueMomId = 22;
    public static final int valueSaveVersion = 23;
    public static final int versionOld = 0;
    public static final int versionOrigSkills = 1;
    protected final EntityData dogData = new DogData((Entity)this, 21);
    protected final EntityData dogSkills = new DogSkills((Entity)this, 22);
    private int animationTime;
    private final ChunkCoordinates chunk = new ChunkCoordinates();
    private float field_70924_f;
    private float field_70926_e;
    private int lastBreed = -1;
    private EntityDog mom;
    private boolean needsBreedCoat = true;
    private final Set<EntityDog> puppies = new HashSet<EntityDog>();
    private int shearTimer;
    private Breed.BreedFilter breedFilter;

    public EntityDog(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.func_70661_as().func_75491_a(true);
        int t = 1;
        this.field_70714_bg.func_75776_a(t++, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(t++, (EntityAIBase)new DogAIFollowMom(this, 1.0f, 5.0f));
        this.field_70714_bg.func_75776_a(t++, (EntityAIBase)new DogAISkill((EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f), this, 0));
        this.field_70714_bg.func_75776_a(t++, (EntityAIBase)new DogAISkill((EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true), this, 0));
        this.field_70714_bg.func_75776_a(t++, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(t++, (EntityAIBase)new DogAISkill(new DogAIHerd(this), this, 4));
        this.field_70714_bg.func_75776_a(t++, (EntityAIBase)new DogAIMode(new DogAISit(this), this, 3));
        this.field_70714_bg.func_75776_a(t++, (EntityAIBase)new DogAIMode(new DogAISit(this), this, 1));
        this.field_70714_bg.func_75776_a(t++, (EntityAIBase)new DogAIMode(new DogAISit(this), this, 4));
        this.field_70714_bg.func_75776_a(t++, (EntityAIBase)new DogAIMode(new DogAIFollowOwner(this, 2.0f, 10.0f), this, 2));
        this.field_70714_bg.func_75776_a(t++, (EntityAIBase)new DogAIRoam(this));
        this.field_70714_bg.func_75776_a(t++, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.dogData.setInt(14, 0);
        this.dogData.setBool(15, this.field_70146_Z.nextBoolean());
        this.dogData.setString(17, UUID.randomUUID().toString());
        this.animationTime = this.field_70146_Z.nextInt(240);
    }

    public EntityDog(World world, Breed.BreedFilter breedFilter) {
        this(world);
        this.breedFilter = breedFilter;
    }

    public EntityDog(World world, String allDogData, String allSkillData) {
        this(world);
        this.dogData.setAllData(allDogData);
        this.dogSkills.setAllData(allSkillData);
        this.applyDogAttributes();
        this.needsBreedCoat = false;
        if (!this.field_70170_p.field_72995_K && "".equals(this.getDogId())) {
            this.dogData.setString(17, UUID.randomUUID().toString());
        }
    }

    public void checkSaveVersion() {
        if (this.dogData.getInt(23) < 1) {
            int s;
            int[] sks = new int[DogSkill.getSkillCount()];
            for (s = 0; s < DogSkill.getSkillCount(); ++s) {
                sks[s] = this.dogSkills.getInt(s);
            }
            for (s = 0; s < DogSkill.getSkillCount(); ++s) {
                this.setSkill(s, sks[s]);
                this.setOrigSkill(s, sks[s]);
            }
        }
        this.dogData.setInt(23, 1);
    }

    public void addPuppy(EntityDog puppy) {
        this.puppies.add(puppy);
    }

    private void applyDogAttributes() {
        this.func_70105_a(0.0f, 0.0f);
        this.func_70105_a(1.0f * this.getBreed().getScale(), 1.0f * this.getBreed().getScale());
        this.func_98054_a(this.func_70631_g_());
        if (!this.field_70170_p.field_72995_K) {
            int max = DogSkill.getSkillCount();
            for (int i = 0; i < max; ++i) {
                int sk = this.getSkill(i);
                int osk = this.getOrigSkill(i);
                int l = this.getBreed().getMinLevel(i);
                int h = this.getBreed().getMaxLevel(i);
                if (sk < l) {
                    this.setSkill(i, l);
                    DogSkill.getSkill(i).onChange(this, l);
                } else if (sk > h) {
                    this.setSkill(i, h);
                    DogSkill.getSkill(i).onChange(this, h);
                }
                if (osk < l) {
                    this.setOrigSkill(i, l);
                    continue;
                }
                if (osk <= h) continue;
                this.setOrigSkill(i, h);
            }
            this.checkSaveVersion();
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        if (this.func_70909_n()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    public boolean func_70652_k(Entity par1Entity) {
        int i = this.getSkill(0);
        return par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)i);
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.func_85032_ar()) {
            return false;
        }
        Entity entity = par1DamageSource.func_76346_g();
        if (this.getBehavior() == 1) {
            this.setBehavior(0);
        }
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            par2 = (par2 + 1.0f) / 2.0f;
        }
        if (this.func_70909_n() && par2 >= this.func_110143_aJ() && this.hasDogHouse()) {
            par2 = this.func_110143_aJ() - 1.0f;
            this.setBehavior(3);
            EntityPlayer owner = (EntityPlayer)this.func_70902_q();
            if (owner != null) {
                owner.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"text.doggystyle.dogdied").replace("%", this.func_70005_c_())));
            }
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    protected boolean func_70692_ba() {
        return !this.func_70909_n() && this.field_70173_aa > 2400;
    }

    public boolean canInteract(EntityPlayer player) {
        return this.func_70909_n() && this.deobfGetOwnerId().equalsIgnoreCase(player.func_110124_au().toString());
    }

    public boolean func_70878_b(EntityAnimal par1EntityAnimal) {
        if (par1EntityAnimal == this) {
            return false;
        }
        if (!(par1EntityAnimal instanceof EntityDog)) {
            return false;
        }
        EntityDog dog = (EntityDog)par1EntityAnimal;
        if (dog.isMale() == this.isMale()) {
            return false;
        }
        if (!dog.func_70909_n() || dog.getMode() != 0 || !dog.func_70880_s()) {
            return false;
        }
        if (!this.func_70909_n() || this.getMode() != 0 || !this.func_70880_s()) {
            return false;
        }
        return Breed.getMateBreed(this.getBreed(), dog.getBreed()) != null;
    }

    private void checkResize() {
        if (this.field_70170_p.field_72995_K && this.lastBreed != this.getBreedID()) {
            this.lastBreed = this.getBreedID();
            this.applyDogAttributes();
        }
    }

    public void clearCollar() {
        this.dogData.setBool(4, false);
    }

    public void clearDogHouse() {
        this.dogData.setBool(9, false);
    }

    public void clearDye() {
        this.dogData.setBool(20, false);
    }

    public EntityAgeable func_90011_a(EntityAgeable otherParent) {
        EntityDog baby = new EntityDog(this.field_70170_p);
        String s = this.deobfGetOwnerId();
        if (s != null && !s.trim().isEmpty()) {
            baby.deobfSetOwnerId(s);
            baby.func_70903_f(true);
            baby.dogData.setInt(14, 2);
        }
        if (otherParent != null && otherParent instanceof EntityDog) {
            EntityDog dad = (EntityDog)otherParent;
            Breed babyBreed = Breed.getMateBreed(this.getBreed(), dad.getBreed());
            if (babyBreed == null) {
                return null;
            }
            if (babyBreed == this.getBreed()) {
                this.makeBabyInherit(baby);
                if (dad.getBreedID() == this.getBreedID()) {
                    int gen = Math.min(this.getGeneration(), dad.getGeneration());
                    baby.setGeneration(gen + 1);
                }
            } else if (babyBreed == dad.getBreed()) {
                dad.makeBabyInherit(baby);
            } else {
                baby.setBreedID(babyBreed.getBreedId());
                int coatCount = babyBreed.getCoatCount();
                baby.setCoatID(this.field_70146_Z.nextInt(coatCount));
            }
            if (this.isMale()) {
                baby.setMom(dad);
                if (!dad.verifyDogHouseExists()) {
                    dad.sendOwnerMessage(StatCollector.func_74838_a((String)"text.doggystyle.momneedshome"));
                    return null;
                }
            }
        } else {
            this.makeBabyInherit(baby);
        }
        if (!this.isMale()) {
            baby.setMom(this);
            if (!this.verifyDogHouseExists()) {
                this.sendOwnerMessage(StatCollector.func_74838_a((String)"text.doggystyle.momneedshome"));
                return null;
            }
        }
        baby.initSkills();
        baby.setBehavior(0);
        return baby;
    }

    public String deobfGetOwnerId() {
        return this.func_152113_b();
    }

    public void deobfSetOwnerId(String p_152115_1_) {
        this.func_152115_b(p_152115_1_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)Float.valueOf(this.func_110143_aJ()));
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)((byte)BlockColored.func_150032_b((int)1)));
    }

    public void playDogSound(String soundSubName) {
        this.func_85030_a(this.getBreed().getSoundSet() + "." + soundSubName, this.func_70599_aP(), this.func_70647_i());
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
        this.func_85030_a(this.getBreed().getSoundSet() + ".step", 0.15f, 1.0f);
    }

    public int getAnimationTime() {
        return this.animationTime;
    }

    public int getBehavior() {
        return this.dogData.getInt(1);
    }

    public void setBehavior(int behavior) {
        this.dogData.setInt(1, behavior);
        if (behavior == 0) {
            ChunkCoordinates home = this.getDogHouseIfExists();
            if (home != null && home.func_71569_e(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)) < 400.0f) {
                this.func_110171_b(home.field_71574_a, home.field_71572_b, home.field_71573_c, 20);
            } else {
                this.func_110171_b(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v), 20);
            }
        } else {
            this.func_70661_as().func_75499_g();
        }
    }

    public AxisAlignedBB func_70046_E() {
        this.checkResize();
        return super.func_70046_E();
    }

    public Breed getBreed() {
        return Breed.getBreed(this.dogData.getInt(2));
    }

    public int getBreedID() {
        return this.dogData.getInt(2);
    }

    public void setBreedID(int breed) {
        this.dogData.setInt(2, breed);
        this.applyDogAttributes();
        this.needsBreedCoat = false;
    }

    public int getCoatID() {
        return this.dogData.getInt(3);
    }

    public void setCoatID(int value) {
        this.dogData.setInt(3, value);
    }

    public int getCollarColor() {
        return this.dogData.getBool(4) ? this.dogData.getInt(0) : -1;
    }

    public void setCollarColor(int collarColor) {
        this.dogData.setInt(0, collarColor);
        this.dogData.setBool(4, true);
    }

    public String func_70005_c_() {
        if (this.func_94056_bM()) {
            if (this.getMom() == null) {
                return this.func_94057_bL();
            }
            return this.func_94057_bL();
        }
        return this.getBreed().getName();
    }

    protected String func_70673_aS() {
        return this.getBreed().getSoundSet() + ".death";
    }

    public EntityData getDogData() {
        return this.dogData;
    }

    public ChunkCoordinates getDogHouseIfExists() {
        TileEntity house;
        if (!this.hasDogHouse()) {
            return null;
        }
        ChunkCoordinates home = this.getDogHouseLocation();
        Chunk chunk = this.field_70170_p.func_72938_d(home.field_71574_a, home.field_71573_c);
        if (!chunk.field_76636_d) {
            this.field_70170_p.func_72863_F().func_73158_c(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
        }
        if ((house = this.field_70170_p.func_147438_o(home.field_71574_a, home.field_71572_b, home.field_71573_c)) == null || !(house instanceof TileEntityDogHouse)) {
            this.clearDogHouse();
            return null;
        }
        if (!((TileEntityDogHouse)house).getDogId().equals(this.getDogId())) {
            this.clearDogHouse();
            return null;
        }
        return home;
    }

    public ChunkCoordinates getDogHouseLocation() {
        ChunkCoordinates coords = new ChunkCoordinates();
        if (this.dogData.getBool(9)) {
            coords.func_71571_b(this.dogData.getInt(6), this.dogData.getInt(7), this.dogData.getInt(8));
        }
        return coords;
    }

    public String getDogId() {
        return this.dogData.getString(17);
    }

    public EntityData getDogSkills() {
        return this.dogSkills;
    }

    protected Item func_146068_u() {
        return Item.func_150899_d((int)-1);
    }

    public int getDyeColor() {
        return this.dogData.getBool(20) ? this.dogData.getInt(19) : 0;
    }

    public void setDyeColor(int dyeColor) {
        this.dogData.setInt(19, dyeColor);
        this.dogData.setBool(20, true);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public int getGeneration() {
        return this.dogData.getInt(5);
    }

    public void setGeneration(int gen) {
        this.dogData.setInt(5, gen);
    }

    public ChunkCoordinates func_110172_bL() {
        this.chunk.func_71571_b(this.dogData.getInt(10), this.dogData.getInt(11), this.dogData.getInt(12));
        return this.chunk;
    }

    protected String func_70621_aR() {
        return this.getBreed().getSoundSet() + ".hurt";
    }

    @SideOnly(value=Side.CLIENT)
    public float getInterestedAngle(float par1) {
        return (this.field_70924_f + (this.field_70926_e - this.field_70924_f) * par1) * 0.15f * (float)Math.PI;
    }

    protected String func_70639_aQ() {
        return this.isAngry() ? this.getBreed().getSoundSet() + ".growl" : (this.field_70146_Z.nextInt(3) == 0 ? (this.func_70909_n() && this.field_70180_af.func_111145_d(18) < 10.0f ? this.getBreed().getSoundSet() + ".whine" : this.getBreed().getSoundSet() + ".panting") : this.getBreed().getSoundSet() + ".bark");
    }

    public int func_70641_bl() {
        return 8;
    }

    public int getMode() {
        if (this.getBehavior() == 1) {
            return 1;
        }
        if (this.getBehavior() == 4) {
            return 2;
        }
        if (this.getBehavior() == 0) {
            return this.getRoamPosition();
        }
        return 0;
    }

    public EntityDog getMom() {
        if (!this.func_70631_g_()) {
            return null;
        }
        if (this.mom != null) {
            return this.mom;
        }
        final String momId = this.dogData.getString(22);
        if (momId == null || "".equals(momId)) {
            return null;
        }
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.field_70161_v, (double)this.field_70163_u, (double)this.field_70161_v);
        EntityDog[] theMom = this.field_70170_p.func_82733_a(EntityDog.class, bb.func_72314_b(100.0, 100.0, 100.0), new IEntitySelector(){

            public boolean func_82704_a(Entity dog) {
                return dog instanceof EntityDog && ((EntityDog)dog).getDogId().equals(momId);
            }
        }).toArray(new EntityDog[1]);
        if (theMom.length > 0) {
            return theMom[0];
        }
        if (DoggyStyle.proxy.isClient()) {
            Object[] moms;
            for (Object dog : moms = this.field_70170_p.func_72910_y().toArray()) {
                if (!(dog instanceof EntityDog) || !((EntityDog)((Object)dog)).getDogId().equals(momId)) continue;
                this.mom = (EntityDog)((Object)dog);
                this.mom.addPuppy(this);
                return this.mom;
            }
        }
        return null;
    }

    public void setMom(EntityDog mom) {
        this.mom = mom;
        if (mom == null) {
            this.dogData.setString(22, "");
        } else {
            mom.addPuppy(this);
            this.dogData.setString(22, mom.getDogId());
        }
    }

    public String getOwnerName() {
        if (!this.func_70909_n()) {
            return null;
        }
        EntityLivingBase owner = this.func_70902_q();
        if (owner == null) {
            return this.dogData.getString(18);
        }
        return owner.func_70005_c_();
    }

    public Set<EntityDog> getPuppies() {
        return this.puppies;
    }

    public float func_70603_bj() {
        return this.getBreed().getScale() * (this.func_70631_g_() ? 0.5f : 1.0f) * super.func_70603_bj();
    }

    public int getRoamPosition() {
        return this.dogData.getInt(16);
    }

    public void setRoamPosition(int value) {
        this.dogData.setInt(16, value);
    }

    public int getSkill(int skillID) {
        if (this.dogSkills == null) {
            return 0;
        }
        return this.dogSkills.getInt(skillID * 2);
    }

    public int getOrigSkill(int skillId) {
        if (this.dogSkills == null) {
            return 0;
        }
        return this.dogSkills.getInt(skillId * 2 + 1);
    }

    public boolean getSkillAvailable(int id) {
        if (DogSkill.getSkill(id) == null) {
            return true;
        }
        if (this.getSkill(id) <= 0) {
            return false;
        }
        if (DogSkill.getSkill(id).getType() != 3) {
            return true;
        }
        return true;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getTailRotation() {
        return this.isAngry() ? 0.0f : (this.func_70909_n() ? (0.55f - (20.0f - this.field_70180_af.func_111145_d(18)) * 0.02f) * (float)Math.PI : 0.62831855f);
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    public boolean hasDogHouse() {
        return this.dogData.getBool(9);
    }

    public boolean func_110175_bO() {
        return this.dogData.getInt(13) != -1;
    }

    public void initSkills() {
        for (int i = 0; i < DogSkill.getSkillCount(); ++i) {
            DogSkill ds = DogSkill.getSkill(i);
            if (ds.getType() == 1) {
                this.setSkill(i, ds.generateStat(this.getBreed().getMinLevel(i), this.getBreed().getMaxLevel(i), this.getGeneration()));
                continue;
            }
            if (ds.getType() == 5) {
                if (ds.generationForNaturalTalent() >= 0 && this.getGeneration() >= ds.generationForNaturalTalent()) {
                    this.setSkill(i, this.getBreed().getMaxLevel(i));
                    continue;
                }
                this.setSkill(i, this.getBreed().getMinLevel(i));
                continue;
            }
            this.setSkill(i, this.getBreed().getMinLevel(i));
        }
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (this.canInteract(player)) {
            EntityLivingBase owner = this.func_70902_q();
            if (owner != null) {
                this.dogData.setString(18, owner.func_70005_c_());
            }
            if (itemstack != null && itemstack.func_77973_b() == Items.field_151057_cb) {
                player.openGui((Object)DoggyStyle.instance, 2, this.field_70170_p, this.func_145782_y(), 0, 0);
                return true;
            }
            if (itemstack != null && itemstack.func_77973_b() == Items.field_151100_aR) {
                if (player.func_70093_af()) {
                    if (!this.isDyeable()) return super.func_70085_c(player);
                    if (!this.field_70170_p.field_72995_K) {
                        this.setDyeColor(BlockColored.func_150032_b((int)itemstack.func_77973_b().getDamage(itemstack)));
                    }
                } else if (!this.field_70170_p.field_72995_K) {
                    this.setCollarColor(BlockColored.func_150032_b((int)itemstack.func_77973_b().getDamage(itemstack)));
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    --itemstack.field_77994_a;
                }
                if (itemstack.field_77994_a > 0) return true;
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                return true;
            }
            if ((itemstack == null || itemstack.func_77973_b() == null) && !DoggyStyle.getConfig().getRequireWhistle() || itemstack != null && itemstack.func_77973_b() == DoggyStyle.ITEM_DOG_WHISTLE) {
                if (this.func_94056_bM()) {
                    player.openGui((Object)DoggyStyle.instance, 1, this.field_70170_p, this.func_145782_y(), 0, 0);
                    return true;
                } else {
                    player.openGui((Object)DoggyStyle.instance, 2, this.field_70170_p, this.func_145782_y(), 0, 0);
                }
                return true;
            }
            if (DoggyStyle.DEBUG_MODE && itemstack != null && itemstack.func_77973_b() == Items.field_151097_aZ) {
                if (this.field_70170_p.field_72995_K) return true;
                int coat = this.getCoatID();
                if (coat == this.getBreed().getCoatCount() - 1) {
                    coat = 0;
                    this.setBreedID((this.getBreedID() + 1) % Breed.getBreedCount());
                } else {
                    ++coat;
                }
                this.setCoatID(coat);
                return true;
            }
            if (itemstack == null || !this.func_70877_b(itemstack) || !this.isSheared()) return super.func_70085_c(player);
            this.setSheared(false);
            this.field_70170_p.func_72956_a((Entity)this, "random.eat", 0.5f, this.field_70146_Z.nextFloat() * 0.1f + 0.9f);
            if (!player.field_71075_bZ.field_75098_d) {
                --itemstack.field_77994_a;
            }
            if (itemstack.field_77994_a > 0) return true;
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            return true;
        }
        if (!this.func_70909_n()) {
            if (itemstack == null || itemstack.func_77973_b() != Items.field_151103_aS || this.isAngry()) return super.func_70085_c(player);
            if (!player.field_71075_bZ.field_75098_d) {
                --itemstack.field_77994_a;
            }
            if (itemstack.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70911_d.func_75270_a(true);
                this.func_70908_e(true);
                this.setTamedBy(player);
                this.setBehavior(2);
                return true;
            } else {
                player.openGui((Object)DoggyStyle.instance, 2, this.field_70170_p, this.func_145782_y(), 0, 0);
            }
            return true;
        }
        if ((itemstack != null && itemstack.func_77973_b() != null || DoggyStyle.getConfig().getRequireWhistle()) && (itemstack == null || itemstack.func_77973_b() != DoggyStyle.ITEM_DOG_WHISTLE)) return super.func_70085_c(player);
        player.openGui((Object)DoggyStyle.instance, 1, this.field_70170_p, this.func_145782_y(), 0, 0);
        return true;
    }

    public boolean func_70650_aV() {
        return true;
    }

    public boolean isAngry() {
        return (this.field_70180_af.func_75683_a(16) & 2) != 0;
    }

    public void setAngry(boolean par1) {
        byte b0 = this.field_70180_af.func_75683_a(16);
        if (par1) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b0 | 2)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b0 & 0xFFFFFFFD)));
        }
    }

    public boolean func_70877_b(ItemStack par1ItemStack) {
        return par1ItemStack != null && par1ItemStack.func_77973_b() instanceof ItemFood && ((ItemFood)par1ItemStack.func_77973_b()).func_77845_h();
    }

    public boolean isDyeable() {
        return this.getBreed().isDyeable();
    }

    public boolean func_85032_ar() {
        return this.getBehavior() == 3 || super.func_85032_ar();
    }

    public boolean isMale() {
        return this.dogData.getBool(15);
    }

    public boolean isShearable() {
        return this.getBreed().isShearable() && !this.isSheared() && !this.func_70631_g_();
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return this.isShearable();
    }

    public boolean isSheared() {
        return this.getDogData().getBool(21);
    }

    public void setSheared(boolean sheared) {
        this.getDogData().setBool(21, sheared);
    }

    public boolean func_110176_b(int x, int y, int z) {
        int maxDistance = this.dogData.getInt(13);
        return maxDistance <= 0 || this.func_110172_bL().func_71569_e(x, y, z) <= (float)(maxDistance * maxDistance);
    }

    private void makeBabyInherit(EntityDog baby) {
        baby.setBreedID(this.getBreedID());
        if (this.field_70146_Z.nextBoolean()) {
            baby.setCoatID(this.getCoatID());
        } else {
            int coats = baby.getBreed().getCoatCount();
            baby.setCoatID(this.field_70146_Z.nextInt(coats));
        }
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        this.setSheared(true);
        ret.add(new ItemStack(Blocks.field_150325_L, 1, this.getDyeColor()));
        this.func_85030_a("mob.sheep.shear", 1.0f, 1.0f);
        return ret;
    }

    public IEntityLivingData func_110161_a(IEntityLivingData par1EntityLivingData) {
        if (this.needsBreedCoat) {
            this.setBreedID(Breed.getRandomBreed(this.breedFilter == null ? Breed.FILTER_WILD_SPAWN : this.breedFilter).getBreedId());
            int coats = this.getBreed().getCoatCount();
            this.setCoatID(this.field_70146_Z.nextInt(coats));
            this.needsBreedCoat = false;
            if (this.getBreedID() == 10 || this.getBreedID() == 16) {
                switch (this.getCoatID()) {
                    case 1: {
                        this.setDyeColor(7);
                        break;
                    }
                    case 2: {
                        this.setDyeColor(15);
                        break;
                    }
                    default: {
                        this.setDyeColor(0);
                    }
                }
            }
        }
        this.initSkills();
        this.applyDogAttributes();
        return super.func_110161_a(par1EntityLivingData);
    }

    public boolean getCanSpawnHereHydrant() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        return this.field_70170_p.func_72883_k(i, j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v)) > 8 && this.func_70783_a(i, j, k) >= 0.0f && this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.animationTime;
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.dogData.readFromNBT(nbt);
        this.dogSkills.readFromNBT(nbt);
        if (!this.field_70170_p.field_72995_K && "".equals(this.getDogId())) {
            this.dogData.setString(17, UUID.randomUUID().toString());
        }
        this.shearTimer = nbt.func_74762_e("shearTimer");
        this.applyDogAttributes();
    }

    public void func_70020_e(NBTTagCompound nbt) {
        super.func_70020_e(nbt);
        this.dogData.readFromNBT(nbt);
        this.dogSkills.readFromNBT(nbt);
        if (!this.field_70170_p.field_72995_K && "".equals(this.getDogId())) {
            this.dogData.setString(17, UUID.randomUUID().toString());
        }
        this.shearTimer = nbt.func_74762_e("shearTimer");
        this.applyDogAttributes();
    }

    public void sendOwnerMessage(String string) {
        EntityLivingBase owner = this.func_70902_q();
        if (owner != null && owner instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)owner;
            player.func_145747_a((IChatComponent)new ChatComponentText(string.replace("%", this.func_70005_c_())));
        }
    }

    public void func_70624_b(EntityLivingBase par1EntityLivingBase) {
        super.func_70624_b(par1EntityLivingBase);
        if (par1EntityLivingBase == null) {
            this.setAngry(false);
        } else if (!this.func_70909_n()) {
            this.setAngry(true);
        }
    }

    public void setDogHouseLocation(int x, int y, int z) {
        this.dogData.setInt(6, x);
        this.dogData.setInt(7, y);
        this.dogData.setInt(8, z);
        this.dogData.setBool(9, true);
        DoggyStyle.sendDebugMessage(this.field_70170_p, "Setting home location: " + x + "," + y + "," + z);
    }

    public void func_110171_b(int x, int y, int z, int w) {
        this.dogData.setInt(10, x);
        this.dogData.setInt(11, y);
        this.dogData.setInt(12, z);
        this.dogData.setInt(13, w);
    }

    public void setSkill(int skillID, int value) {
        DogSkill ds = DogSkill.getSkill(skillID);
        if (ds != null) {
            ds.onChange(this, value);
        }
        this.dogSkills.setInt(skillID * 2, value);
    }

    public void setOrigSkill(int skillID, int value) {
        DogSkill ds = DogSkill.getSkill(skillID);
        if (ds != null) {
            ds.onChange(this, value);
        }
        this.dogSkills.setInt(skillID * 2 + 1, value);
    }

    public void func_70903_f(boolean par1) {
        super.func_70903_f(par1);
        this.func_70778_a(null);
        this.func_70624_b(null);
    }

    public void setTamedBy(EntityPlayer player) {
        if (player == null) {
            this.func_70903_f(false);
            this.deobfSetOwnerId("");
            this.dogData.setString(18, "");
            return;
        }
        this.func_70903_f(true);
        this.deobfSetOwnerId(player.func_110124_au().toString());
        this.dogData.setString(18, player.func_70005_c_());
        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
    }

    protected void func_70629_bd() {
        this.field_70180_af.func_75692_b(18, (Object)Float.valueOf(this.func_110143_aJ()));
        if (this.getBehavior() == 3 && this.hasDogHouse()) {
            ChunkCoordinates home = this.getDogHouseIfExists();
            if (home != null) {
                this.func_70012_b(home.field_71574_a, home.field_71572_b, home.field_71573_c, 1.0f, 0.0f);
            }
        } else if (this.getBehavior() == 3) {
            this.setBehavior(1);
        }
        if (this.shearTimer > 0) {
            if (--this.shearTimer == 0) {
                this.setSheared(false);
            }
        } else if (this.isSheared()) {
            this.shearTimer = 2400;
        }
        if (this.func_70880_s() && !this.isMale() && !this.verifyDogHouseExists()) {
            this.sendOwnerMessage(StatCollector.func_74838_a((String)"text.doggystyle.momneedshome"));
            this.func_70875_t();
        }
        if (!this.func_70909_n() && this.dogData.getInt(14) == 3 && this.field_70170_p != null && !this.field_70170_p.func_72935_r() && this.field_70170_p.func_72820_D() > 13000L && this.field_70146_Z.nextInt(1000) == 0 && this.field_70170_p.func_72977_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 12.0) == null) {
            this.func_70106_y();
        }
    }

    public boolean verifyDogHouseExists() {
        return this.getDogHouseIfExists() != null;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.dogData.writeToNBT(nbt);
        this.dogSkills.writeToNBT(nbt);
        if (this.shearTimer > 0) {
            nbt.func_74768_a("shearTimer", this.shearTimer);
        }
    }

    public void func_70109_d(NBTTagCompound nbt) {
        super.func_70109_d(nbt);
        this.dogData.writeToNBT(nbt);
        this.dogSkills.writeToNBT(nbt);
        if (this.shearTimer > 0) {
            nbt.func_74768_a("shearTimer", this.shearTimer);
        }
    }
}

