/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.doggystyle.gui;

import com.seiferware.minecraft.doggystyle.DoggyStyle;
import com.seiferware.minecraft.doggystyle.entity.EntityDog;
import com.seiferware.minecraft.doggystyle.skills.DogSkill;
import com.seiferware.minecraft.doggystyle.utils.DogUtils;
import com.seiferware.minecraft.utils.gui.BaseGui;
import com.seiferware.minecraft.utils.gui.GuiTextLabel;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.StatCollector;

@SideOnly(value=Side.CLIENT)
public class DogMenu
extends BaseGui {
    protected final String[] behaviors = new String[5];
    protected GuiButton[] modeButtons;
    protected EntityDog target;

    public DogMenu(EntityDog target) {
        this.target = target;
        this.behaviors[2] = "setModeFollow";
        this.behaviors[0] = "setModeRoam";
        this.behaviors[1] = "setModeStay";
        this.behaviors[3] = "setModeHome";
        this.behaviors[4] = "setModeLieDown";
    }

    @Override
    public void func_73866_w_() {
        boolean isOwner;
        String origin;
        super.func_73866_w_();
        LinkedHashMap<String, String> list = new LinkedHashMap<String, String>();
        for (String behavior : this.behaviors) {
            list.put(behavior, StatCollector.func_74838_a((String)("command.doggystyle." + behavior)));
        }
        String gender = this.target.isMale() ? "\u00a7b\u2642\u00a7r" : "\u00a7d\u2640\u00a7r";
        GuiTextLabel text = this.addTextRow("\u00a7l" + this.target.func_70005_c_() + "\u00a7r" + " " + gender, false);
        text.setCentered(true);
        switch (this.target.getDogData().getInt(14)) {
            case 1: {
                origin = StatCollector.func_74838_a((String)"ui.doggystyle.originEgg");
                break;
            }
            case 0: {
                origin = StatCollector.func_74838_a((String)"ui.doggystyle.originSpawn");
                break;
            }
            default: {
                origin = StatCollector.func_74838_a((String)"ui.doggystyle.originBreed");
            }
        }
        origin = origin.replace("%", this.target.getBreed().getName());
        origin = origin.replace("#", DogUtils.getOrdinal(this.target.getGeneration()));
        text.addLine(origin);
        if (DoggyStyle.DEBUG_MODE) {
            ChunkCoordinates home = this.target.getDogHouseIfExists();
            if (home != null) {
                text.addLine("Dog House: " + home.field_71574_a + "," + home.field_71572_b + "," + home.field_71573_c);
            }
            if ((home = this.target.func_110172_bL()) != null && this.target.func_110175_bO()) {
                text.addLine("Roam Spot: " + home.field_71574_a + "," + home.field_71572_b + "," + home.field_71573_c);
            }
        }
        boolean bl = isOwner = this.target.func_70902_q() != null && this.target.func_70902_q().func_70005_c_().equals(Minecraft.func_71410_x().field_71439_g.func_70005_c_());
        if (isOwner) {
            if (!this.target.func_70631_g_()) {
                this.modeButtons = this.addButtonRow(list, list.size(), true);
                this.updateMode();
            }
        } else {
            text.addLine(StatCollector.func_74838_a((String)"ui.doggystyle.ownedby").replace("%", this.target.getOwnerName()));
        }
        ArrayList<String> stats = new ArrayList<String>();
        for (int sk = 0; sk < DogSkill.getSkillCount(); ++sk) {
            DogSkill skill = DogSkill.getSkill(sk);
            if (skill.hiddenIfZero() && this.target.getSkill(sk) == 0) continue;
            if (skill.getType() == 5) {
                stats.add((this.target.getSkillAvailable(sk) ? "\u00a7r" : "\u00a77") + skill.getName() + ": " + (this.target.getSkill(sk) > 0 ? "\u00a7a\u2714\u00a7r" : "\u00a7c\u2718\u00a7r"));
                continue;
            }
            stats.add((this.target.getSkillAvailable(sk) ? "\u00a7r" : "\u00a77") + skill.getName() + ": " + this.target.getSkill(sk) + "\u00a7r");
        }
        this.addLabelRow(stats, 4);
        if (isOwner) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        }
    }

    @Override
    protected void onCommand(String command) {
        for (int i = 0; i < this.behaviors.length; ++i) {
            if (!command.equals(this.behaviors[i])) continue;
            this.target.setBehavior(i);
            this.updateMode();
            this.close();
            return;
        }
    }

    public void updateMode() {
        for (int i = 0; i < this.behaviors.length; ++i) {
            this.modeButtons[i].field_146124_l = this.target.getBehavior() != i && (i != 3 || this.target.hasDogHouse());
        }
    }

    @Override
    protected void customDrawScreen(int par1, int par2, float par3) {
        super.customDrawScreen(par1, par2, par3);
    }
}

