/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.doggystyle.items;

import com.seiferware.minecraft.doggystyle.DoggyStyle;
import com.seiferware.minecraft.doggystyle.breeds.Breed;
import com.seiferware.minecraft.doggystyle.entity.EntityDog;
import com.seiferware.minecraft.utils.items.MobEgg;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class DogEgg
extends MobEgg {
    private int breedId;
    private String unlocalizedName;

    public DogEgg(Breed breed) {
        super("doggystyle", "Dog", breed.getEggColor(), breed.getEggSpotColor());
        this.breedId = breed.getBreedId();
        this.unlocalizedName = "item.egg." + breed.getUnlocalizedName() + ".name";
        this.func_77637_a(DoggyStyle.getTab());
    }

    @Override
    public String func_77653_i(ItemStack par1ItemStack) {
        return StatCollector.func_74838_a((String)this.unlocalizedName);
    }

    @Override
    public Entity spawnEntity(World parWorld, double parX, double parY, double parZ) {
        EntityLiving result = null;
        if (!parWorld.field_72995_K) {
            this.entityToSpawnNameFull = this.modID + "." + this.entityToSpawnName;
            if (EntityList.field_75625_b.containsKey(this.entityToSpawnNameFull)) {
                result = (EntityLiving)EntityList.func_75620_a((String)this.entityToSpawnNameFull, (World)parWorld);
                result.func_70012_b(parX, parY, parZ, MathHelper.func_76142_g((float)(parWorld.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                if (result instanceof EntityDog) {
                    EntityDog dog = (EntityDog)result;
                    dog.setBreedID(this.breedId);
                    dog.setCoatID(DoggyStyle.getRand().nextInt(dog.getBreed().getCoatCount()));
                    dog.getDogData().setInt(14, 1);
                    if (this.breedId == 10 || this.breedId == 16) {
                        switch (dog.getCoatID()) {
                            case 1: {
                                dog.setDyeColor(7);
                                break;
                            }
                            case 2: {
                                dog.setDyeColor(15);
                                break;
                            }
                            default: {
                                dog.setDyeColor(0);
                            }
                        }
                    }
                }
                parWorld.func_72838_d((Entity)result);
                result.func_110161_a(null);
                result.func_70642_aH();
            }
        }
        return result;
    }
}

