/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.doggystyle.model;

import com.seiferware.minecraft.doggystyle.entity.EntityDog;
import com.seiferware.minecraft.doggystyle.model.EasierModel;
import com.seiferware.minecraft.doggystyle.tileentity.TileEntityDogHouse;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class ModelDog
extends EasierModel {
    protected boolean allowWag = true;
    protected boolean allowWalk = true;
    protected ModelRenderer body;
    protected ModelRenderer collar;
    protected ModelRenderer head;
    protected ModelRenderer legLF;
    protected ModelRenderer legLR;
    protected ModelRenderer legRF;
    protected ModelRenderer legRR;
    protected ModelRenderer mane;
    protected List<ModelRenderer> models = new ArrayList<ModelRenderer>();
    protected ModelRenderer nape;
    protected ModelRenderer tail;
    protected int tailWidth = 2;
    protected float wagTailPosition = 0.0f;
    protected float wagTailSpeed = 1.0f;
    private float[] wagTailCurrent;

    public ModelDog() {
        this(64, 64);
    }

    public ModelDog(int w, int h) {
        this.field_78090_t = w;
        this.field_78089_u = h;
    }

    protected void doRender(ModelRenderer model, float f) {
        if (model == null) {
            return;
        }
        model.func_78785_a(f);
    }

    public void doRenderCollar(int color, float f1) {
        GL11.glColor3f((float)EntitySheep.field_70898_d[color][0], (float)EntitySheep.field_70898_d[color][1], (float)EntitySheep.field_70898_d[color][2]);
        this.doRender(this.collar, f1);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public float getCollarY() {
        if (this.collar != null) {
            return this.collar.field_78797_d / 16.0f;
        }
        return 1.0f;
    }

    public float getCollarZ() {
        if (this.collar != null) {
            return this.collar.field_78798_e / 16.0f;
        }
        return 1.0f;
    }

    public void func_78088_a(Entity par1Entity, float par2, float par3, float par4, float par5, float par6, float par7) {
        int color;
        GL11.glPushMatrix();
        float scale = 1.0f;
        if (par1Entity instanceof EntityDog) {
            EntityDog dog = (EntityDog)par1Entity;
            scale = dog.func_70603_bj();
        }
        GL11.glTranslatef((float)0.0f, (float)(1.5f * (1.0f - scale)), (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        super.func_78088_a(par1Entity, par2, par3, par4, par5, par6, par7);
        this.doRender(this.head, par7);
        this.doRender(this.body, par7);
        this.doRender(this.mane, par7);
        this.doRender(this.nape, par7);
        this.doRender(this.legRR, par7);
        this.doRender(this.legLR, par7);
        this.doRender(this.legRF, par7);
        this.doRender(this.legLF, par7);
        this.doRender(this.tail, par7);
        for (ModelRenderer model : this.models) {
            this.doRender(model, par7);
        }
        if (par1Entity instanceof EntityDog && (color = ((EntityDog)par1Entity).getCollarColor()) != -1) {
            this.doRenderCollar(color, par7);
        }
        GL11.glPopMatrix();
    }

    public void renderDogHouse(TileEntityDogHouse house) {
        GL11.glPushMatrix();
        float scale = Math.min(house.getDogBreed().getScale(), 1.0f);
        GL11.glTranslatef((float)0.0f, (float)(1.5f * (1.0f - scale)), (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.setPositionDogHouse();
        this.doRender(this.head, 1.0f);
        this.doRender(this.nape, 1.0f);
        this.doRender(this.legRF, 1.0f);
        this.doRender(this.legLF, 1.0f);
        int color = house.getDogCollar();
        if (color != -1) {
            this.doRenderCollar(color, 1.0f);
        }
        GL11.glPopMatrix();
    }

    protected void rotateTail(int[] lengths, float[] x, float[] wagTailYMin, float[] wagTailYMax) {
        if (this.wagTailCurrent == null) {
            this.wagTailCurrent = new float[x.length];
        }
        if (this.allowWag) {
            for (int i = 0; i < this.wagTailCurrent.length; ++i) {
                this.wagTailCurrent[i] = this.interpolate(wagTailYMin[i], wagTailYMax[i], this.wagTailPosition);
            }
        } else {
            for (int i = 0; i < this.wagTailCurrent.length; ++i) {
                this.wagTailCurrent[i] = 0.0f;
            }
        }
        this.rotateTail(lengths, x, this.wagTailCurrent);
    }

    protected void rotateTail(int[] lengths, float[] x, float[] y) {
        ModelRenderer t = this.tail;
        int i = 1;
        int l = lengths[0];
        if (l < 0) {
            this.setRotation(t, x[0] + 1.5707964f, y[0], 0.0f);
        } else {
            this.setRotation(t, x[0], y[0], 0.0f);
        }
        while (t.field_78805_m != null && !t.field_78805_m.isEmpty() && i < x.length && i < y.length) {
            t = (ModelRenderer)t.field_78805_m.get(0);
            float xr = x[i];
            float yr = y[i];
            if (lengths[i] < 0 && l > 0) {
                this.setRotation(t, xr + 1.5707964f, yr, 0.0f);
            } else if (lengths[i] > 0 && l < 0) {
                this.setRotation(t, xr - 1.5707964f, yr, 0.0f);
            } else {
                this.setRotation(t, xr, yr, 0.0f);
            }
            float xoffsety = 0.0f;
            float xoffsetz = 0.0f;
            float yoffsetx = 0.0f;
            float yoffsetz = 0.0f;
            if (l != 0) {
                if (xr != 0.0f) {
                    xoffsety = (1.0f - (float)Math.cos(Math.abs(xr))) * ((float)this.tailWidth / 2.0f);
                    if (xr < 0.0f) {
                        xoffsety = -xoffsety;
                    }
                    xoffsetz = (0.0f + (float)Math.sin(Math.abs(xr))) * ((float)this.tailWidth / 2.0f);
                }
                if (yr != 0.0f) {
                    yoffsetx = (1.0f - (float)Math.cos(Math.abs(yr))) * ((float)this.tailWidth / 2.0f);
                    if (yr < 0.0f) {
                        yoffsetx = -yoffsetx;
                    }
                    yoffsetz = (0.0f + (float)Math.sin(Math.abs(yr))) * ((float)this.tailWidth / 2.0f);
                }
                if (l < 0) {
                    t.func_78793_a(yoffsetx, (float)Math.abs(l) - (xoffsetz + yoffsetz), xoffsety);
                } else {
                    t.func_78793_a(yoffsetx, xoffsety, (float)l - (xoffsetz + yoffsetz));
                }
            }
            l = lengths[i];
            ++i;
        }
    }

    public void setHeadRotation(float x, float y, float z) {
        this.setRotation(this.head, x, y, z);
    }

    public void func_78086_a(EntityLivingBase par1EntityLivingBase, float walked, float speed, float par4) {
        if (this.allowWalk) {
            this.setRotation(this.legLF, MathHelper.func_76134_b((float)(walked * 0.6662f)) * 1.4f * speed, 0.0f, 0.0f);
            this.setRotation(this.legRF, MathHelper.func_76134_b((float)(walked * 0.6662f + (float)Math.PI)) * 1.4f * speed, 0.0f, 0.0f);
            this.setRotation(this.legLR, MathHelper.func_76134_b((float)(walked * 0.6662f + (float)Math.PI)) * 1.4f * speed, 0.0f, 0.0f);
            this.setRotation(this.legRR, MathHelper.func_76134_b((float)(walked * 0.6662f)) * 1.4f * speed, 0.0f, 0.0f);
        }
        if (par1EntityLivingBase instanceof EntityDog) {
            EntityDog dog = (EntityDog)par1EntityLivingBase;
            this.wagTailPosition = MathHelper.func_76134_b((float)(((float)dog.getAnimationTime() + par4) * this.wagTailSpeed / 3.0f)) + 0.5f;
        }
    }

    public void setPosition(int position) {
        switch (position) {
            case 0: {
                this.allowWalk = true;
                this.allowWag = true;
                this.setPositionStand();
                break;
            }
            case 1: {
                this.allowWalk = false;
                this.allowWag = false;
                this.setPositionSit();
                break;
            }
            case 2: {
                this.allowWalk = false;
                this.allowWag = false;
                this.setPositionLieDown();
                break;
            }
            case -1: {
                this.allowWalk = false;
                this.allowWag = false;
                this.setPositionDogHouse();
            }
        }
    }

    public void setPositionDogHouse() {
    }

    public abstract void setPositionLieDown();

    public abstract void setPositionSit();

    public abstract void setPositionStand();

    protected ModelRenderer createLeg(int texX, int texY, int width, int height, int depth) {
        return this.createBox(texX, texY, -((float)width) / 2.0f, 0.0f, -((float)depth) / 2.0f, width, height, depth, -0.001f);
    }

    protected ModelRenderer createCollar(int texX, int texY, int width, int height, int depth) {
        return this.createCollar(texX, texY, width, height, depth, 0.001f);
    }

    private ModelRenderer createCollar(int texX, int texY, int width, int height, int depth, float sizeDiff) {
        return this.createBox(texX, texY, -((float)width) / 2.0f, 0.0f, 0.0f, width, height, depth, sizeDiff);
    }

    protected ModelRenderer createTailSegment(int texX, int texY, int width, int height, int depth) {
        return this.createTailSegment(texX, texY, width, height, depth, false);
    }

    protected ModelRenderer createTailSegment(int texX, int texY, int width, int height, int depth, boolean useY) {
        int index = 0;
        ModelRenderer currentSegment = this.tail;
        if (currentSegment != null) {
            ++index;
            while (currentSegment.field_78805_m != null && !currentSegment.field_78805_m.isEmpty()) {
                ++index;
                currentSegment = (ModelRenderer)currentSegment.field_78805_m.get(0);
            }
        }
        ModelRenderer t = useY ? this.createBox(texX, texY, -((float)width) / 2.0f, 0.0f, -((float)depth) / 2.0f, width, height, depth, (float)index * -0.01f) : this.createBox(texX, texY, -((float)width) / 2.0f, -((float)height) / 2.0f, 0.0f, width, height, depth, (float)index * -0.01f);
        if (currentSegment != null) {
            currentSegment.func_78792_a(t);
        } else {
            this.tail = t;
        }
        return t;
    }

    protected void posFrontLegs(float posX, float posY, float posZ, float rotDeg) {
        this.setPos(this.legRF, -Math.abs(posX), posY, posZ);
        this.setPos(this.legLF, Math.abs(posX), posY, posZ);
        this.setRotation(this.legRF, -1.5707964f, Math.abs(rotDeg) * ((float)Math.PI / 180), 0.0f);
        this.setRotation(this.legLF, -1.5707964f, -Math.abs(rotDeg) * ((float)Math.PI / 180), 0.0f);
    }

    protected void posFrontLegs(float posX, float posY, float posZ) {
        this.setPos(this.legRF, -Math.abs(posX), posY, posZ);
        this.setPos(this.legLF, Math.abs(posX), posY, posZ);
    }

    protected void posBackLegs(float posX, float posY, float posZ, float rotDeg) {
        this.setPos(this.legRR, -Math.abs(posX), posY, posZ);
        this.setPos(this.legLR, Math.abs(posX), posY, posZ);
        this.setRotation(this.legRR, -1.5707964f, Math.abs(rotDeg) * ((float)Math.PI / 180), 0.0f);
        this.setRotation(this.legLR, -1.5707964f, -Math.abs(rotDeg) * ((float)Math.PI / 180), 0.0f);
    }

    protected void posBackLegs(float posX, float posY, float posZ) {
        this.setPos(this.legRR, -Math.abs(posX), posY, posZ);
        this.setPos(this.legLR, Math.abs(posX), posY, posZ);
    }
}

