/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.doggystyle.net;

import com.seiferware.minecraft.doggystyle.entity.EntityDog;
import com.seiferware.minecraft.utils.net.SimplePacket;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class DogUpdatePacket
extends SimplePacket {
    private static final int typeBool = 1;
    private static final int typeFloat = 4;
    private static final int typeInt = 2;
    private static final int typeString = 3;
    private int key;
    private boolean skill = false;
    private int targetid;
    private int type;
    private Object value;

    public DogUpdatePacket() {
    }

    private DogUpdatePacket(EntityDog target, boolean skill, int id, int value) {
        this.targetid = target.func_145782_y();
        this.skill = skill;
        this.key = id;
        this.value = value;
        this.type = 2;
    }

    private DogUpdatePacket(EntityDog target, int id, boolean value) {
        this.targetid = target.func_145782_y();
        this.key = id;
        this.value = value;
        this.type = 1;
    }

    private DogUpdatePacket(EntityDog target, int id, float value) {
        this.targetid = target.func_145782_y();
        this.key = id;
        this.value = Float.valueOf(value);
        this.type = 4;
    }

    private DogUpdatePacket(EntityDog target, int id, String value) {
        this.targetid = target.func_145782_y();
        this.key = id;
        this.value = value;
        this.type = 3;
    }

    public static SimplePacket getDataUpdate(EntityDog target, int id, boolean value) {
        return new DogUpdatePacket(target, id, value);
    }

    public static SimplePacket getDataUpdate(EntityDog target, int id, float value) {
        return new DogUpdatePacket(target, id, value);
    }

    public static SimplePacket getDataUpdate(EntityDog target, int id, int value) {
        return new DogUpdatePacket(target, false, id, value);
    }

    public static SimplePacket getDataUpdate(EntityDog target, int id, String value) {
        return new DogUpdatePacket(target, id, value);
    }

    public static SimplePacket getSkillUpdate(EntityDog target, int skill, int value) {
        return new DogUpdatePacket(target, true, skill, value);
    }

    @Override
    public IMessage act(EntityPlayer player) {
        Entity entity = player.field_70170_p.func_73045_a(this.targetid);
        if (entity != null && !(entity instanceof EntityDog)) {
            return null;
        }
        EntityDog target = (EntityDog)entity;
        if (target == null) {
            return null;
        }
        switch (this.type) {
            case 1: {
                target.getDogData().setBool(this.key, (Boolean)this.value);
                break;
            }
            case 2: {
                if (this.skill) {
                    target.setSkill(this.key, (Integer)this.value);
                    break;
                }
                target.getDogData().setInt(this.key, (Integer)this.value);
                break;
            }
            case 3: {
                target.getDogData().setString(this.key, (String)this.value);
                break;
            }
            case 4: {
                target.getDogData().setFloat(this.key, ((Float)this.value).floatValue());
            }
        }
        return null;
    }

    @Override
    public void readData(ByteBuf in) {
        this.targetid = in.readInt();
        this.key = in.readInt();
        this.type = in.readInt();
        switch (this.type) {
            case 1: {
                this.value = in.readBoolean();
                break;
            }
            case 2: {
                this.skill = in.readBoolean();
                this.value = in.readInt();
                break;
            }
            case 3: {
                this.value = this.readString(in);
                break;
            }
            case 4: {
                this.value = Float.valueOf(in.readFloat());
            }
        }
    }

    @Override
    public void writeData(ByteBuf out) {
        out.writeInt(this.targetid);
        out.writeInt(this.key);
        out.writeInt(this.type);
        switch (this.type) {
            case 1: {
                out.writeBoolean(((Boolean)this.value).booleanValue());
                break;
            }
            case 2: {
                out.writeBoolean(this.skill);
                out.writeInt(((Integer)this.value).intValue());
                break;
            }
            case 3: {
                this.writeString(out, (String)this.value);
                break;
            }
            case 4: {
                out.writeFloat(((Float)this.value).floatValue());
            }
        }
    }
}

