/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.doggystyle.renderer;

import com.seiferware.minecraft.doggystyle.DoggyStyle;
import com.seiferware.minecraft.doggystyle.model.ModelDogHouse;
import com.seiferware.minecraft.doggystyle.tileentity.TileEntityDogHouse;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class TileEntityDogHouseRenderer
extends TileEntitySpecialRenderer {
    private static TileEntityDogHouseRenderer instance;
    ModelDogHouse model = new ModelDogHouse();
    Map<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();

    private TileEntityDogHouseRenderer() {
        for (String wood : DoggyStyle.SUPPORTED_WOODS) {
            ResourceLocation resource = new ResourceLocation("doggystyle:textures/blocks/house_" + wood + ".png");
            this.textures.put(wood, resource);
        }
    }

    public static TileEntityDogHouseRenderer getInstance() {
        if (instance == null) {
            instance = new TileEntityDogHouseRenderer();
        }
        return instance;
    }

    private ResourceLocation getTexture(String wood) {
        if (this.textures.containsKey(wood)) {
            return this.textures.get(wood);
        }
        return this.textures.get("oak");
    }

    private void renderDogHouse(String name, int front, int roofColor, String wood, float brightness, int lightBrightness) {
        Tessellator tessellator = Tessellator.field_78398_a;
        int l1 = lightBrightness % 65536;
        int l2 = lightBrightness / 65536;
        tessellator.func_78386_a(brightness, brightness, brightness);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)l1, (float)l2);
        int b0 = 0;
        GL11.glPushMatrix();
        GL11.glRotatef((float)MathHelper.func_76142_g((float)(180.0f + (float)front * -90.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(this.getTexture(wood));
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.model.renderHouse();
        GL11.glColor3f((float)EntitySheep.field_70898_d[roofColor][0], (float)EntitySheep.field_70898_d[roofColor][1], (float)EntitySheep.field_70898_d[roofColor][2]);
        this.model.renderRoof();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (name != null && !name.isEmpty()) {
            FontRenderer fontrenderer = this.func_147498_b();
            this.model.renderNamePlate();
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.21875f, (float)0.34375f);
            float f1 = 0.6666667f;
            float f3 = 0.016666668f * f1;
            GL11.glScalef((float)f3, (float)(-f3), (float)f3);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)(-1.0f * f3));
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.01f);
            GL11.glDepthMask((boolean)false);
            fontrenderer.func_78276_b(name, -fontrenderer.func_78256_a(name) / 2, -15, b0);
            GL11.glDepthMask((boolean)true);
        }
        GL11.glPopMatrix();
    }

    public void renderDogHouse(TileEntityDogHouse tileEntity, World world, int x, int y, int z, Block block) {
        float f = block.func_149677_c((IBlockAccess)world, x, y, z);
        int l = world.func_72802_i(x, y, z, 0);
        int dir = tileEntity.getFront();
        String s = tileEntity.getDogName();
        int roof = tileEntity.getRoofColor();
        String wood = tileEntity.getWood();
        this.renderDogHouse(s, dir, roof, wood, f, l);
    }

    public void renderItem(ItemStack item, String wood) {
        int color = item.func_77960_j();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        this.renderDogHouse("", 0, color, wood, 1.0f, 255);
        GL11.glPopMatrix();
    }

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float f) {
        if (tileEntity instanceof TileEntityDogHouse) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            TileEntityDogHouse dogHouse = (TileEntityDogHouse)tileEntity;
            this.renderDogHouse(dogHouse, tileEntity.func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, tileEntity.func_145838_q());
            GL11.glPopMatrix();
        }
    }
}

