/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.doggystyle.renderer;

import com.seiferware.minecraft.doggystyle.model.ModelHerdStaff;
import com.seiferware.minecraft.doggystyle.tileentity.TileEntityHerdStaff;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class TileEntityHerdStaffRenderer
extends TileEntitySpecialRenderer {
    private static TileEntityHerdStaffRenderer instance;
    private final ResourceLocation[] textures = new ResourceLocation[]{null, new ResourceLocation("doggystyle:textures/blocks/staff_sheep.png"), new ResourceLocation("doggystyle:textures/blocks/staff_cow.png"), new ResourceLocation("doggystyle:textures/blocks/staff_pig.png"), new ResourceLocation("doggystyle:textures/blocks/staff_chicken.png")};
    private final ModelHerdStaff model = new ModelHerdStaff();

    public static TileEntityHerdStaffRenderer getInstance() {
        if (instance == null) {
            instance = new TileEntityHerdStaffRenderer();
        }
        return instance;
    }

    public void renderItem(IItemRenderer.ItemRenderType renderType, int type, int b) {
        GL11.glPushMatrix();
        switch (renderType) {
            case EQUIPPED: {
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.5f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                GL11.glTranslatef((float)0.5f, (float)1.75f, (float)0.5f);
                GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case ENTITY: {
                GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case INVENTORY: 
            case FIRST_PERSON_MAP: {
                GL11.glTranslatef((float)0.5f, (float)1.25f, (float)0.5f);
            }
        }
        this.renderStaff(type, 1.0f, b);
        GL11.glPopMatrix();
    }

    public void renderStaff(TileEntityHerdStaff tileEntity, World world, int x, int y, int z, Block block) {
        float f = block.func_149677_c((IBlockAccess)world, x, y, z);
        int l = world.func_72802_i(x, y, z, 0);
        int animal = tileEntity.getAnimalType();
        this.renderStaff(animal, f, l);
    }

    private void renderStaff(int animal, float brightness, int lightBrightness) {
        Tessellator tessellator = Tessellator.field_78398_a;
        int l1 = lightBrightness % 65536;
        int l2 = lightBrightness / 65536;
        tessellator.func_78386_a(brightness, brightness, brightness);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)l1, (float)l2);
        this.func_147499_a(this.textures[animal]);
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.model.renderStaff(animal);
        GL11.glPopMatrix();
    }

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float f) {
        if (tileEntity instanceof TileEntityHerdStaff) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
            TileEntityHerdStaff staff = (TileEntityHerdStaff)tileEntity;
            this.renderStaff(staff, tileEntity.func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, tileEntity.func_145838_q());
            GL11.glPopMatrix();
        }
    }
}

