/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.doggystyle.renderer;

import com.seiferware.minecraft.doggystyle.model.ModelHydrant;
import com.seiferware.minecraft.doggystyle.tileentity.TileEntityHydrant;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class TileEntityHydrantRenderer
extends TileEntitySpecialRenderer {
    private static TileEntityHydrantRenderer instance;
    ModelHydrant model = new ModelHydrant();
    ResourceLocation texture = new ResourceLocation("doggystyle:textures/blocks/hydrant.png");
    public static final int COLOR_RED = 0;
    public static final int COLOR_YELLOW = 1;
    public static final int COLOR_BLUE = 2;
    private float[][] colors = new float[][]{{0.45490196f, 0.07058824f, 0.07058824f}, {0.5372549f, 0.5176471f, 0.101960786f}, {0.11764706f, 0.14117648f, 0.4f}};

    public static TileEntityHydrantRenderer getInstance() {
        if (instance == null) {
            instance = new TileEntityHydrantRenderer();
        }
        return instance;
    }

    private void renderHydrant(int front, int color, float brightness, int lightBrightness) {
        Tessellator tessellator = Tessellator.field_78398_a;
        int l1 = lightBrightness % 65536;
        int l2 = lightBrightness / 65536;
        tessellator.func_78386_a(brightness, brightness, brightness);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)l1, (float)l2);
        boolean b0 = false;
        GL11.glPushMatrix();
        GL11.glRotatef((float)MathHelper.func_76142_g((float)(180.0f + (float)front * -90.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(this.texture);
        GL11.glColor3f((float)this.colors[color][0], (float)this.colors[color][1], (float)this.colors[color][2]);
        this.model.renderHydrant();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void renderHydrant(TileEntityHydrant tileEntity, World world, int x, int y, int z, Block block) {
        float f = block.func_149677_c((IBlockAccess)world, x, y, z);
        int l = world.func_72802_i(x, y, z, 0);
        int dir = tileEntity.getFront();
        int color = tileEntity.getColor();
        this.renderHydrant(dir, color, f, l);
    }

    public void renderItem(ItemStack item) {
        int color = item.func_77960_j();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
        this.renderHydrant(0, color, 1.0f, 255);
        GL11.glPopMatrix();
    }

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float f) {
        if (tileEntity instanceof TileEntityHydrant) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y), (float)((float)z + 0.5f));
            TileEntityHydrant hydrant = (TileEntityHydrant)tileEntity;
            this.renderHydrant(hydrant, tileEntity.func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, tileEntity.func_145838_q());
            GL11.glPopMatrix();
        }
    }
}

