/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.doggystyle.skills;

import com.seiferware.minecraft.doggystyle.DoggyStyle;
import com.seiferware.minecraft.doggystyle.entity.EntityDog;
import com.seiferware.minecraft.doggystyle.skills.SkillAttack;
import com.seiferware.minecraft.doggystyle.skills.SkillHealth;
import com.seiferware.minecraft.doggystyle.skills.SkillHerding;
import com.seiferware.minecraft.doggystyle.skills.SkillSpeed;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.StatCollector;

public class DogSkill {
    public static final int skillAttack = 0;
    public static final int skillHealing = 3;
    public static final int skillHealth = 1;
    public static final int skillSpeed = 2;
    public static final int skillHerding = 4;
    public static final Map<Integer, DogSkill> skills = new HashMap<Integer, DogSkill>();
    public static final int typeActive = 3;
    public static final int typeHidden = 4;
    public static final int typePassive = 2;
    public static final int typeStat = 1;
    public static final int typeBoolean = 5;
    protected int id = 0;
    protected String name = "";
    protected int type = 0;

    public int generateStat(int min, int max, int generation) {
        int[] nums = new int[Math.max(5, generation + 1)];
        for (int i = 0; i < nums.length; ++i) {
            nums[i] = DoggyStyle.getRand().nextInt(max + 1 - min) + min;
        }
        Arrays.sort(nums);
        return nums[generation];
    }

    public static DogSkill getSkill(int id) {
        return skills.get(id);
    }

    public static int getSkillCount() {
        return skills.size();
    }

    public static void registerSkill(DogSkill skill, int id) {
        skills.put(id, skill);
        skill.setId(id);
    }

    public EntityAIBase getAI(EntityDog dog) {
        return null;
    }

    public int getAIPriority() {
        return 1;
    }

    public int getId() {
        return this.id;
    }

    public DogSkill setId(int id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return StatCollector.func_74838_a((String)("skill.doggystyle." + this.name));
    }

    public int getType() {
        return this.type;
    }

    public DogSkill setType(int type) {
        this.type = type;
        return this;
    }

    public String getUnlocalizedName() {
        return this.name;
    }

    public DogSkill setUnlocalizedName(String name) {
        this.name = name;
        return this;
    }

    public int generationForNaturalTalent() {
        return -1;
    }

    public boolean hiddenIfZero() {
        return this.getType() != 2 && this.getType() != 3;
    }

    public void onChange(EntityDog dog, int newValue) {
    }

    static {
        DogSkill.registerSkill(new SkillAttack(), 0);
        DogSkill.registerSkill(new SkillHealth(), 1);
        DogSkill.registerSkill(new SkillSpeed(), 2);
        DogSkill.registerSkill(new DogSkill().setUnlocalizedName("healing"), 3);
        DogSkill.registerSkill(new SkillHerding(), 4);
    }
}

