/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.doggystyle.tileentity;

import com.seiferware.minecraft.doggystyle.DoggyStyle;
import com.seiferware.minecraft.doggystyle.breeds.Breed;
import com.seiferware.minecraft.doggystyle.entity.EntityDog;
import com.seiferware.minecraft.doggystyle.net.DogHouseAssignPacket;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityDogHouse
extends TileEntity {
    private int animTick = 0;
    private int checkHealTick;
    private boolean containsDog = false;
    private int dogAge = 0;
    private int dogBreed = 0;
    private int dogCoat = 0;
    private int dogCollar = -1;
    private String dogData = "";
    private boolean dogHealing;
    private String dogId = "";
    private String dogName = "";
    private String dogSkills = "";
    private int front = 0;
    private int healRate = 200;
    private float healingRemaining = 0.0f;
    private String ownerId = "";
    private List<PuppyData> puppies = new ArrayList<PuppyData>();
    private int roofColor = 0;
    private String soundset = "";
    private String wood = "";

    public void absorbDog(EntityDog dog) {
        if (!this.dogId.equals(dog.getDogId()) || this.containsDog) {
            return;
        }
        dog.setBehavior(2);
        this.dogData = dog.getDogData().getAllData();
        this.dogSkills = dog.getDogSkills().getAllData();
        this.dogName = dog.func_70005_c_();
        this.healingRemaining = dog.func_110138_aP() - dog.func_110143_aJ();
        this.healRate = 200 - dog.getSkill(3) * 5;
        this.dogAge = dog.func_70874_b();
        this.containsDog = true;
        this.soundset = dog.getBreed().getSoundSet();
        this.playSound("bark");
        if (dog.getPuppies().size() > 0) {
            for (EntityDog puppy : dog.getPuppies()) {
                if (!puppy.func_70089_S() || !puppy.func_70631_g_()) continue;
                PuppyData pd = new PuppyData();
                pd.setAge(puppy.func_70874_b());
                pd.setDogData(puppy.getDogData().getAllData());
                pd.setDogSkills(puppy.getDogSkills().getAllData());
                pd.setName(puppy.func_94057_bL());
                this.puppies.add(pd);
                puppy.func_70106_y();
            }
        }
        this.markUpdated();
        dog.func_70106_y();
    }

    public boolean canUpdate() {
        return true;
    }

    public boolean getContainsDog() {
        return this.containsDog;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeClientDataToNBT(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public Breed getDogBreed() {
        return Breed.getBreed(this.dogBreed);
    }

    public int getDogCoat() {
        return this.dogCoat;
    }

    public int getDogCollar() {
        return this.dogCollar;
    }

    public String getDogId() {
        return this.dogId;
    }

    public String getDogName() {
        return this.dogName;
    }

    public int getFront() {
        return this.front;
    }

    public void setFront(int front) {
        this.front = front;
    }

    public float getHealingRemaining() {
        return this.healingRemaining;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public int getRoofColor() {
        return this.roofColor;
    }

    public void setRoofColor(int roofColor) {
        this.roofColor = roofColor;
        if (this.field_145850_b != null) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145851_c, roofColor, 2);
        }
        this.markUpdated();
    }

    public String getWood() {
        return this.wood;
    }

    public void setWood(String wood) {
        this.wood = wood;
    }

    public boolean isDogHealing() {
        return this.dogHealing;
    }

    private void setDogHealing(boolean b) {
        if (this.dogHealing != b) {
            this.markUpdated();
        }
        this.dogHealing = b;
    }

    public void markUpdated() {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readClientDataFromNBT(pkt.func_148857_g());
    }

    public void playHurtSound() {
        this.playSound("hurt");
    }

    private void playSound(String sound) {
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, this.soundset + "." + sound, 0.5f, 1.0f);
    }

    public void readClientDataFromNBT(NBTTagCompound nbt) {
        this.dogName = nbt.func_74779_i("dogName");
        this.ownerId = nbt.func_74779_i("ownerId");
        this.setFront(nbt.func_74762_e("front"));
        this.containsDog = nbt.func_74767_n("containsDog");
        this.dogHealing = nbt.func_74767_n("dogHealing");
        this.dogId = nbt.func_74779_i("dogId");
        this.setRoofColor(nbt.func_74762_e("roofColor"));
        this.dogBreed = nbt.func_74762_e("dogBreed");
        this.dogCollar = nbt.func_74762_e("dogCollar");
        this.dogCoat = nbt.func_74762_e("dogCoat");
        this.wood = nbt.func_74779_i("wood");
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.dogName = nbt.func_74779_i("dogName");
        this.dogId = nbt.func_74779_i("dogId");
        this.ownerId = nbt.func_74779_i("ownerId");
        this.dogSkills = nbt.func_74779_i("dogSkills");
        this.dogData = nbt.func_74779_i("dogData");
        this.containsDog = nbt.func_74767_n("containsDog");
        this.healingRemaining = nbt.func_74760_g("healingRemaining");
        this.healRate = nbt.func_74762_e("healRate");
        this.soundset = nbt.func_74779_i("soundset");
        this.setFront(nbt.func_74762_e("front"));
        this.setRoofColor(nbt.func_74762_e("roofColor"));
        this.dogBreed = nbt.func_74762_e("dogBreed");
        this.dogCollar = nbt.func_74762_e("dogCollar");
        this.dogCoat = nbt.func_74762_e("dogCoat");
        this.wood = nbt.func_74779_i("wood");
        this.dogAge = nbt.func_74762_e("dogAge");
        this.puppies.clear();
        int i = 0;
        while (nbt.func_74764_b("data_" + i)) {
            this.puppies.add(new PuppyData(nbt, i));
            ++i;
        }
    }

    public EntityDog releaseDog(EntityPlayer player) {
        if (!this.containsDog) {
            return null;
        }
        if (!player.func_110124_au().toString().equals(this.ownerId)) {
            return null;
        }
        if (!this.field_145850_b.field_72995_K) {
            EntityDog dog = new EntityDog(this.field_145850_b, this.dogData, this.dogSkills);
            dog.setTamedBy(player);
            dog.func_94058_c(this.dogName);
            this.dogId = dog.getDogId();
            float f = player.field_70177_z;
            switch (this.front) {
                case 0: {
                    dog.func_70080_a((double)this.field_145851_c + 0.5, this.field_145848_d, (double)this.field_145849_e + 1.5, f, 0.0f);
                    break;
                }
                case 1: {
                    dog.func_70080_a((double)this.field_145851_c - 0.5, this.field_145848_d, (double)this.field_145849_e + 0.5, f, 0.0f);
                    break;
                }
                case 2: {
                    dog.func_70080_a((double)this.field_145851_c + 0.5, this.field_145848_d, (double)this.field_145849_e - 0.5, f, 0.0f);
                    break;
                }
                case 3: {
                    dog.func_70080_a((double)this.field_145851_c + 1.5, this.field_145848_d, (double)this.field_145849_e + 0.5, f, 0.0f);
                }
            }
            dog.func_110161_a(null);
            this.containsDog = !this.field_145850_b.func_72838_d((Entity)dog);
            dog.setBehavior(2);
            dog.setDogHouseLocation(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            dog.func_70642_aH();
            dog.func_70606_j(dog.func_110138_aP());
            dog.func_70873_a(this.dogAge);
            this.markUpdated();
            if (!this.containsDog) {
                for (PuppyData puppyData : this.puppies) {
                    EntityDog puppy = new EntityDog(this.field_145850_b, puppyData.getDogData(), puppyData.getDogSkills());
                    puppy.setTamedBy(player);
                    puppy.func_82149_j((Entity)dog);
                    puppy.func_110161_a(null);
                    this.field_145850_b.func_72838_d((Entity)puppy);
                    puppy.setBehavior(0);
                    puppy.func_70606_j(puppy.func_110138_aP());
                    puppy.setMom(dog);
                    puppy.func_70873_a(puppyData.getAge());
                    puppy.func_94058_c(puppyData.getName());
                }
                this.puppies.clear();
            }
            return dog;
        }
        return null;
    }

    public void setDog(EntityDog dog) {
        if (this.field_145850_b.field_72995_K) {
            DoggyStyle.networkChannel.sendToServer((IMessage)new DogHouseAssignPacket(dog, this));
            dog.setDogHouseLocation(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else {
            this.dogName = dog.func_70005_c_();
            this.dogId = dog.getDogId();
            dog.setDogHouseLocation(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.markUpdated();
        }
    }

    public void setOwner(EntityPlayer owner) {
        this.ownerId = owner.func_110124_au().toString();
        this.markUpdated();
    }

    public void func_145845_h() {
        this.animTick = (this.animTick + 1) % 15;
        if (this.field_145850_b.field_72995_K) {
            if (this.dogHealing && this.animTick == 0) {
                Random rand = this.field_145850_b.field_73012_v;
                double d0 = rand.nextGaussian() * 0.02;
                double d1 = rand.nextGaussian() * 0.02;
                double d2 = rand.nextGaussian() * 0.02;
                this.field_145850_b.func_72869_a("heart", (double)this.field_145851_c + rand.nextDouble(), (double)this.field_145848_d + 0.5 + rand.nextDouble() / 2.0, (double)this.field_145849_e + rand.nextDouble(), d0, d1, d2);
            }
        } else {
            if (this.containsDog && this.animTick == 5 && this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                int sound = this.field_145850_b.field_73012_v.nextInt(101);
                if (sound < 75) {
                    this.playSound("step");
                } else if (sound < 90) {
                    this.playSound("bark");
                } else if (sound < 100) {
                    this.playSound("panting");
                } else {
                    this.playSound("howl");
                }
            }
            if (this.containsDog && this.healingRemaining > 0.0f) {
                this.setDogHealing(true);
                ++this.checkHealTick;
                if (this.checkHealTick >= this.healRate) {
                    this.healingRemaining -= 1.0f;
                    this.checkHealTick = 0;
                }
            } else {
                this.setDogHealing(false);
            }
            if (this.containsDog && this.dogAge != 0) {
                if (this.dogAge > 0) {
                    --this.dogAge;
                }
                if (this.dogAge < 0) {
                    ++this.dogAge;
                }
            }
            if (this.containsDog && this.puppies.size() > 0) {
                for (PuppyData pd : this.puppies) {
                    if (pd.getAge() > 0) {
                        pd.setAge(pd.getAge() - 1);
                    }
                    if (pd.getAge() >= 0) continue;
                    pd.setAge(pd.getAge() + 1);
                }
            }
        }
    }

    public void writeClientDataToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("dogName", this.dogName);
        nbt.func_74778_a("dogId", this.dogId);
        nbt.func_74778_a("ownerId", this.ownerId);
        nbt.func_74757_a("containsDog", this.containsDog);
        nbt.func_74768_a("front", this.front);
        nbt.func_74757_a("dogHealing", this.containsDog && this.healingRemaining > 0.0f);
        nbt.func_74768_a("roofColor", this.roofColor);
        nbt.func_74768_a("dogBreed", this.dogBreed);
        nbt.func_74768_a("dogCollar", this.dogCollar);
        nbt.func_74768_a("dogCoat", this.dogCoat);
        nbt.func_74778_a("wood", this.wood);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74778_a("dogName", this.dogName);
        nbt.func_74778_a("dogId", this.dogId);
        nbt.func_74778_a("ownerId", this.ownerId);
        nbt.func_74778_a("dogSkills", this.dogSkills);
        nbt.func_74778_a("dogData", this.dogData);
        nbt.func_74757_a("containsDog", this.containsDog);
        nbt.func_74776_a("healingRemaining", this.healingRemaining);
        nbt.func_74768_a("healRate", this.healRate);
        nbt.func_74768_a("front", this.front);
        nbt.func_74778_a("soundset", this.soundset);
        nbt.func_74768_a("roofColor", this.roofColor);
        nbt.func_74768_a("dogBreed", this.dogBreed);
        nbt.func_74768_a("dogCollar", this.dogCollar);
        nbt.func_74768_a("dogCoat", this.dogCoat);
        nbt.func_74778_a("wood", this.wood);
        nbt.func_74768_a("dogAge", this.dogAge);
        for (int i = 0; i < this.puppies.size(); ++i) {
            this.puppies.get(i).writeToNBT(nbt, i);
        }
    }

    private class PuppyData {
        private int age;
        private String dogData;
        private String dogSkills;
        private String name;

        public PuppyData() {
        }

        public PuppyData(NBTTagCompound nbt, int id) {
            this.age = nbt.func_74762_e("age_" + id);
            this.dogData = nbt.func_74779_i("data_" + id);
            this.dogSkills = nbt.func_74779_i("skills_" + id);
            this.name = nbt.func_74779_i("name_" + id);
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public String getDogData() {
            return this.dogData;
        }

        public void setDogData(String dogData) {
            this.dogData = dogData;
        }

        public String getDogSkills() {
            return this.dogSkills;
        }

        public void setDogSkills(String dogSkills) {
            this.dogSkills = dogSkills;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void writeToNBT(NBTTagCompound nbt, int id) {
            nbt.func_74778_a("data_" + id, this.dogData);
            nbt.func_74778_a("skills_" + id, this.dogSkills);
            nbt.func_74768_a("age_" + id, this.age);
            nbt.func_74778_a("name_" + id, this.name);
        }
    }
}

