/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.doggystyle.tileentity;

import com.seiferware.minecraft.doggystyle.breeds.Breed;
import com.seiferware.minecraft.doggystyle.entity.EntityDog;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityHydrant
extends TileEntity {
    private int front = 0;
    private int color = 0;
    private int timer = 100;

    public boolean canUpdate() {
        return true;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public int getFront() {
        return this.front;
    }

    public void setFront(int front) {
        this.front = front;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.color = nbt.func_74762_e("color");
        this.front = nbt.func_74762_e("front");
    }

    private void resetTimer(boolean longWait) {
        this.timer = 500 + this.field_145850_b.field_73012_v.nextInt(200) * (longWait ? 20 : 1);
    }

    private boolean shouldSpawn() {
        if (!this.field_145850_b.func_72935_r()) {
            return false;
        }
        if (this.field_145850_b.func_72977_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 24.0) != null) {
            return false;
        }
        if (this.field_145850_b.func_72977_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 128.0) == null) {
            return false;
        }
        AxisAlignedBB bb = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.field_145850_b.func_72872_a(EntityDog.class, bb.func_72314_b(16.0, 5.0, 16.0)).isEmpty();
    }

    private boolean trySpawn() {
        EntityDog ed;
        double x = (float)this.field_145851_c + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 4.0f;
        double z = (float)this.field_145849_e + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 4.0f;
        double y = this.field_145848_d + this.field_145850_b.field_73012_v.nextInt(3) - 1;
        switch (this.color) {
            case 0: {
                ed = new EntityDog(this.field_145850_b, Breed.FILTER_LARGE);
                break;
            }
            case 2: {
                ed = new EntityDog(this.field_145850_b, Breed.FILTER_MEDIUM);
                break;
            }
            case 1: {
                ed = new EntityDog(this.field_145850_b, Breed.FILTER_SMALL);
                break;
            }
            default: {
                ed = new EntityDog(this.field_145850_b);
            }
        }
        ed.func_70012_b(x, y, z, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
        if (ed.getCanSpawnHereHydrant()) {
            ed.func_110161_a(null);
            this.field_145850_b.func_72838_d((Entity)ed);
            ed.setBehavior(1);
            ed.getDogData().setInt(14, 3);
            return true;
        }
        return false;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.timer-- <= 0) {
            if (this.shouldSpawn()) {
                if (this.trySpawn()) {
                    this.resetTimer(true);
                } else if (this.field_145850_b.field_73012_v.nextInt(20) == 0) {
                    this.resetTimer(false);
                }
            } else if (this.field_145850_b.field_73012_v.nextBoolean()) {
                this.resetTimer(false);
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("color", this.color);
        nbt.func_74768_a("front", this.front);
    }
}

