/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.doggystyle.utils;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.seiferware.minecraft.doggystyle.DoggyStyle;
import com.seiferware.minecraft.doggystyle.blocks.DogHouse;
import com.seiferware.minecraft.doggystyle.blocks.HerdStaff;
import com.seiferware.minecraft.doggystyle.blocks.Hydrant;
import com.seiferware.minecraft.doggystyle.breeds.Breed;
import com.seiferware.minecraft.doggystyle.entity.EntityDog;
import com.seiferware.minecraft.doggystyle.gui.AssignHerderDogList;
import com.seiferware.minecraft.doggystyle.gui.AssignHomeDogList;
import com.seiferware.minecraft.doggystyle.gui.DogMenu;
import com.seiferware.minecraft.doggystyle.gui.NameGui;
import com.seiferware.minecraft.doggystyle.items.DogEgg;
import com.seiferware.minecraft.doggystyle.net.DogHouseAssignPacket;
import com.seiferware.minecraft.doggystyle.net.DogUpdatePacket;
import com.seiferware.minecraft.doggystyle.net.NameUpdatePacket;
import com.seiferware.minecraft.doggystyle.tileentity.TileEntityDogHouse;
import com.seiferware.minecraft.doggystyle.tileentity.TileEntityHerdStaff;
import com.seiferware.minecraft.doggystyle.tileentity.TileEntityHydrant;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWood;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.oredict.ShapedOreRecipe;

public abstract class CommonProxy
implements IGuiHandler {
    public static final int GUI_DOGMENU = 1;
    public static final int GUI_DOG_FOR_HOUSE = 3;
    public static final int GUI_NAME = 2;
    public static final int GUI_DOG_FOR_HERDING = 4;

    public void createRecipes() {
        ItemStack anyWood = new ItemStack(Blocks.field_150344_f, 1, Short.MAX_VALUE);
        ItemStack bowl = new ItemStack(Items.field_151054_z);
        ItemStack bone = new ItemStack(Items.field_151103_aS);
        ItemStack feather = new ItemStack(Items.field_151008_G);
        ItemStack leather = new ItemStack(Items.field_151116_aA);
        ItemStack wool = new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE);
        ItemStack pork = new ItemStack(Items.field_151147_al);
        String iron = "ingotIron";
        String stick = "stickWood";
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(DoggyStyle.ITEM_DOG_WHISTLE), new Object[]{"i  ", " i ", "  i", Character.valueOf('i'), iron}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(DoggyStyle.ITEM_DOG_WHISTLE), new Object[]{"  i", " i ", "i  ", Character.valueOf('i'), iron}));
        for (int i = 0; i < BlockWood.field_150096_a.length; ++i) {
            String wood = BlockWood.field_150096_a[i];
            if (wood.equals("oak")) continue;
            DogHouse house = new DogHouse(wood);
            GameRegistry.registerBlock((Block)house, (String)("dog_house_" + wood));
            ItemStack woodStack = new ItemStack(Blocks.field_150344_f, 1, i);
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)house), (Object[])new Object[]{"www", "wxw", "wbw", Character.valueOf('b'), bowl, Character.valueOf('w'), woodStack, Character.valueOf('x'), bone});
            this.registerItemRenderer(Item.func_150898_a((Block)house), wood);
            house.func_149647_a(DoggyStyle.getTab());
        }
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(DoggyStyle.BLOCK_DOG_HOUSE), (Object[])new Object[]{"www", "wxw", "wbw", Character.valueOf('b'), bowl, Character.valueOf('w'), anyWood, Character.valueOf('x'), bone});
        ItemStack water = new ItemStack(Items.field_151131_as);
        String dye_r = "dyeRed";
        String dye_y = "dyeYellow";
        String dye_b = "dyeBlue";
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(DoggyStyle.BLOCK_HYDRANT, 1, 0), new Object[]{" i ", "idi", "iwi", Character.valueOf('i'), iron, Character.valueOf('d'), dye_r, Character.valueOf('w'), water}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(DoggyStyle.BLOCK_HYDRANT, 1, 1), new Object[]{" i ", "idi", "iwi", Character.valueOf('i'), iron, Character.valueOf('d'), dye_y, Character.valueOf('w'), water}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(DoggyStyle.BLOCK_HYDRANT, 1, 2), new Object[]{" i ", "idi", "iwi", Character.valueOf('i'), iron, Character.valueOf('d'), dye_b, Character.valueOf('w'), water}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(DoggyStyle.BLOCK_HERD_STAFF[4]), new Object[]{"x", "i", "i", Character.valueOf('x'), feather, Character.valueOf('i'), stick}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(DoggyStyle.BLOCK_HERD_STAFF[2]), new Object[]{"x", "i", "i", Character.valueOf('x'), leather, Character.valueOf('i'), stick}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(DoggyStyle.BLOCK_HERD_STAFF[3]), new Object[]{"x", "i", "i", Character.valueOf('x'), pork, Character.valueOf('i'), stick}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(DoggyStyle.BLOCK_HERD_STAFF[1]), new Object[]{"x", "i", "i", Character.valueOf('x'), wool, Character.valueOf('i'), stick}));
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        switch (ID) {
            case 1: {
                EntityDog dog = (EntityDog)world.func_73045_a(x);
                if (dog == null) {
                    return null;
                }
                return new DogMenu(dog);
            }
            case 2: {
                return new NameGui((EntityDog)world.func_73045_a(x));
            }
            case 3: {
                TileEntityDogHouse house;
                TileEntity ent = world.func_147438_o(x, y, z);
                if (ent != null && ent instanceof TileEntityDogHouse && (house = (TileEntityDogHouse)ent).getOwnerId().equals(player.func_110124_au().toString()) && house.getDogId().equals("")) {
                    return new AssignHomeDogList(player, house);
                }
                return null;
            }
            case 4: {
                TileEntity ent2 = world.func_147438_o(x, y, z);
                if (ent2 != null && ent2 instanceof TileEntityHerdStaff) {
                    TileEntityHerdStaff staff = (TileEntityHerdStaff)ent2;
                    return new AssignHerderDogList(player, staff);
                }
                return null;
            }
        }
        return null;
    }

    public EntityPlayer getPlayer() {
        return null;
    }

    public String getPlayerName() {
        return "";
    }

    public abstract Random getRand();

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public abstract boolean isClient();

    public void registerBlocks() {
        DoggyStyle.BLOCK_DOG_HOUSE = new DogHouse().func_149647_a(DoggyStyle.getTab());
        GameRegistry.registerBlock((Block)DoggyStyle.BLOCK_DOG_HOUSE, (String)"dog_house");
        GameRegistry.registerTileEntity(TileEntityDogHouse.class, (String)"DogHouse");
        Item.func_150898_a((Block)DoggyStyle.BLOCK_DOG_HOUSE).func_77625_d(1);
        DoggyStyle.BLOCK_HYDRANT = new Hydrant().func_149647_a(DoggyStyle.getTab());
        GameRegistry.registerBlock((Block)DoggyStyle.BLOCK_HYDRANT, (String)"hydrant");
        GameRegistry.registerTileEntity(TileEntityHydrant.class, (String)"Hydrant");
        Item.func_150898_a((Block)DoggyStyle.BLOCK_HYDRANT).func_77625_d(1);
        for (int i = 1; i < 5; ++i) {
            DoggyStyle.BLOCK_HERD_STAFF[i] = new HerdStaff(i).func_149647_a(DoggyStyle.getTab());
            GameRegistry.registerBlock((Block)DoggyStyle.BLOCK_HERD_STAFF[i], (String)("herdStaff_" + HerdStaff.animalName[i]));
        }
        GameRegistry.registerTileEntity(TileEntityHerdStaff.class, (String)"HerdStaff");
    }

    protected void registerItemRenderer(Item item, String wood) {
    }

    public void registerItems() {
        DoggyStyle.ITEM_DOG_WHISTLE = new Item().func_77637_a(DoggyStyle.getTab()).func_77625_d(16).func_111206_d("doggystyle:dog_whistle").func_77655_b("dog_whistle");
        for (int b = 0; b < Breed.getBreedCount(); ++b) {
            Breed breed = Breed.getBreed(b);
            GameRegistry.registerItem((Item)new DogEgg(breed), (String)(breed.getUnlocalizedName() + "Egg"));
        }
        GameRegistry.registerItem((Item)DoggyStyle.ITEM_DOG_WHISTLE, (String)"dog_whistle");
    }

    public void registerMobRenderers() {
    }

    public void registerMobs() {
        int mob = 0;
        EntityRegistry.registerModEntity(EntityDog.class, (String)"Dog", (int)mob, (Object)DoggyStyle.instance, (int)80, (int)3, (boolean)true);
        DoggyStyle.Config config = DoggyStyle.getConfig();
        if (config.getSpawnWeight() > 0) {
            EntityRegistry.addSpawn(EntityDog.class, (int)config.getSpawnWeight(), (int)config.getSpawnMin(), (int)config.getSpawnMax(), (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])((BiomeGenBase[])Iterators.toArray((Iterator)Iterators.filter((Iterator)Iterators.forArray((Object[])BiomeGenBase.func_150565_n()), (Predicate)Predicates.notNull()), BiomeGenBase.class)));
        }
    }

    public void registerPackets() {
        new DogUpdatePacket().registerPacket(DoggyStyle.networkChannel, 1, Side.SERVER);
        new NameUpdatePacket().registerPacket(DoggyStyle.networkChannel, 2, Side.SERVER);
        new DogHouseAssignPacket().registerPacket(DoggyStyle.networkChannel, 3, Side.SERVER);
    }
}

