/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.utils.data;

import com.seiferware.minecraft.utils.data.DataObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BetterDataWatcher {
    private Map<String, Object> data = new HashMap<String, Object>();
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    void updateObject(String id, Object value) {
        this.lock.writeLock().lock();
        if (value == null) {
            this.data.remove(id);
        } else {
            this.data.put(id, new DataObject(id, value));
        }
        this.lock.writeLock().unlock();
    }

    void setData(String id, Object value) {
        this.lock.readLock().lock();
        this.updateObject(id, value);
        this.lock.readLock().unlock();
    }

    public String getString(String id) {
        return (String)this.data.get(id);
    }

    public Float getFloat(String id) {
        return (Float)this.data.get(id);
    }

    public Integer getInteger(String id) {
        return (Integer)this.data.get(id);
    }

    public Boolean getBoolean(String id) {
        return (Boolean)this.data.get(id);
    }
}

