/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.utils.data;

import net.minecraft.entity.DataWatcher;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;

public class EntityData {
    protected Entity entity;
    protected DataWatcher dw;
    protected int slot = 0;
    protected String lastValue = "";
    protected String[] lastValues = new String[0];

    public EntityData(Entity entity, int slot) {
        this.entity = entity;
        this.dw = entity.func_70096_w();
        this.slot = slot;
        this.dw.func_75682_a(slot, (Object)"");
    }

    protected void assignValue(int id, String value) {
        this.updateData();
        StringBuilder sb = new StringBuilder();
        if (this.lastValues.length <= id) {
            sb.append(this.lastValue);
            for (int i = this.lastValues.length; i <= id; ++i) {
                sb.append(":");
            }
            sb.append(value);
            this.lastValue = sb.toString();
            this.lastValues = this.lastValue.split(":");
        } else {
            if (value.equals(this.lastValues[id])) {
                // empty if block
            }
            this.lastValues[id] = value;
            for (int i = 0; i < this.lastValues.length; ++i) {
                if (i > 0) {
                    sb.append(":");
                }
                sb.append(this.lastValues[i]);
            }
            this.lastValue = sb.toString();
        }
        this.dw.func_75692_b(this.slot, (Object)this.lastValue);
    }

    public String getAllData() {
        return this.dw.func_75681_e(this.slot);
    }

    public boolean getBool(int id) {
        return "true".equals(this.retrieveValue(id));
    }

    public float getFloat(int id) {
        try {
            return new Float(this.retrieveValue(id)).floatValue();
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public int getInt(int id) {
        try {
            return new Integer(this.retrieveValue(id));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public String getString(int id) {
        return this.retrieveValue(id);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.setAllData(nbt.func_74779_i("EntityData" + this.slot));
        this.updateData();
    }

    protected String retrieveValue(int id) {
        this.updateData();
        try {
            return this.lastValues[id];
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void setAllData(String data) {
        this.dw.func_75692_b(this.slot, (Object)data);
    }

    public void setBool(int id, boolean value) {
        this.assignValue(id, value ? "true" : "false");
    }

    public void setFloat(int id, float value) {
        this.assignValue(id, "" + value);
    }

    public void setInt(int id, int value) {
        this.assignValue(id, "" + value);
    }

    public void setString(int id, String value) {
        this.assignValue(id, value);
    }

    public String toString() {
        return this.lastValue;
    }

    public void updateData() {
        String newData = this.dw.func_75681_e(this.slot);
        if (newData.equals(this.lastValue)) {
            // empty if block
        }
        this.lastValue = newData;
        this.lastValues = this.lastValue.split(":");
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("EntityData" + this.slot, this.getAllData());
    }
}

