/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.utils.gui;

import com.seiferware.minecraft.utils.gui.Box2D;
import com.seiferware.minecraft.utils.gui.ButtonLayout;
import com.seiferware.minecraft.utils.gui.GuiTextLabel;
import com.seiferware.minecraft.utils.gui.IGuiItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;

@SideOnly(value=Side.CLIENT)
public class BaseGui
extends GuiScreen {
    private int paddingX = 20;
    private int paddingY = 20;
    private int rowsBottom = 0;
    private int rowsTop = 0;
    private List<IGuiItem> items = new ArrayList<IGuiItem>();
    private Map<Integer, String> actions = new HashMap<Integer, String>();
    private Map<String, GuiButton> buttonsByCmd = new HashMap<String, GuiButton>();
    private Map<String, String> buttonTooltips = new HashMap<String, String>();

    protected final void func_146284_a(GuiButton btn) {
        this.onCommand(this.actions.get(btn.field_146127_k));
    }

    protected final GuiButton addButton(Box2D loc, String text, String action) {
        GuiButton res = new GuiButton(this.field_146292_n.size() + 1, loc.x, loc.y, loc.width, loc.height, text);
        this.field_146292_n.add(res);
        this.actions.put(res.field_146127_k, action);
        this.buttonsByCmd.put(action, res);
        return res;
    }

    protected final GuiButton[] addButtonRow(Map<String, String> buttons, int cols) {
        return this.addButtonRow(buttons, cols, false);
    }

    protected final GuiButton[] addButtonRow(Map<String, String> buttons, int cols, boolean toBottom) {
        GuiButton[] result = new GuiButton[buttons.size()];
        int rows = (int)Math.ceil(buttons.size() / cols);
        int y = 0;
        if (toBottom) {
            this.rowsBottom += rows;
            y = this.field_146295_m - (this.paddingY + 20) * this.rowsBottom - this.paddingY;
        } else {
            y = this.rowsTop * (this.paddingY + 20);
            this.rowsTop += rows;
        }
        ButtonLayout box = new ButtonLayout(new Box2D(0, y, this.field_146294_l, 0), cols, this.paddingX, this.paddingY);
        int i = 0;
        for (String key : buttons.keySet()) {
            result[i] = this.addButton(box.getCell(i++), buttons.get(key), key);
        }
        return result;
    }

    protected final void addGuiItemRow(IGuiItem[] items, int cols, boolean toBottom) {
        int rows = (int)Math.ceil(items.length / cols);
        int y = 0;
        if (toBottom) {
            this.rowsBottom += rows;
            y = this.field_146295_m - (this.paddingY + 20) * this.rowsBottom - this.paddingY;
        } else {
            y = this.rowsTop * (this.paddingY + 20);
            this.rowsTop += rows;
        }
        ButtonLayout box = new ButtonLayout(new Box2D(0, y, this.field_146294_l, 0), cols, this.paddingX, this.paddingY);
        for (int i = 0; i < items.length; ++i) {
            items[i].setArea(box.getCell(i++));
            this.items.add(items[i]);
        }
    }

    protected final GuiTextLabel addLabel(Box2D loc, String text) {
        GuiTextLabel res = new GuiTextLabel(this.field_146289_q, loc, text);
        this.items.add(res);
        return res;
    }

    protected final GuiTextLabel[] addLabelRow(List<String> items, int cols, boolean toBottom) {
        GuiTextLabel[] result = new GuiTextLabel[items.size()];
        int rows = (int)Math.ceil(items.size() / cols);
        int y = 0;
        if (toBottom) {
            this.rowsBottom += rows;
            y = this.field_146295_m - (this.paddingY + 20) * this.rowsBottom - this.paddingY;
        } else {
            y = this.rowsTop * (this.paddingY + 20);
            this.rowsTop += rows;
        }
        ButtonLayout box = new ButtonLayout(new Box2D(0, y, this.field_146294_l, 0), cols, this.paddingX, this.paddingY);
        for (int i = 0; i < items.size(); ++i) {
            result[i] = this.addLabel(box.getCell(i), items.get(i));
        }
        return result;
    }

    protected final GuiTextLabel[] addLabelRow(List<String> items, int cols) {
        return this.addLabelRow(items, cols, false);
    }

    protected final GuiTextLabel addTextRow(String text, boolean toBottom) {
        int y;
        if (toBottom) {
            ++this.rowsBottom;
            y = this.field_146295_m - (this.paddingY + 20) * this.rowsBottom - this.paddingY;
        } else {
            y = this.rowsTop * (this.paddingY + 20);
            ++this.rowsTop;
        }
        return this.addLabel(new Box2D(0, y, this.field_146294_l, 0).getPadded(this.paddingX, this.paddingY), text);
    }

    protected final void close() {
        Minecraft.func_71410_x().field_71439_g.func_71053_j();
    }

    protected void customDrawScreen(int par1, int par2, float par3) {
    }

    public final void addButtonTooltip(String act, String text) {
        this.buttonTooltips.put(act, text);
    }

    public final void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        this.customDrawScreen(par1, par2, par3);
        super.func_73863_a(par1, par2, par3);
        for (IGuiItem item : this.items) {
            item.draw();
            if (item.getTooltipText() == null || item.getTooltipText().isEmpty() || par1 < item.getArea().getX() || par1 >= item.getArea().getX() + item.getArea().getWidth() || par2 < item.getArea().getY() || par2 >= item.getArea().getY() + item.getArea().getHeight()) continue;
            ArrayList<String> txt = new ArrayList<String>();
            txt.add(item.getTooltipText());
            this.drawHoveringText(txt, par1, par2, this.field_146289_q);
        }
        for (String btn : this.buttonsByCmd.keySet()) {
            if (!this.buttonTooltips.containsKey(btn)) continue;
            GuiButton gbtn = this.buttonsByCmd.get(btn);
            if (par1 < gbtn.field_146128_h || par1 >= gbtn.field_146128_h + gbtn.field_146120_f || par2 < gbtn.field_146129_i || par2 >= gbtn.field_146129_i + gbtn.field_146121_g) continue;
            ArrayList<String> txt = new ArrayList<String>();
            txt.add(this.buttonTooltips.get(btn));
            this.drawHoveringText(txt, par1, par2, this.field_146289_q);
        }
    }

    protected final GuiButton getButton(String action) {
        return this.buttonsByCmd.get(action);
    }

    public int getPaddingX() {
        return this.paddingX;
    }

    public void setPaddingX(int paddingX) {
        this.paddingX = paddingX;
    }

    public int getPaddingY() {
        return this.paddingY;
    }

    public void setPaddingY(int paddingY) {
        this.paddingY = paddingY;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.items.clear();
        this.rowsTop = 0;
        this.rowsBottom = 0;
    }

    protected void onCommand(String command) {
    }
}

