/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.utils.gui;

public class Box2D {
    protected final int x;
    protected final int y;
    protected final int width;
    protected final int height;

    public Box2D(Box2D base) {
        this.x = base.x;
        this.y = base.y;
        this.width = base.width;
        this.height = base.height;
    }

    public Box2D(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    public Box2D getBottom(int h) {
        return new Box2D(this.x, this.y + this.height - h, this.width, Math.abs(h));
    }

    public int getHeight() {
        return this.height;
    }

    public Box2D getLeft(int w) {
        if (w >= 0) {
            return new Box2D(this.x, this.y, w, this.height);
        }
        return new Box2D(this.x + w, this.y, -w, this.height);
    }

    public Box2D getPadded(int p) {
        return new Box2D(this.x + p, this.y + p, this.width - p * 2, this.height - p * 2);
    }

    public Box2D getPadded(int px, int py) {
        return new Box2D(this.x + px, this.y + py, this.width - px * 2, this.height - py * 2);
    }

    public Box2D getRight(int w) {
        return new Box2D(this.x + this.width - w, this.y, Math.abs(w), this.height);
    }

    public Box2D getTop(int h) {
        if (h >= 0) {
            return new Box2D(this.x, this.y, this.width, h);
        }
        return new Box2D(this.x, this.y + h, this.width, -h);
    }

    public int getWidth() {
        return this.width;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

