/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.utils.gui;

import com.seiferware.minecraft.utils.gui.Box2D;
import com.seiferware.minecraft.utils.gui.IGuiItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;

public class GuiTextLabel
implements IGuiItem {
    private Box2D area;
    private boolean centered;
    private List<String> text = new ArrayList<String>();
    private FontRenderer renderer;
    private int color = 0xFFFFFF;

    public GuiTextLabel(FontRenderer renderer, Box2D area, String text) {
        this.setArea(area);
        this.renderer = renderer;
        this.addLine(text);
    }

    public void addLine(String text) {
        this.text.add(text);
        this.area = this.area.getTop((int)((double)this.renderer.field_78288_b * 1.2 * (double)this.text.size()));
    }

    public void clearText() {
        this.text.clear();
        this.area = this.area.getTop(0);
    }

    @Override
    public void draw() {
        int y = this.area.y + (int)Math.floor((double)this.renderer.field_78288_b * 0.1);
        for (String string : this.text) {
            if (this.centered) {
                this.drawCenteredString(this.renderer, string, this.area.x + this.area.width / 2, y, this.color);
            } else {
                this.drawString(this.renderer, string, this.area.x, y, this.color);
            }
            y = (int)((double)y + (double)this.renderer.field_78288_b * 1.2);
        }
        Gui.func_73734_a((int)this.area.x, (int)this.area.y, (int)(this.area.x + this.area.width), (int)(this.area.y + this.area.height), (int)this.color);
    }

    public void drawCenteredString(FontRenderer p_73732_1_, String p_73732_2_, int p_73732_3_, int p_73732_4_, int p_73732_5_) {
        p_73732_1_.func_78261_a(p_73732_2_, p_73732_3_ - p_73732_1_.func_78256_a(p_73732_2_) / 2, p_73732_4_, p_73732_5_);
    }

    public void drawString(FontRenderer p_73731_1_, String p_73731_2_, int p_73731_3_, int p_73731_4_, int p_73731_5_) {
        p_73731_1_.func_78261_a(p_73731_2_, p_73731_3_, p_73731_4_, p_73731_5_);
    }

    @Override
    public Box2D getArea() {
        return this.area;
    }

    @Override
    public void setArea(Box2D area) {
        this.area = area;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public void setCentered(boolean centered) {
        this.centered = centered;
    }

    @Override
    public String getTooltipText() {
        return null;
    }
}

