/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.utils.gui;

import com.seiferware.minecraft.utils.gui.BaseGui;
import com.seiferware.minecraft.utils.gui.Box2D;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiTextField;

@SideOnly(value=Side.CLIENT)
public class TextGui
extends BaseGui {
    private GuiTextField input;
    private String caption = "";
    private String okayText = "OK";
    private String cancelText = "Cancel";
    private String defaultValue = "";
    private int maxLength = 24;

    public TextGui(String caption, String okayText) {
        this.caption = caption;
        this.okayText = okayText;
    }

    public TextGui(String caption, String okayText, String cancelText) {
        this(caption, okayText);
        this.cancelText = cancelText;
    }

    public TextGui(String caption, String okayText, String cancelText, String defaultValue) {
        this(caption, okayText, cancelText);
        this.defaultValue = defaultValue;
    }

    @Override
    public void customDrawScreen(int par1, int par2, float par3) {
        this.input.func_146194_f();
        this.func_73732_a(this.field_146289_q, this.caption, this.field_146294_l / 2, this.field_146295_m / 2 - 30, 0xFFFFFF);
    }

    public Box2D getInputArea() {
        return new Box2D(this.input.field_146209_f, this.input.field_146210_g, this.input.field_146218_h, this.input.field_146219_i);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int cx = this.field_146294_l / 2;
        int cy = this.field_146295_m / 2;
        this.addButton(new Box2D(cx - 100, cy + 20, this.cancelText == null ? 200 : 95, 20), this.okayText, "okayPressed");
        if (this.cancelText != null) {
            this.addButton(new Box2D(cx + 5, cy + 20, 95, 20), this.cancelText, "cancelPressed");
        }
        this.input = new GuiTextField(this.field_146289_q, cx - 100, cy - 10, 200, 20);
        this.input.func_146195_b(true);
        this.input.func_146203_f(this.maxLength);
        this.input.func_146180_a(this.defaultValue);
    }

    protected void func_73869_a(char c, int i) {
        super.func_73869_a(c, i);
        this.input.func_146201_a(c, i);
        if (c == '\r') {
            this.onCommand("okayPressed");
        } else if (c == '\u001b' && this.cancelText != null) {
            this.onCommand("cancelPressed");
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        this.input.func_146192_a(par1, par2, par3);
    }

    protected void onCancel() {
    }

    @Override
    protected final void onCommand(String command) {
        if (command.equals("okayPressed")) {
            if (this.onSubmit(this.input.func_146179_b())) {
                this.close();
            }
        } else if (command.equals("cancelPressed")) {
            this.onCancel();
            this.close();
        }
    }

    protected boolean onSubmit(String text) {
        return true;
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
        if (this.input != null) {
            this.input.func_146203_f(n);
        }
    }
}

