/*
 * Decompiled with CFR 0.152.
 */
package com.seiferware.minecraft.utils.net;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import net.minecraft.entity.player.EntityPlayer;

public abstract class SimplePacket
implements IMessage,
IMessageHandler<SimplePacket, IMessage> {
    private static final String EOL = System.getProperty("line.separator");
    private static final char[] _hexcodes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] _shifts = new int[]{28, 24, 20, 16, 12, 8, 4, 0};

    private static void dump(byte[] data, long offset, OutputStream stream, int index) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (index < 0 || index >= data.length) {
            throw new ArrayIndexOutOfBoundsException("Illegal index " + index + " into array of length " + data.length);
        }
        if (stream == null) {
            throw new IllegalArgumentException("Cannot write to null stream");
        }
        long display_offset = offset + (long)index;
        StringBuffer buffer = new StringBuffer(74);
        for (int j = index; j < data.length; j += 16) {
            int k;
            int chars_read = data.length - j;
            if (chars_read > 16) {
                chars_read = 16;
            }
            SimplePacket.dump(buffer, display_offset).append(' ');
            for (k = 0; k < 16; ++k) {
                if (k < chars_read) {
                    SimplePacket.dump(buffer, data[k + j]);
                } else {
                    buffer.append("  ");
                }
                buffer.append(' ');
            }
            for (k = 0; k < chars_read; ++k) {
                if (data[k + j] >= 32 && data[k + j] < 127) {
                    buffer.append((char)data[k + j]);
                    continue;
                }
                buffer.append('.');
            }
            buffer.append(EOL);
            stream.write(buffer.toString().getBytes());
            stream.flush();
            buffer.setLength(0);
            display_offset += (long)chars_read;
        }
    }

    private static StringBuffer dump(StringBuffer _lbuffer, long value) {
        for (int j = 0; j < 8; ++j) {
            _lbuffer.append(_hexcodes[(int)(value >> _shifts[j]) & 0xF]);
        }
        return _lbuffer;
    }

    private static StringBuffer dump(StringBuffer _cbuffer, byte value) {
        for (int j = 0; j < 2; ++j) {
            _cbuffer.append(_hexcodes[value >> _shifts[j + 6] & 0xF]);
        }
        return _cbuffer;
    }

    private static String getDump(ByteBuf data) {
        int i = data.readerIndex();
        data.readerIndex(0);
        byte[] b = new byte[data.readableBytes()];
        data.readBytes(b);
        data.readerIndex(i);
        return SimplePacket.getDump(b);
    }

    private static String getDump(byte[] data) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            SimplePacket.dump(data, 0L, b, 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ((Object)b).toString();
    }

    public abstract IMessage act(EntityPlayer var1);

    public final void fromBytes(ByteBuf in) {
        this.readData(in);
    }

    public final IMessage onMessage(SimplePacket message, MessageContext ctx) {
        return message.act((EntityPlayer)(ctx.side == Side.CLIENT ? null : ctx.getServerHandler().field_147369_b));
    }

    public abstract void readData(ByteBuf var1);

    protected final String readString(ByteBuf in) {
        int len = in.readInt();
        if (len == 0) {
            return "";
        }
        byte[] bytes = new byte[len];
        in.readBytes(bytes);
        return new String(bytes, Charset.forName("UTF-8"));
    }

    public void registerPacket(SimpleNetworkWrapper networkChannel, int id, Side side) {
        networkChannel.registerMessage((IMessageHandler)this, this.getClass(), id, side);
    }

    public final void toBytes(ByteBuf out) {
        this.writeData(out);
    }

    public abstract void writeData(ByteBuf var1);

    protected final void writeString(ByteBuf out, String text) {
        if (text == null || "".equals(text)) {
            out.writeInt(0);
            return;
        }
        byte[] bytes = text.getBytes(Charset.forName("UTF-8"));
        out.writeInt(bytes.length);
        out.writeBytes(bytes);
    }
}

