/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block;

import cofh.api.tileentity.ISecurable;
import cofh.core.CoFHProps;
import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.util.Utils;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public abstract class TileInventory
extends TileTEBase
implements IInventory,
ISecurable {
    protected GameProfile owner = CoFHProps.DEFAULT_OWNER;
    protected ISecurable.AccessMode access = ISecurable.AccessMode.PUBLIC;
    protected boolean canAccess = true;
    protected boolean inWorld = false;
    public ItemStack[] inventory = new ItemStack[0];

    public void cofh_validate() {
        this.inWorld = true;
    }

    public void cofh_invalidate() {
        this.inWorld = false;
    }

    public boolean canAccess() {
        return this.canAccess;
    }

    public boolean isSecured() {
        return !SecurityHelper.isDefaultUUID((UUID)this.owner.getId());
    }

    public boolean enableSecurity() {
        return true;
    }

    public boolean extractItem(int n, int n2, int n3) {
        if (n > this.inventory.length) {
            return false;
        }
        ItemStack itemStack = this.inventory[n];
        if (itemStack != null) {
            n2 = Math.min(n2, itemStack.func_77976_d() - itemStack.field_77994_a);
            itemStack = this.inventory[n].func_77946_l();
        }
        int n4 = n2;
        TileEntity tileEntity = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)n3);
        if (Utils.isAccessibleInput(tileEntity, n3)) {
            if (tileEntity instanceof ISidedInventory) {
                ISidedInventory iSidedInventory = (ISidedInventory)tileEntity;
                int[] nArray = iSidedInventory.func_94128_d((int)BlockHelper.SIDE_OPPOSITE[n3]);
                if (nArray == null) {
                    return false;
                }
                for (int i = 0; i < nArray.length && n2 > 0; ++i) {
                    int n5;
                    ItemStack itemStack2 = iSidedInventory.func_70301_a(nArray[i]);
                    if (itemStack2 == null || !iSidedInventory.func_102008_b(nArray[i], itemStack2, n3 ^ 1)) continue;
                    if (itemStack == null) {
                        if (!this.func_94041_b(n, itemStack2)) continue;
                        n5 = Math.min(n2, itemStack2.field_77994_a);
                        itemStack = ItemHelper.cloneStack((ItemStack)itemStack2, (int)n5);
                        itemStack2.field_77994_a -= n5;
                        if (itemStack2.field_77994_a <= 0) {
                            iSidedInventory.func_70299_a(nArray[i], null);
                        } else {
                            iSidedInventory.func_70299_a(nArray[i], itemStack2);
                        }
                        n2 -= n5;
                        continue;
                    }
                    if (!ItemHelper.itemsEqualWithMetadata((ItemStack)itemStack, (ItemStack)itemStack2, (boolean)true)) continue;
                    n5 = Math.min(itemStack.func_77976_d() - itemStack.field_77994_a, Math.min(n2, itemStack2.field_77994_a));
                    itemStack.field_77994_a += n5;
                    itemStack2.field_77994_a -= n5;
                    if (itemStack2.field_77994_a <= 0) {
                        iSidedInventory.func_70299_a(nArray[i], null);
                    } else {
                        iSidedInventory.func_70299_a(nArray[i], itemStack2);
                    }
                    n2 -= n5;
                }
            } else {
                IInventory iInventory = (IInventory)tileEntity;
                for (int i = 0; i < iInventory.func_70302_i_() && n2 > 0; ++i) {
                    int n6;
                    ItemStack itemStack3 = iInventory.func_70301_a(i);
                    if (itemStack3 == null) continue;
                    if (itemStack == null) {
                        if (!this.func_94041_b(n, itemStack3)) continue;
                        n6 = Math.min(n2, itemStack3.field_77994_a);
                        itemStack = ItemHelper.cloneStack((ItemStack)itemStack3, (int)n6);
                        itemStack3.field_77994_a -= n6;
                        if (itemStack3.field_77994_a <= 0) {
                            iInventory.func_70299_a(i, null);
                        } else {
                            iInventory.func_70299_a(i, itemStack3);
                        }
                        n2 -= n6;
                        continue;
                    }
                    if (!ItemHelper.itemsEqualWithMetadata((ItemStack)itemStack, (ItemStack)itemStack3, (boolean)true)) continue;
                    n6 = Math.min(itemStack.func_77976_d() - itemStack.field_77994_a, Math.min(n2, itemStack3.field_77994_a));
                    itemStack.field_77994_a += n6;
                    itemStack3.field_77994_a -= n6;
                    if (itemStack3.field_77994_a <= 0) {
                        iInventory.func_70299_a(i, null);
                    } else {
                        iInventory.func_70299_a(i, itemStack3);
                    }
                    n2 -= n6;
                }
            }
            if (n4 != n2) {
                this.inventory[n] = itemStack;
                tileEntity.func_70296_d();
                return true;
            }
        }
        return false;
    }

    public boolean transferItem(int n, int n2, int n3) {
        if (this.inventory[n] == null || n > this.inventory.length) {
            return false;
        }
        ItemStack itemStack = this.inventory[n].func_77946_l();
        itemStack.field_77994_a = n2 = Math.min(n2, itemStack.field_77994_a);
        int n4 = 0;
        TileEntity tileEntity = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)n3);
        if (Utils.isAccessibleOutput(tileEntity, n3)) {
            n4 = Utils.addToInsertion(tileEntity, n3, itemStack);
            if (n4 >= n2) {
                return false;
            }
            this.inventory[n].field_77994_a -= n2 - n4;
            if (this.inventory[n].field_77994_a <= 0) {
                this.inventory[n] = null;
            }
            return true;
        }
        n4 = 0;
        if (Utils.isPipeTile(tileEntity)) {
            n4 = Utils.addToPipeTile(tileEntity, n3, itemStack);
            if (n4 <= 0) {
                return false;
            }
            this.inventory[n].field_77994_a -= n4;
            if (this.inventory[n].field_77994_a <= 0) {
                this.inventory[n] = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public int getInvSlotCount() {
        return this.inventory.length;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean openGui(EntityPlayer entityPlayer) {
        if (this.canPlayerAccess(entityPlayer)) {
            if (this.hasGui()) {
                entityPlayer.openGui((Object)ThermalExpansion.instance, 0, ((TileEntity)this).field_145850_b, ((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
            }
            return this.hasGui();
        }
        if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b)) {
            entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.cofh.secure", new Object[]{this.getOwnerName()}));
        }
        return false;
    }

    public void receiveGuiNetworkData(int n, int n2) {
        this.canAccess = n2 != 0;
    }

    @Override
    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        super.sendGuiNetworkData(container, iCrafting);
        iCrafting.func_71112_a(container, 0, this.canPlayerAccess((EntityPlayer)iCrafting) ? 1 : 0);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.owner = CoFHProps.DEFAULT_OWNER;
        this.access = ISecurable.AccessMode.values()[nBTTagCompound.func_74771_c("Access")];
        String string = nBTTagCompound.func_74779_i("OwnerUUID");
        String string2 = nBTTagCompound.func_74779_i("Owner");
        if (!Strings.isNullOrEmpty((String)string)) {
            this.setOwner(new GameProfile(UUID.fromString(string), string2));
        } else {
            this.setOwnerName(string2);
        }
        if (!this.enableSecurity()) {
            this.access = ISecurable.AccessMode.PUBLIC;
        }
        this.readInventoryFromNBT(nBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74774_a("Access", (byte)this.access.ordinal());
        nBTTagCompound.func_74778_a("OwnerUUID", this.owner.getId().toString());
        nBTTagCompound.func_74778_a("Owner", this.owner.getName());
        this.writeInventoryToNBT(nBTTagCompound);
    }

    public void readInventoryFromNBT(NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList = nBTTagCompound.func_150295_c("Inventory", 10);
        this.inventory = new ItemStack[this.inventory.length];
        for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
            NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(i);
            int n = nBTTagCompound2.func_74762_e("Slot");
            if (n < 0 || n >= this.inventory.length) continue;
            this.inventory[n] = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound2);
        }
    }

    public void writeInventoryToNBT(NBTTagCompound nBTTagCompound) {
        if (this.inventory.length <= 0) {
            return;
        }
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound2.func_74768_a("Slot", i);
            this.inventory[i].func_77955_b(nBTTagCompound2);
            nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
        }
        if (nBTTagList.func_74745_c() > 0) {
            nBTTagCompound.func_74782_a("Inventory", (NBTBase)nBTTagList);
        }
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addByte((byte)this.access.ordinal());
        packetCoFHBase.addUUID(this.owner.getId());
        packetCoFHBase.addString(this.owner.getName());
        return packetCoFHBase;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        this.access = ISecurable.AccessMode.values()[packetCoFHBase.getByte()];
        if (!bl) {
            this.owner = CoFHProps.DEFAULT_OWNER;
            this.setOwner(new GameProfile(packetCoFHBase.getUUID(), packetCoFHBase.getString()));
        } else {
            packetCoFHBase.getUUID();
            packetCoFHBase.getString();
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int n) {
        return this.inventory[n];
    }

    public ItemStack func_70298_a(int n, int n2) {
        if (this.inventory[n] == null) {
            return null;
        }
        if (this.inventory[n].field_77994_a <= n2) {
            n2 = this.inventory[n].field_77994_a;
        }
        ItemStack itemStack = this.inventory[n].func_77979_a(n2);
        if (this.inventory[n].field_77994_a <= 0) {
            this.inventory[n] = null;
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int n) {
        if (this.inventory[n] == null) {
            return null;
        }
        ItemStack itemStack = this.inventory[n];
        this.inventory[n] = null;
        return itemStack;
    }

    public void func_70299_a(int n, ItemStack itemStack) {
        this.inventory[n] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        if (this.inWorld) {
            this.markChunkDirty();
        }
    }

    public String func_145825_b() {
        return this.tileName.isEmpty() ? this.getName() : this.tileName;
    }

    public boolean func_145818_k_() {
        return !this.tileName.isEmpty();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.isUseable(entityPlayer);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int n, ItemStack itemStack) {
        return true;
    }

    public boolean setAccess(ISecurable.AccessMode accessMode) {
        this.access = accessMode;
        this.sendUpdatePacket(Side.SERVER);
        return true;
    }

    public ISecurable.AccessMode getAccess() {
        return this.access;
    }

    public boolean setOwnerName(String string) {
        if (MinecraftServer.func_71276_C() == null) {
            return false;
        }
        if (Strings.isNullOrEmpty((String)string) || CoFHProps.DEFAULT_OWNER.getName().equalsIgnoreCase(string)) {
            return false;
        }
        String string2 = PreYggdrasilConverter.func_152719_a((String)string);
        if (Strings.isNullOrEmpty((String)string2)) {
            return false;
        }
        return this.setOwner(new GameProfile(UUID.fromString(string2), string));
    }

    public boolean setOwner(GameProfile gameProfile) {
        if (SecurityHelper.isDefaultUUID((UUID)this.owner.getId())) {
            this.owner = gameProfile;
            if (!SecurityHelper.isDefaultUUID((UUID)this.owner.getId())) {
                if (MinecraftServer.func_71276_C() != null) {
                    new Thread("CoFH User Loader"){

                        @Override
                        public void run() {
                            TileInventory.this.owner = SecurityHelper.getProfile((UUID)TileInventory.this.owner.getId(), (String)TileInventory.this.owner.getName());
                        }
                    }.start();
                }
                if (this.inWorld) {
                    this.markChunkDirty();
                }
                return true;
            }
        }
        return false;
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    public String getOwnerName() {
        String string = this.owner.getName();
        if (string == null) {
            return StringHelper.localize((String)"info.cofh.anotherplayer");
        }
        return string;
    }
}

