/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.plate;

import cofh.api.block.IBlockConfigGui;
import cofh.core.render.IconRegistry;
import cofh.core.util.crafting.RecipeUpgrade;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.cell.BlockCell;
import cofh.thermalexpansion.block.plate.TilePlateBase;
import cofh.thermalexpansion.block.plate.TilePlateCharge;
import cofh.thermalexpansion.block.plate.TilePlateExcursion;
import cofh.thermalexpansion.block.plate.TilePlateExcursionClient;
import cofh.thermalexpansion.block.plate.TilePlateImpulse;
import cofh.thermalexpansion.block.plate.TilePlatePoweredBase;
import cofh.thermalexpansion.block.plate.TilePlateSignal;
import cofh.thermalexpansion.block.plate.TilePlateTeleporter;
import cofh.thermalexpansion.block.plate.TilePlateTranslocate;
import cofh.thermalexpansion.core.TEProps;
import cofh.thermalexpansion.item.TEItems;
import cofh.thermalexpansion.util.crafting.TECraftingHandler;
import cofh.thermalexpansion.util.crafting.TransposerManager;
import cofh.thermalfoundation.fluid.TFFluids;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class BlockPlate
extends BlockTEBase
implements IBlockConfigGui {
    public static final Material material = new PlateMaterial(MapColor.field_151668_h);
    public static final String[] NAMES = new String[]{"frame", "signal", "impulse", "translocate", "charge", "excursion", "teleport"};
    public static boolean[] enable = new boolean[Types.values().length];
    public static ItemStack plateFrame;
    public static ItemStack plateSignal;
    public static ItemStack plateImpulse;
    public static ItemStack plateTranslocate;
    public static ItemStack plateCharge;
    public static ItemStack plateExcursion;
    public static ItemStack plateTeleport;

    public BlockPlate() {
        super(material);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_149663_c("thermalexpansion.plate");
        this.basicGui = false;
    }

    public boolean openConfigGui(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection, EntityPlayer entityPlayer) {
        return ((TilePlateBase)iBlockAccess.func_147438_o(n, n2, n3)).openGui(entityPlayer);
    }

    @Override
    public NBTTagCompound getItemStackTag(World world, int n, int n2, int n3) {
        NBTTagCompound nBTTagCompound = super.getItemStackTag(world, n, n2, n3);
        TilePlateBase tilePlateBase = (TilePlateBase)world.func_147438_o(n, n2, n3);
        if (tilePlateBase instanceof TilePlatePoweredBase) {
            if (nBTTagCompound == null) {
                nBTTagCompound = new NBTTagCompound();
            }
            nBTTagCompound.func_74768_a("Energy", ((TilePlatePoweredBase)tilePlateBase).getEnergyStored(ForgeDirection.UNKNOWN));
        }
        return nBTTagCompound;
    }

    public TileEntity func_149915_a(World world, int n) {
        if (n >= Types.values().length) {
            return null;
        }
        switch (Types.values()[n]) {
            case FRAME: {
                return new TilePlateBase();
            }
            case SIGNAL: {
                return new TilePlateSignal();
            }
            case IMPULSE: {
                return new TilePlateImpulse();
            }
            case TRANSLOCATE: {
                return new TilePlateTranslocate();
            }
            case CHARGE: {
                return new TilePlateCharge();
            }
            case EXCURSION: {
                return world.field_72995_K ? new TilePlateExcursionClient() : new TilePlateExcursion();
            }
            case TELEPORT: {
                return new TilePlateTeleporter();
            }
        }
        return null;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < Types.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public boolean rotateBlock(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        TilePlateBase tilePlateBase;
        boolean bl = false;
        if (!world.field_72995_K && (tilePlateBase = (TilePlateBase)world.func_147438_o(n, n2, n3)) != null) {
            tilePlateBase.rotated();
            int n4 = forgeDirection.ordinal();
            if (n4 >> 1 == tilePlateBase.alignment >> 1 && tilePlateBase.canRotate()) {
                tilePlateBase.direction = (byte)((tilePlateBase.direction + 1) % 6);
                bl = true;
            }
        }
        if (bl) {
            world.func_147471_g(n, n2, n3);
        }
        return bl;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int n, int n2, int n3, Random random) {
        TilePlateBase tilePlateBase = (TilePlateBase)world.func_147438_o(n, n2, n3);
        if (tilePlateBase == null) {
            return;
        }
        tilePlateBase.randomDisplayTick(world, random);
    }

    public void func_149746_a(World world, int n, int n2, int n3, Entity entity, float f) {
        TilePlateBase tilePlateBase = (TilePlateBase)world.func_147438_o(n, n2, n3);
        if (tilePlateBase != null) {
            AxisAlignedBB axisAlignedBB = entity.field_70121_D;
            if (!axisAlignedBB.func_72326_a(this.getCollisionBlockBounds(tilePlateBase, n, n2, n3))) {
                return;
            }
            switch (Types.values()[world.func_72805_g(n, n2, n3)]) {
                case IMPULSE: {
                    if (tilePlateBase.direction >> 1 != 0 || tilePlateBase.alignment != 0) break;
                    entity.field_70143_R = 0.0f;
                    break;
                }
                case TRANSLOCATE: {
                    tilePlateBase.onEntityCollidedWithBlock(entity);
                    break;
                }
            }
        }
    }

    public void func_149670_a(World world, int n, int n2, int n3, Entity entity) {
        TilePlateBase tilePlateBase = (TilePlateBase)world.func_147438_o(n, n2, n3);
        if (tilePlateBase == null) {
            return;
        }
        AxisAlignedBB axisAlignedBB = entity.field_70121_D;
        if (!axisAlignedBB.func_72326_a(this.getCollisionBlockBounds(tilePlateBase, n, n2, n3))) {
            return;
        }
        tilePlateBase.onEntityCollidedWithBlock(entity);
    }

    public AxisAlignedBB getCollisionBlockBounds(TilePlateBase tilePlateBase, int n, int n2, int n3) {
        float f = 0.0625f;
        float f2 = 0.9375f;
        float f3 = (float)(tilePlateBase.direction == 7 ? 16 : 2) / 16.0f;
        AxisAlignedBB axisAlignedBB = null;
        switch (tilePlateBase.alignment) {
            case 0: {
                axisAlignedBB = AxisAlignedBB.func_72330_a((double)f, (double)0.0, (double)f, (double)f2, (double)f3, (double)f2).func_72317_d((double)n, (double)n2, (double)n3);
                break;
            }
            case 1: {
                axisAlignedBB = AxisAlignedBB.func_72330_a((double)f, (double)(1.0f - f3), (double)f, (double)f2, (double)1.0, (double)f2).func_72317_d((double)n, (double)n2, (double)n3);
                break;
            }
            case 2: {
                axisAlignedBB = AxisAlignedBB.func_72330_a((double)f, (double)f, (double)0.0, (double)f2, (double)f2, (double)f3).func_72317_d((double)n, (double)n2, (double)n3);
                break;
            }
            case 3: {
                axisAlignedBB = AxisAlignedBB.func_72330_a((double)f, (double)f, (double)(1.0f - f3), (double)f2, (double)f2, (double)1.0).func_72317_d((double)n, (double)n2, (double)n3);
                break;
            }
            case 4: {
                axisAlignedBB = AxisAlignedBB.func_72330_a((double)0.0, (double)f, (double)f, (double)f3, (double)f2, (double)f2).func_72317_d((double)n, (double)n2, (double)n3);
                break;
            }
            case 5: {
                axisAlignedBB = AxisAlignedBB.func_72330_a((double)(1.0f - f3), (double)f, (double)f, (double)1.0, (double)f2, (double)f2).func_72317_d((double)n, (double)n2, (double)n3);
                break;
            }
        }
        return axisAlignedBB;
    }

    public void func_149719_a(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        TilePlateBase tilePlateBase = (TilePlateBase)iBlockAccess.func_147438_o(n, n2, n3);
        if (tilePlateBase != null) {
            switch (tilePlateBase.alignment) {
                case 0: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
                    return;
                }
                case 1: {
                    this.func_149676_a(0.0f, 0.9375f, 0.0f, 1.0f, 1.0f, 1.0f);
                    return;
                }
                case 2: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0625f);
                    return;
                }
                case 3: {
                    this.func_149676_a(0.0f, 0.0f, 0.9375f, 1.0f, 1.0f, 1.0f);
                    return;
                }
                case 4: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0625f, 1.0f, 1.0f);
                    return;
                }
                case 5: {
                    this.func_149676_a(0.9375f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    return;
                }
            }
        }
    }

    public int func_149645_b() {
        return TEProps.renderIdPlate;
    }

    public MovingObjectPosition func_149731_a(World world, int n, int n2, int n3, Vec3 vec3, Vec3 vec32) {
        this.func_149719_a((IBlockAccess)world, n, n2, n3);
        return super.func_149731_a(world, n, n2, n3, vec3, vec32);
    }

    protected AxisAlignedBB getStatelessBoundingBox(World world, int n, int n2, int n3) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        IconRegistry.addIcon((String)"PlateBottom", (String)"thermalexpansion:plate/Plate_Bottom", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"PlateTopO", (String)"thermalexpansion:plate/Plate_Top_Circle", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"PlateTop0", (String)"thermalexpansion:plate/Plate_Top_Down", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"PlateTop1", (String)"thermalexpansion:plate/Plate_Top_Up", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"PlateTop2", (String)"thermalexpansion:plate/Plate_Top_North", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"PlateTop3", (String)"thermalexpansion:plate/Plate_Top_South", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"PlateTop4", (String)"thermalexpansion:plate/Plate_Top_West", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"PlateTop5", (String)"thermalexpansion:plate/Plate_Top_East", (IIconRegister)iIconRegister);
    }

    public boolean initialize() {
        TilePlateBase.initialize();
        TilePlateSignal.initialize();
        TilePlateImpulse.initialize();
        TilePlateTranslocate.initialize();
        TilePlateCharge.initialize();
        TilePlateExcursion.initialize();
        TilePlateTeleporter.initialize();
        plateFrame = new ItemStack((Block)this, 1, Types.FRAME.ordinal());
        plateSignal = new ItemStack((Block)this, 1, Types.SIGNAL.ordinal());
        plateImpulse = new ItemStack((Block)this, 1, Types.IMPULSE.ordinal());
        plateTranslocate = new ItemStack((Block)this, 1, Types.TRANSLOCATE.ordinal());
        plateCharge = new ItemStack((Block)this, 1, Types.CHARGE.ordinal());
        plateExcursion = new ItemStack((Block)this, 1, Types.EXCURSION.ordinal());
        plateTeleport = new ItemStack((Block)this, 1, Types.TELEPORT.ordinal());
        GameRegistry.registerCustomItemStack((String)"plateFrame", (ItemStack)plateFrame);
        GameRegistry.registerCustomItemStack((String)"plateSignal", (ItemStack)plateSignal);
        GameRegistry.registerCustomItemStack((String)"plateImpulse", (ItemStack)plateImpulse);
        GameRegistry.registerCustomItemStack((String)"plateTranslocate", (ItemStack)plateTranslocate);
        GameRegistry.registerCustomItemStack((String)"plateCharge", (ItemStack)plateCharge);
        GameRegistry.registerCustomItemStack((String)"plateExcursion", (ItemStack)plateExcursion);
        GameRegistry.registerCustomItemStack((String)"plateTeleport", (ItemStack)plateTeleport);
        return true;
    }

    public boolean postInit() {
        if (enable[Types.FRAME.ordinal()]) {
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)plateFrame, (Object[])new Object[]{"SGS", "I I", "SIS", Character.valueOf('S'), "ingotSignalum", Character.valueOf('G'), "blockGlassHardened", Character.valueOf('I'), "ingotInvar"}));
        }
        if (enable[Types.SIGNAL.ordinal()]) {
            TransposerManager.addTEFillRecipe(2000, plateFrame, plateSignal, new FluidStack(TFFluids.fluidRedstone, 1000), false);
        }
        if (enable[Types.IMPULSE.ordinal()]) {
            TransposerManager.addTEFillRecipe(2000, plateFrame, plateImpulse, new FluidStack(TFFluids.fluidGlowstone, 1000), false);
        }
        if (enable[Types.TRANSLOCATE.ordinal()]) {
            TransposerManager.addTEFillRecipe(2000, plateFrame, plateTranslocate, new FluidStack(TFFluids.fluidEnder, 1000), false);
        }
        if (enable[Types.CHARGE.ordinal()]) {
            ItemHelper.addRecipe((IRecipe)new RecipeUpgrade(5, plateCharge, new Object[]{"EGE", "IPI", "ECE", Character.valueOf('E'), "ingotElectrum", Character.valueOf('G'), "gemDiamond", Character.valueOf('I'), TEItems.powerCoilSilver, Character.valueOf('P'), plateSignal, Character.valueOf('C'), TEItems.powerCoilGold}));
        }
        if (enable[Types.EXCURSION.ordinal()]) {
            ItemHelper.addRecipe((IRecipe)new RecipeUpgrade(5, plateExcursion, new Object[]{"EGE", "GPG", "ECE", Character.valueOf('E'), "ingotSignalum", Character.valueOf('G'), "blockQuartz", Character.valueOf('P'), plateImpulse, Character.valueOf('C'), TEItems.powerCoilGold}));
        }
        if (enable[Types.TELEPORT.ordinal()]) {
            ItemHelper.addRecipe((IRecipe)new RecipeUpgrade(5, plateTeleport, new Object[]{"EIE", "IPI", "ECE", Character.valueOf('E'), "ingotEnderium", Character.valueOf('I'), "ingotBronze", Character.valueOf('P'), plateTranslocate, Character.valueOf('C'), BlockCell.cellHardened}));
        }
        TECraftingHandler.addSecureRecipe(plateSignal);
        TECraftingHandler.addSecureRecipe(plateImpulse);
        TECraftingHandler.addSecureRecipe(plateTranslocate);
        TECraftingHandler.addSecureRecipe(plateCharge);
        TECraftingHandler.addSecureRecipe(plateExcursion);
        TECraftingHandler.addSecureRecipe(plateTeleport);
        return true;
    }

    static {
        String string = "Plate.";
        for (int i = 0; i < Types.values().length; ++i) {
            BlockPlate.enable[i] = ThermalExpansion.config.get(string + StringHelper.titleCase((String)NAMES[i]), "Recipe.Enable", true);
        }
    }

    public static enum Types {
        FRAME,
        SIGNAL,
        IMPULSE,
        TRANSLOCATE,
        CHARGE,
        EXCURSION,
        TELEPORT;

        public int texture = this.ordinal() > 3 ? 7 : 2;
    }

    private static class PlateMaterial
    extends Material {
        public PlateMaterial(MapColor mapColor) {
            super(mapColor);
            this.func_76221_f();
        }

        public boolean func_76220_a() {
            return false;
        }
    }
}

