/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.client;

import cofh.api.tileentity.ISecurable;
import cofh.core.gui.GuiBaseAdv;
import cofh.core.gui.element.TabInfo;
import cofh.core.gui.element.TabSecurity;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButton;
import cofh.lib.gui.element.TabBase;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.block.workbench.BlockWorkbench;
import cofh.thermalexpansion.block.workbench.TileWorkbench;
import cofh.thermalexpansion.gui.container.ContainerWorkbench;
import cofh.thermalexpansion.network.PacketTEBase;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GuiWorkbench
extends GuiBaseAdv {
    static String[] TEX_PATH = new String[4];
    static ResourceLocation[] TEXTURES = new ResourceLocation[4];
    public TileWorkbench myTile;
    UUID playerName;
    int type;
    int gridXOffset = 44;
    int schematicOffset = 17;
    int schematicPerRow = 1;
    ElementButton setSchematic;
    ElementButton getSchematic;

    public GuiWorkbench(InventoryPlayer inventoryPlayer, TileEntity tileEntity) {
        super((Container)new ContainerWorkbench(inventoryPlayer, tileEntity));
        this.myTile = (TileWorkbench)tileEntity;
        this.playerName = SecurityHelper.getID((EntityPlayer)inventoryPlayer.field_70458_d);
        this.type = this.myTile.getType();
        switch (this.type) {
            case 1: {
                ((GuiBase)this).texture = TEXTURES[0];
                ((GuiContainer)this).field_147000_g = 210;
                break;
            }
            case 2: {
                ((GuiBase)this).texture = TEXTURES[1];
                ((GuiContainer)this).field_147000_g = 228;
                this.gridXOffset = 54;
                this.schematicOffset = 10;
                this.schematicPerRow = 2;
                break;
            }
            case 3: {
                ((GuiBase)this).texture = TEXTURES[2];
                ((GuiContainer)this).field_146999_f = 212;
                ((GuiContainer)this).field_147000_g = 228;
                this.gridXOffset = 80;
                this.schematicOffset = 16;
                this.schematicPerRow = 3;
                break;
            }
            default: {
                ((GuiBase)this).texture = TEXTURES[3];
                ((GuiContainer)this).field_146999_f = 230;
                ((GuiContainer)this).field_147000_g = 228;
                this.gridXOffset = 98;
                this.schematicOffset = 16;
                this.schematicPerRow = 4;
            }
        }
        ((GuiBase)this).name = this.myTile.func_145825_b();
        this.generateInfo("tab.thermalexpansion.workbench", 3);
        if (this.myTile.type == BlockWorkbench.Types.CREATIVE.ordinal()) {
            this.myInfo = this.myInfo + "\n\n" + StringHelper.localize((String)"tab.thermalexpansion.workbench.creative");
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addTab((TabBase)new TabInfo((GuiBase)this, this.myInfo));
        if (this.myTile.enableSecurity() && this.myTile.isSecured()) {
            this.addTab((TabBase)new TabSecurity((GuiBase)this, (ISecurable)this.myTile, this.playerName));
        }
        this.setSchematic = (ElementButton)this.addElement((ElementBase)new ElementButton((GuiBase)this, this.gridXOffset + 54, 55, "Set", 240, 0, 240, 16, 240, 32, 16, 16, TEX_PATH[0]));
        this.getSchematic = (ElementButton)this.addElement((ElementBase)new ElementButton((GuiBase)this, this.gridXOffset + 54, 19, "Get", 240, 48, 240, 64, 240, 80, 16, 16, TEX_PATH[0]));
    }

    protected void func_146976_a(float f, int n, int n2) {
        super.func_146976_a(f, n, n2);
        ((GuiScreen)this).field_146297_k.field_71446_o.func_110577_a(((GuiBase)this).texture);
        this.drawCurSelection();
        this.drawCurMissing();
    }

    protected void updateElementInformation() {
        if (this.gridNotEmpty()) {
            this.getSchematic.setToolTip("info.thermalexpansion.gridClear");
            this.getSchematic.setSheetY(96);
            this.getSchematic.setHoverY(112);
            this.getSchematic.setActive();
        } else if (this.hasValidSchematic()) {
            this.getSchematic.setToolTip("info.thermalexpansion.gridSet");
            this.getSchematic.setSheetY(48);
            this.getSchematic.setHoverY(64);
            this.getSchematic.setActive();
        } else {
            this.getSchematic.clearToolTip();
            this.getSchematic.setDisabled();
        }
        if (((ContainerWorkbench)((GuiContainer)this).field_147002_h).canWriteSchematic()) {
            this.setSchematic.setToolTip("info.thermalexpansion.writeSchematic");
            this.setSchematic.setActive();
        } else if (this.hasSchematic()) {
            this.setSchematic.setToolTip("info.thermalexpansion.noRecipe");
            this.setSchematic.setDisabled();
        } else {
            this.setSchematic.setToolTip("info.thermalexpansion.noSchematic");
            this.setSchematic.setDisabled();
        }
        if (this.myTile.updateClient) {
            this.myTile.createItemClient(false, ((ContainerWorkbench)((GuiContainer)this).field_147002_h).myOutput.getStackNoUpdate());
            this.myTile.updateClient = false;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.myTile.canAccess()) {
            ((GuiScreen)this).field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void handleElementButtonClick(String string, int n) {
        if (string.equals("Set")) {
            if (((ContainerWorkbench)((GuiContainer)this).field_147002_h).canWriteSchematic()) {
                PacketTEBase.sendTabSchematicPacketToServer();
                GuiWorkbench.playSound((String)"random.click", (float)1.0f, (float)0.8f);
            }
        } else if (string.equals("Get")) {
            if (this.gridNotEmpty()) {
                this.myTile.clearCraftingGrid();
                GuiWorkbench.playSound((String)"random.click", (float)1.0f, (float)0.6f);
            } else if (this.hasValidSchematic()) {
                this.myTile.setCraftingGrid();
                GuiWorkbench.playSound((String)"random.click", (float)1.0f, (float)0.8f);
            }
        }
    }

    public void overlayRecipe() {
        if (!this.gridNotEmpty()) {
            this.getSchematic.setToolTip("info.thermalexpansion.gridSet");
            this.getSchematic.setSheetY(48);
            this.getSchematic.setHoverY(64);
        } else {
            this.getSchematic.setToolTip("info.thermalexpansion.gridClear");
            this.getSchematic.setSheetY(96);
            this.getSchematic.setHoverY(112);
        }
    }

    protected boolean gridNotEmpty() {
        for (int i = 0; i < 9; ++i) {
            if (this.myTile.getInventorySlots(0)[i] == null) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSchematic() {
        return this.myTile.inventory[this.myTile.getCurrentSchematicSlot()] != null;
    }

    protected boolean hasValidSchematic() {
        return this.myTile.inventory[this.myTile.getCurrentSchematicSlot()] != null && this.myTile.inventory[this.myTile.getCurrentSchematicSlot()].field_77990_d != null;
    }

    protected void drawCurMissing() {
        int n = 144;
        if (this.myTile.type == BlockWorkbench.Types.CREATIVE.ordinal()) {
            n = 160;
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (!this.myTile.missingItem[j + i * 3]) continue;
                this.func_73729_b(((GuiContainer)this).field_147003_i + this.gridXOffset + j * 18, ((GuiContainer)this).field_147009_r + 19 + i * 18, 240, n, 16, 16);
            }
        }
    }

    protected void drawCurSelection() {
        int n = !this.hasSchematic() ? 20 : 0;
        int n2 = ((GuiContainer)this).field_147003_i + this.schematicOffset - 2 + this.myTile.selectedSchematic % this.schematicPerRow * 19;
        int n3 = ((GuiContainer)this).field_147009_r + 16 + this.myTile.selectedSchematic / this.schematicPerRow * 19;
        this.func_73729_b(n2, n3, 236, 176 + n, 20, 20);
    }

    static {
        for (int i = 0; i < 4; ++i) {
            GuiWorkbench.TEX_PATH[i] = "thermalexpansion:textures/gui/workbench/Workbench" + (i + 1) + ".png";
            GuiWorkbench.TEXTURES[i] = new ResourceLocation(TEX_PATH[i]);
        }
    }
}

