/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod;

import com.bluepowermod.BluePowerAPI;
import com.bluepowermod.CommonProxy;
import com.bluepowermod.api.BPApi;
import com.bluepowermod.client.gui.GUIHandler;
import com.bluepowermod.compat.CompatibilityUtils;
import com.bluepowermod.convert.WorldConversionEventHandler;
import com.bluepowermod.event.BPEventHandler;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPEnchantments;
import com.bluepowermod.init.BPItems;
import com.bluepowermod.init.Config;
import com.bluepowermod.init.OreDictionarySetup;
import com.bluepowermod.init.Recipes;
import com.bluepowermod.init.TileEntities;
import com.bluepowermod.network.BPNetworkHandler;
import com.bluepowermod.part.PartManager;
import com.bluepowermod.recipe.AlloyFurnaceRegistry;
import com.bluepowermod.redstone.RedstoneApi;
import com.bluepowermod.redstone.RedstoneProviderQmunityLib;
import com.bluepowermod.redstone.RedstoneProviderVanilla;
import com.bluepowermod.reference.Refs;
import com.bluepowermod.util.Achievements;
import com.bluepowermod.world.WorldGenerationHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;
import org.apache.logging.log4j.Logger;

@Mod(modid="bluepower", name="Blue Power", dependencies="required-after:qmunitylib", guiFactory="com.bluepowermod.client.gui.BPGuiFactory")
public class BluePower {
    @Mod.Instance(value="bluepower")
    public static BluePower instance;
    @SidedProxy(clientSide="com.bluepowermod.ClientProxy", serverSide="com.bluepowermod.CommonProxy")
    public static CommonProxy proxy;
    public static Logger log;
    public static Configuration config;
    public static Item.ToolMaterial gemMaterial;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        event.getModMetadata().version = Refs.fullVersionString();
        log = event.getModLog();
        config = new Configuration(event.getSuggestedConfigurationFile());
        BPApi.init(new BluePowerAPI());
        Config.syncConfig(config);
        BPEnchantments.init();
        CompatibilityUtils.preInit(event);
        FMLCommonHandler.instance().bus().register((Object)new Config());
        BPEventHandler eventHandler = new BPEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        FMLCommonHandler.instance().bus().register((Object)eventHandler);
        MinecraftForge.EVENT_BUS.register((Object)new WorldConversionEventHandler());
        RedstoneApi.getInstance().registerRedstoneProvider(new RedstoneProviderQmunityLib());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PartManager.registerParts();
        BPBlocks.init();
        BPItems.init();
        PartManager.registerItems();
        TileEntities.init();
        OreDictionarySetup.init();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenerationHandler(), (int)0);
        proxy.init();
        BPNetworkHandler.initBP();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GUIHandler());
        CompatibilityUtils.init(event);
        Achievements.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        CompatibilityUtils.postInit(event);
        proxy.initRenderers();
        Recipes.init(CraftingManager.func_77594_a());
        AlloyFurnaceRegistry.getInstance().generateRecyclingRecipes();
        RedstoneApi.getInstance().registerRedstoneProvider(new RedstoneProviderVanilla());
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
    }

    @Mod.EventHandler
    public void event(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            Item item;
            String name = mapping.name;
            if (mapping.name.startsWith("bluepower:lamp")) {
                name = name.replace("silver", "light_gray");
                if (mapping.type == GameRegistry.Type.BLOCK) {
                    mapping.remap((Block)GameData.getBlockRegistry().func_82594_a(name));
                    continue;
                }
                mapping.remap((Item)GameData.getItemRegistry().func_82594_a(name));
                continue;
            }
            if (mapping.name.equals("bluepower:bluepower_multipart")) {
                mapping.ignore();
                continue;
            }
            name = name.replace("silver", "light_gray");
            name = name.replace("bluestoneWire", "wire.bluestone");
            if ((name = name.replace("cagelamp", "cagelamp.").replace("fixture", "fixture.")).contains("inverted")) {
                name = "bluepower:part." + name.substring("bluepower:part.inverted".length()) + ".inverted";
            }
            if (name.equals("bluepower:stone_wire")) {
                name = "bluepower:bluestone_wire_tile";
            }
            if (name.equals("bluepower:stone_cathode")) {
                name = "bluepower:bluestone_cathode_tile";
            }
            if (name.equals("bluepower:stone_anode")) {
                name = "bluepower:bluestone_anode_tile";
            }
            if (name.equals("bluepower:stone_pointer")) {
                name = "bluepower:bluestone_pointer_tile";
            }
            if (name.equals("bluepower:silicon_chip")) {
                name = "bluepower:silicon_chip_tile";
            }
            if (name.equals("bluepower:taintedsilicon_chip")) {
                name = "bluepower:tainted_silicon_chip_tile";
            }
            if (name.equals("bluepower:quartz_resonator")) {
                name = "bluepower:quartz_resonator_tile";
            }
            if ((item = (Item)GameData.getItemRegistry().func_82594_a(name)) == null) continue;
            mapping.remap(item);
        }
    }

    static {
        gemMaterial = EnumHelper.addToolMaterial((String)"GEM", (int)2, (int)750, (float)6.0f, (float)2.0f, (int)18);
    }
}

