/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.machine;

import com.bluepowermod.block.BlockContainerBase;
import com.bluepowermod.client.render.RendererBlockBase;
import com.bluepowermod.tile.IRotatable;
import com.bluepowermod.tile.tier1.TileIgniter;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockIgniter
extends BlockContainerBase {
    public BlockIgniter() {
        super(Material.field_151576_e, TileIgniter.class);
        this.func_149663_c("igniter");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.field_149761_L = iconRegister.func_94245_a("bluepower:machines/igniter_side_0");
    }

    @Override
    protected String getIconName(RendererBlockBase.EnumFaceType faceType, boolean ejecting, boolean powered) {
        String iconName = this.field_149768_d + "_" + faceType.toString().toLowerCase();
        if (faceType == RendererBlockBase.EnumFaceType.FRONT && ejecting) {
            iconName = iconName + "_active";
        }
        return iconName;
    }

    public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
        TileIgniter tile = (TileIgniter)world.func_147438_o(x, y, z);
        boolean orientation = tile.getFacingDirection() == ForgeDirection.UP;
        return orientation && tile.getIsRedstonePowered();
    }

    @Override
    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    @Override
    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        TileEntity te = worldObj.func_147438_o(x, y, z);
        if (te instanceof IRotatable) {
            IRotatable rotatable = (IRotatable)te;
            ForgeDirection dir = rotatable.getFacingDirection();
            Block target = worldObj.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            if (target == Blocks.field_150480_ab || target == Blocks.field_150427_aO) {
                worldObj.func_147449_b(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, Blocks.field_150350_a);
            }
            if ((dir = dir.getRotation(axis)) != ForgeDirection.UP && dir != ForgeDirection.DOWN || this.canRotateVertical()) {
                rotatable.setFacingDirection(dir);
                return true;
            }
        }
        return false;
    }
}

