/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.machine;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.block.BlockContainerBase;
import com.bluepowermod.block.machine.BlockLampRGB;
import com.bluepowermod.client.render.RenderLamp;
import com.bluepowermod.init.BPCreativeTabs;
import com.bluepowermod.tile.tier1.TileLamp;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLamp
extends BlockContainerBase {
    private final boolean isInverted;
    private final MinecraftColor color;
    @SideOnly(value=Side.CLIENT)
    public static IIcon off;
    @SideOnly(value=Side.CLIENT)
    public static IIcon on;

    public BlockLamp(boolean isInverted, MinecraftColor color) {
        super(Material.field_151573_f, TileLamp.class);
        this.isInverted = isInverted;
        this.color = color;
        this.func_149663_c("lamp." + color.name().toLowerCase() + (isInverted ? ".inverted" : ""));
        this.func_149647_a(BPCreativeTabs.lighting);
    }

    @Override
    protected TileLamp get(IBlockAccess w, int x, int y, int z) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (te == null || !(te instanceof TileLamp)) {
            return null;
        }
        return (TileLamp)te;
    }

    public int getPower(IBlockAccess w, int x, int y, int z) {
        TileLamp te = this.get(w, x, y, z);
        if (te == null) {
            return 0;
        }
        int power = te.getPower();
        if (this.isInverted()) {
            power = 15 - power;
        }
        return power;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        on = iconRegister.func_94245_a("bluepower:lamps/lamp_on");
        off = iconRegister.func_94245_a("bluepower:lamps/lamp_off");
    }

    public int getLightValue(IBlockAccess w, int x, int y, int z) {
        int pow = this.getPower(w, x, y, z);
        if (Loader.isModLoaded((String)"coloredlightscore")) {
            int color = this.getColor(w, x, y, z);
            int ri = color >> 16 & 0xFF;
            int gi = color >> 8 & 0xFF;
            int bi = color >> 0 & 0xFF;
            float r = (float)ri / 256.0f;
            float g = (float)gi / 256.0f;
            float b = (float)bi / 256.0f;
            if (r < 0.0f) {
                r = 0.0f;
            } else if (r > 1.0f) {
                r = 1.0f;
            }
            if (g < 0.0f) {
                g = 0.0f;
            } else if (g > 1.0f) {
                g = 1.0f;
            }
            if (b < 0.0f) {
                b = 0.0f;
            } else if (b > 1.0f) {
                b = 1.0f;
            }
            return pow | ((int)(15.0f * b) << 15) + ((int)(15.0f * g) << 10) + ((int)(15.0f * r) << 5);
        }
        return pow;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return 0;
    }

    public int getColor(IBlockAccess w, int x, int y, int z) {
        return this.color.getHex();
    }

    public int getColor() {
        return this.color.getHex();
    }

    public boolean isInverted() {
        return this.isInverted;
    }

    @Override
    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return !(world.func_147439_a(x, y, z) instanceof BlockLampRGB);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInPass(int pass) {
        RenderLamp.pass = pass;
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        return this.getColor(world, x, y, z);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int power = this.getPower(world, x, y, z);
        return power > 0 ? on : off;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.isInverted ? on : off;
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        if (this instanceof BlockLampRGB && block instanceof BlockLampRGB) {
            return;
        }
        TileLamp te = this.get((IBlockAccess)world, x, y, z);
        if (te == null) {
            return;
        }
        te.onUpdate();
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        TileLamp te = this.get((IBlockAccess)world, x, y, z);
        if (te == null) {
            return;
        }
        te.onUpdate();
    }
}

