/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.gui.gate;

import com.bluepowermod.client.gui.gate.GuiGate;
import com.bluepowermod.part.gate.digital.GateCounter;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public abstract class GuiGateCounter
extends GuiGate {
    private static final ResourceLocation resLoc = new ResourceLocation("bluepower", "textures/gui/gateBig.png");
    private static final String[] buttonTexts = new String[]{"-25", "-5", "-1", "+1", "+5", "+25"};
    private static final int[] buttonActions = new int[]{-25, -5, -1, 1, 5, 25};

    public GuiGateCounter(GateCounter gate) {
        super(gate, 228, 120);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int buttonWidth = 35;
        for (int y = 0; y < 3; ++y) {
            for (int i = 0; i < buttonTexts.length; ++i) {
                this.field_146292_n.add(new GuiButton(y * buttonTexts.length + i, this.guiLeft + 4 + i * (buttonWidth + 2), this.guiTop + 25 + y * 35, buttonWidth, 20, buttonTexts[i]));
            }
        }
    }

    public void func_146284_a(GuiButton button) {
        int id = (int)Math.floor(button.field_146127_k / buttonTexts.length);
        int subButton = button.field_146127_k % buttonTexts.length;
        int val = 0;
        int min = 0;
        int max = 0;
        switch (id) {
            case 0: {
                val = this.getCurrentMax();
                min = 1;
                max = Short.MAX_VALUE;
                break;
            }
            case 1: {
                val = this.getCurrentIncrement();
                min = 1;
                max = Short.MAX_VALUE;
                break;
            }
            case 2: {
                val = this.getCurrentDecrement();
                min = 1;
                max = Short.MAX_VALUE;
            }
        }
        if ((val += buttonActions[subButton]) < min) {
            val = min;
        }
        if (val > max) {
            val = max;
        }
        this.sendToServer(id, val);
    }

    @Override
    protected ResourceLocation getTexture() {
        return resLoc;
    }

    @Override
    public void renderGUI(int x, int y, float partialTicks) {
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.bluepower:counter.max", (Object[])new Object[0]) + ": " + this.getCurrentMax(), this.guiLeft + this.xSize / 2, this.guiTop + 10, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.bluepower:counter.increment", (Object[])new Object[0]) + ": " + this.getCurrentIncrement(), this.guiLeft + this.xSize / 2, this.guiTop + 10 + 38, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.bluepower:counter.decrement", (Object[])new Object[0]) + ": " + this.getCurrentDecrement(), this.guiLeft + this.xSize / 2, this.guiTop + 10 + 38 + 35, 0xFFFFFF);
    }

    protected abstract int getCurrentMax();

    protected abstract int getCurrentIncrement();

    protected abstract int getCurrentDecrement();
}

