/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.container.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryItem
extends InventoryBasic {
    private ItemStack item;
    private EntityPlayer player;
    private boolean reading = false;

    public InventoryItem(EntityPlayer player, ItemStack item, String name, boolean customName, int size) {
        super(name, customName, size);
        this.player = player;
        this.item = item;
        if (!this.hasInventory()) {
            this.createInventory();
        }
    }

    public static InventoryItem getItemInventory(ItemStack is, String name, int size) {
        return InventoryItem.getItemInventory(null, is, name, size);
    }

    public static InventoryItem getItemInventory(EntityPlayer player, ItemStack is, String name, int size) {
        return new InventoryItem(player, is, name, false, size);
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void func_70295_k_() {
        this.loadInventory();
    }

    public void func_70305_f() {
        this.closeInventory(null);
    }

    public void closeInventory(ItemStack is) {
        this.saveInventory(is);
    }

    private boolean hasInventory() {
        if (this.item.field_77990_d == null) {
            return false;
        }
        return this.item.field_77990_d.func_74781_a("Inventory") != null;
    }

    private void createInventory() {
        this.writeToNBT();
    }

    protected void writeToNBT() {
        if (this.item.field_77990_d == null) {
            this.item.field_77990_d = new NBTTagCompound();
        }
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            NBTTagCompound slotEntry = new NBTTagCompound();
            slotEntry.func_74774_a("Slot", (byte)i);
            this.func_70301_a(i).func_77955_b(slotEntry);
            itemList.func_74742_a((NBTBase)slotEntry);
        }
        NBTTagCompound inventory = new NBTTagCompound();
        inventory.func_74782_a("Items", (NBTBase)itemList);
        this.item.field_77990_d.func_74782_a("Inventory", (NBTBase)inventory);
    }

    public void loadInventory() {
        this.readFromNBT();
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.reading) {
            this.saveInventory(null);
        }
    }

    protected void setNBT(ItemStack is) {
        if (is == null && this.player != null) {
            is = this.player.func_71045_bC();
        }
        if (is != null && is.func_77973_b() == this.item.func_77973_b()) {
            is.func_77982_d(this.item.func_77978_p());
        }
    }

    protected void readFromNBT() {
        this.reading = true;
        NBTTagList itemList = (NBTTagList)((NBTTagCompound)this.item.field_77990_d.func_74781_a("Inventory")).func_74781_a("Items");
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound slotEntry = itemList.func_150305_b(i);
            int j = slotEntry.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.func_70302_i_()) continue;
            this.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)slotEntry));
        }
        this.reading = false;
    }

    public void saveInventory(ItemStack is) {
        this.writeToNBT();
        this.setNBT(is);
    }
}

