/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.container.slot;

import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.tile.tier2.TileCircuitTable;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class SlotCircuitTableCrafting
extends SlotCrafting {
    private final TileCircuitTable circuitTable;

    public SlotCircuitTableCrafting(EntityPlayer p_i1823_1_, IInventory circuitTable, IInventory craftSlot, int p_i1823_4_, int p_i1823_5_, int p_i1823_6_) {
        super(p_i1823_1_, circuitTable, craftSlot, p_i1823_4_, p_i1823_5_, p_i1823_6_);
        this.circuitTable = (TileCircuitTable)circuitTable;
    }

    public boolean func_82869_a(EntityPlayer player) {
        ItemStack stack = this.func_75211_c();
        if (stack != null) {
            return SlotCircuitTableCrafting.canCraft(stack, this.circuitTable);
        }
        return false;
    }

    public static boolean canCraft(ItemStack stack, TileCircuitTable circuitTable) {
        List<ItemStack> requiredItems = SlotCircuitTableCrafting.getCraftingComponents(stack);
        if (requiredItems.size() == 0) {
            return false;
        }
        for (ItemStack requiredItem : requiredItems) {
            ItemStack extractedStack = IOHelper.extract(circuitTable, ForgeDirection.UNKNOWN, requiredItem, true, true);
            if (extractedStack != null && extractedStack.field_77994_a >= requiredItem.field_77994_a) continue;
            return false;
        }
        return true;
    }

    public void func_82870_a(EntityPlayer player, ItemStack craftedItem) {
        FMLCommonHandler.instance().firePlayerCraftingEvent(player, craftedItem, (IInventory)this.circuitTable);
        this.func_75208_c(craftedItem);
        List<ItemStack> requiredItems = SlotCircuitTableCrafting.getCraftingComponents(craftedItem);
        for (ItemStack requiredItem : requiredItems) {
            IOHelper.extract(this.circuitTable, ForgeDirection.UNKNOWN, requiredItem, true, false, 1);
        }
        ItemStack item = craftedItem.func_77946_l();
        item.field_77994_a = 1;
        this.func_75215_d(item);
    }

    private static List<ItemStack> getCraftingComponents(ItemStack gate) {
        ArrayList<ItemStack> requiredItems = new ArrayList<ItemStack>();
        List recipeList = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe r : recipeList) {
            ItemStack result = r.func_77571_b();
            if (result == null || !result.func_77969_a(gate)) continue;
            if (r instanceof ShapedOreRecipe) {
                ShapedOreRecipe recipe = (ShapedOreRecipe)r;
                for (Object o : recipe.getInput()) {
                    ItemStack stack;
                    if (o == null) continue;
                    if (o instanceof ItemStack) {
                        stack = (ItemStack)o;
                    } else {
                        List list = (List)o;
                        ItemStack itemStack = stack = list.size() > 0 ? (ItemStack)list.get(0) : null;
                    }
                    if (stack == null) continue;
                    boolean needsAdding = true;
                    for (ItemStack listStack : requiredItems) {
                        if (!listStack.func_77969_a(stack)) continue;
                        ++listStack.field_77994_a;
                        needsAdding = false;
                        break;
                    }
                    if (!needsAdding) continue;
                    requiredItems.add(stack.func_77946_l());
                }
                return requiredItems;
            }
            if (!(r instanceof ShapedRecipes)) continue;
            ShapedRecipes recipe = (ShapedRecipes)r;
            for (ItemStack stack : recipe.field_77574_d) {
                if (stack == null) continue;
                boolean needsAdding = true;
                for (ItemStack listStack : requiredItems) {
                    if (!listStack.func_77969_a(stack)) continue;
                    ++listStack.field_77994_a;
                    needsAdding = false;
                    break;
                }
                if (!needsAdding) continue;
                requiredItems.add(stack.func_77946_l());
            }
            return requiredItems;
        }
        return new ArrayList<ItemStack>();
    }
}

