/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.network.message;

import com.bluepowermod.BluePower;
import com.bluepowermod.helper.ItemStackDatabase;
import com.bluepowermod.network.BPNetworkHandler;
import com.bluepowermod.network.message.MessageSendClientServerTemplates;
import com.bluepowermod.reference.GuiIDs;
import com.bluepowermod.tile.tier3.TileCircuitDatabase;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import uk.co.qmunity.lib.network.LocatedPacket;

public class MessageCircuitDatabaseTemplate
extends LocatedPacket<MessageCircuitDatabaseTemplate> {
    private ItemStack stack;
    private boolean deleting;

    public MessageCircuitDatabaseTemplate() {
    }

    public MessageCircuitDatabaseTemplate(TileCircuitDatabase circuitDatabase, ItemStack stack) {
        super(circuitDatabase.field_145851_c, circuitDatabase.field_145848_d, circuitDatabase.field_145849_e);
        this.stack = stack;
    }

    public MessageCircuitDatabaseTemplate(TileCircuitDatabase circuitDatabase, ItemStack stack, boolean deleting) {
        super(circuitDatabase.field_145851_c, circuitDatabase.field_145848_d, circuitDatabase.field_145849_e);
        this.stack = stack;
        this.deleting = deleting;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        buf.writeBoolean(this.deleting);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.deleting = buf.readBoolean();
    }

    public void handleClientSide(EntityPlayer player) {
        TileEntity te = player.field_70170_p.func_147438_o(this.x, this.y, this.z);
        if (te instanceof TileCircuitDatabase) {
            ((TileCircuitDatabase)te).saveToPrivateLibrary(this.stack);
        }
    }

    public void handleServerSide(EntityPlayer player) {
        if (this.deleting) {
            if (TileCircuitDatabase.hasPermissions(player)) {
                ItemStackDatabase stackDatabase = new ItemStackDatabase();
                stackDatabase.deleteStack(this.stack);
                BPNetworkHandler.INSTANCE.sendToAll((IMessage)new MessageSendClientServerTemplates(stackDatabase.loadItemStacks()));
            }
        } else {
            TileEntity te = player.field_70170_p.func_147438_o(this.x, this.y, this.z);
            if (te instanceof TileCircuitDatabase) {
                ((TileCircuitDatabase)te).copyInventory.func_70299_a(0, this.stack);
                player.openGui((Object)BluePower.instance, GuiIDs.CIRCUITDATABASE_MAIN_ID.ordinal(), player.field_70170_p, this.x, this.y, this.z);
            }
        }
    }
}

