/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.network.message;

import com.bluepowermod.BluePower;
import com.bluepowermod.part.IGuiButtonSensitive;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import uk.co.qmunity.lib.network.LocatedPacket;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.ITilePartHolder;
import uk.co.qmunity.lib.part.compat.MultipartCompatibility;

public class MessageGuiUpdate
extends LocatedPacket<MessageGuiUpdate> {
    private int partId;
    private int icId;
    private int messageId;
    private int value;

    public MessageGuiUpdate() {
    }

    public MessageGuiUpdate(IPart part, int messageId, int value) {
        super(part.getX(), part.getY(), part.getZ());
        this.partId = this.getPartId(part);
        if (this.partId == -1) {
            BluePower.log.warn("[MessageGuiUpdate] BPPart couldn't be found");
        }
        this.messageId = messageId;
        this.value = value;
    }

    public MessageGuiUpdate(TileEntity tile, int messageId, int value) {
        super(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        this.partId = -1;
        this.messageId = messageId;
        this.value = value;
    }

    private int getPartId(IPart part) {
        List parts = MultipartCompatibility.getPartHolder((World)part.getWorld(), (int)part.getX(), (int)part.getY(), (int)part.getZ()).getParts();
        return parts.indexOf(part);
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.messageId);
        buf.writeInt(this.partId);
        buf.writeInt(this.value);
        buf.writeInt(this.icId);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.messageId = buf.readInt();
        this.partId = buf.readInt();
        this.value = buf.readInt();
        this.icId = buf.readInt();
    }

    public void handleClientSide(EntityPlayer player) {
    }

    public void handleServerSide(EntityPlayer player) {
        ITilePartHolder partHolder = MultipartCompatibility.getPartHolder((World)player.field_70170_p, (int)this.x, (int)this.y, (int)this.z);
        if (partHolder != null) {
            this.messagePart(player, partHolder);
        } else {
            TileEntity te = player.field_70170_p.func_147438_o(this.x, this.y, this.z);
            if (te instanceof IGuiButtonSensitive) {
                ((IGuiButtonSensitive)te).onButtonPress(player, this.messageId, this.value);
            }
        }
    }

    private void messagePart(EntityPlayer player, ITilePartHolder partHolder) {
        List parts = partHolder.getParts();
        if (this.partId < parts.size()) {
            IPart part = (IPart)parts.get(this.partId);
            if (part instanceof IGuiButtonSensitive) {
                ((IGuiButtonSensitive)part).onButtonPress(player, this.messageId, this.value);
            } else {
                BluePower.log.error("[BluePower][MessageGuiPacket] Part doesn't implement IGuiButtonSensitive");
            }
        }
    }
}

