/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.network.message;

import com.bluepowermod.api.wireless.IFrequency;
import com.bluepowermod.part.gate.wireless.Frequency;
import com.bluepowermod.part.gate.wireless.WirelessManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import uk.co.qmunity.lib.network.Packet;

public class MessageWirelessFrequencySync
extends Packet<MessageWirelessFrequencySync> {
    private List<Frequency> frequencies = new ArrayList<Frequency>();
    private EntityPlayer player;

    public MessageWirelessFrequencySync(EntityPlayer player) {
        this.player = player;
    }

    public MessageWirelessFrequencySync() {
    }

    public void write(DataOutput buffer) throws IOException {
        List<IFrequency> frequencies = null;
        if (this.player == null || this.player.field_71075_bZ.field_75098_d) {
            frequencies = WirelessManager.COMMON_INSTANCE.getFrequencies();
        } else {
            frequencies = new ArrayList<IFrequency>();
            frequencies.addAll(WirelessManager.COMMON_INSTANCE.getAvailableRedstoneFrequencies(this.player));
            frequencies.addAll(WirelessManager.COMMON_INSTANCE.getAvailableBundledFrequencies(this.player));
        }
        buffer.writeInt(frequencies.size());
        for (IFrequency f : frequencies) {
            ((Frequency)f).writeToBuffer(buffer);
        }
    }

    public void read(DataInput buffer) throws IOException {
        int amt = buffer.readInt();
        for (int i = 0; i < amt; ++i) {
            Frequency f = new Frequency();
            f.readFromBuffer(buffer);
            this.frequencies.add(f);
        }
    }

    public void handleClientSide(EntityPlayer player) {
        WirelessManager m = WirelessManager.CLIENT_INSTANCE;
        m.unloadFrequencies();
        for (Frequency f : this.frequencies) {
            m.registerFrequency(f);
        }
    }

    public void handleServerSide(EntityPlayer player) {
    }
}

