/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.analogue;

import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.client.gui.gate.GuiGateSingleCounter;
import com.bluepowermod.part.IGuiButtonSensitive;
import com.bluepowermod.part.gate.analogue.GateSimpleAnalogue;
import com.bluepowermod.part.gate.component.GateComponentBorder;
import com.bluepowermod.part.gate.component.GateComponentBorderDark;
import com.bluepowermod.part.gate.component.GateComponentPointer;
import com.bluepowermod.part.gate.component.GateComponentWire;
import com.bluepowermod.part.gate.connection.GateConnectionAnalogue;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import uk.co.qmunity.lib.raytrace.QMovingObjectPosition;

public class GateRegulableTorch
extends GateSimpleAnalogue
implements IGuiButtonSensitive {
    private GateComponentPointer torch;
    private int power = 0;

    @Override
    protected String getGateType() {
        return "regulabletorch";
    }

    @Override
    protected void initializeConnections() {
        ((GateConnectionAnalogue)this.front()).enable();
    }

    @Override
    protected void initComponents() {
        this.torch = new GateComponentPointer(this, 0xFFFF00, 0.4375, false).setAngle(0.125);
        this.addComponent(this.torch.setState(true));
        this.addComponent(new GateComponentWire(this, 4101340, RedwireType.RED_ALLOY).bind((GateConnectionBase)this.front()));
        this.addComponent(new GateComponentBorder(this, 0x7D7D7D));
        this.addComponent(new GateComponentBorderDark(this, 0x555555));
    }

    @Override
    public void doLogic() {
    }

    @Override
    public void tick() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected GuiScreen getGui(EntityPlayer player) {
        return new GuiGateSingleCounter(this){

            @Override
            protected int getCurrentAmount() {
                return GateRegulableTorch.this.power;
            }

            @Override
            protected String[] getButtonText() {
                return new String[]{"-100", "-10", "-1", "+1", "+10", "+100"};
            }

            @Override
            protected int[] getButtonActions() {
                return new int[]{-100, -10, -1, 1, 10, 100};
            }

            @Override
            protected String getDisplayedString() {
                return "" + this.getCurrentAmount();
            }

            @Override
            protected String getTitle() {
                return "gui.bluepower:regulabletorch";
            }

            @Override
            protected int getMinValue() {
                return 0;
            }

            @Override
            protected int getMaxValue() {
                return 255;
            }
        };
    }

    @Override
    protected boolean hasGUI() {
        return true;
    }

    @Override
    public void onButtonPress(EntityPlayer player, int messageId, int value) {
        if (messageId == 0) {
            this.power = value;
            ((GateConnectionAnalogue)this.front()).setOutput((byte)this.power);
            this.torch.setAngle(0.125 + (double)this.power / 255.0 * 0.75);
            this.sendUpdatePacket();
        }
    }

    @Override
    public boolean onActivated(EntityPlayer player, QMovingObjectPosition mop, ItemStack item) {
        return super.onActivated(player, mop, item);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("power", this.power);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.power = tag.func_74762_e("power");
        ((GateConnectionAnalogue)this.front()).setOutput((byte)this.power);
    }

    @Override
    public void writeUpdateData(DataOutput buffer) throws IOException {
        super.writeUpdateData(buffer);
        buffer.writeInt(this.power);
    }

    @Override
    public void readUpdateData(DataInput buffer) throws IOException {
        super.readUpdateData(buffer);
        this.power = buffer.readInt();
    }
}

