/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.component;

import com.bluepowermod.client.render.IconSupplier;
import com.bluepowermod.part.gate.GateBase;
import com.bluepowermod.part.gate.component.GateComponent;
import java.awt.image.BufferedImage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import uk.co.qmunity.lib.client.render.RenderHelper;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public abstract class GateComponentButton
extends GateComponent {
    private boolean state = false;
    private int layoutColor = -1;
    private double x = 0.0;
    private double z = 0.0;

    public GateComponentButton(GateBase<?, ?, ?, ?, ?, ?> gate, int color) {
        super(gate);
        this.layoutColor = color;
        this.onLayoutRefresh();
    }

    public GateComponentButton(GateBase<?, ?, ?, ?, ?, ?> gate, double x, double z) {
        super(gate);
        this.x = x;
        this.z = z;
    }

    protected abstract IIcon getIcon();

    @Override
    public void renderStatic(Vec3i translation, RenderHelper renderer, int pass) {
        renderer.renderBox(new Vec3dCube(this.x, 0.125, this.z, this.x + 0.25, 0.21875, this.z + 0.25), IconSupplier.gateButton);
        renderer.renderBox(new Vec3dCube(this.x + 0.03125, 0.21875, this.z + 0.03125, this.x + 0.25 - 0.03125, 0.25, this.z + 0.25 - 0.03125), this.getIcon());
    }

    @Override
    public void renderDynamic(Vec3d translation, double delta, int pass) {
    }

    @Override
    public void onLayoutRefresh() {
        if (this.layoutColor == -1) {
            return;
        }
        BufferedImage img = ((GateBase)this.getGate()).getLayout().getLayout(this.layoutColor);
        this.x = img.getWidth();
        this.z = img.getHeight();
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getWidth(); ++y) {
                if ((img.getRGB(x, y) & 0xFFFFFF) == 0) continue;
                this.x = Math.min(this.x, (double)x);
                this.z = Math.min(this.z, (double)y);
            }
        }
        this.x /= (double)img.getWidth();
        this.z /= (double)img.getHeight();
    }

    public GateComponentButton setState(boolean state) {
        if (state != this.state) {
            this.setNeedsSyncing(true);
        }
        this.state = state;
        return this;
    }

    public boolean getState() {
        return this.state;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("state", this.state);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.state = tag.func_74767_n("state");
    }

    @Override
    public void writeData(DataOutput buffer) throws IOException {
        super.writeData(buffer);
        buffer.writeBoolean(this.state);
    }

    @Override
    public void readData(DataInput buffer) throws IOException {
        super.readData(buffer);
        this.state = buffer.readBoolean();
    }
}

