/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.connection;

import com.bluepowermod.api.connect.IConnection;
import com.bluepowermod.api.gate.IGateConnection;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.part.gate.GateBase;
import com.bluepowermod.redstone.DummyRedstoneDevice;
import com.bluepowermod.redstone.RedstoneApi;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.helper.RedstoneHelper;
import uk.co.qmunity.lib.util.Dir;

public abstract class GateConnectionBase
implements IGateConnection {
    protected GateBase<?, ?, ?, ?, ?, ?> gate;
    protected Dir direction;
    protected boolean enabled = false;
    protected boolean outputOnly;
    private boolean needsSyncing = false;

    public GateConnectionBase(GateBase<?, ?, ?, ?, ?, ?> gate, Dir direction) {
        this.gate = gate;
        this.direction = direction;
    }

    public GateBase<?, ?, ?, ?, ?, ?> getGate() {
        return this.gate;
    }

    @Override
    public Dir getDirection() {
        return this.direction;
    }

    public ForgeDirection getForgeDirection() {
        return this.getDirection().toForgeDirection(this.gate.getFace(), this.gate.getRotation());
    }

    @Override
    public void notifyUpdate() {
        if (this.gate.getParent() == null || this.gate.getWorld() == null) {
            return;
        }
        ForgeDirection d = this.getForgeDirection();
        IConnection<IRedstoneDevice> c = this.gate.getRedstoneConnectionCache().getConnectionOnSide(d);
        if (c == null || c.getB() instanceof DummyRedstoneDevice) {
            World world = this.gate.getWorld();
            int x = this.gate.getX();
            int y = this.gate.getY();
            int z = this.gate.getZ();
            RedstoneHelper.notifyRedstoneUpdate((World)world, (int)x, (int)y, (int)z, (ForgeDirection)d, (boolean)true);
        } else {
            RedstoneApi.getInstance().getRedstonePropagator((IRedstoneDevice)((Object)this.getGate()), d).propagate();
        }
    }

    public abstract void notifyUpdateIfNeeded();

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public IGateConnection setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.setNeedsSyncing(true);
        return this;
    }

    @Override
    public IGateConnection enable() {
        return this.setEnabled(true);
    }

    @Override
    public IGateConnection disable() {
        return this.setEnabled(false);
    }

    @Override
    public IGateConnection setOutputOnly() {
        this.outputOnly = true;
        return this;
    }

    @Override
    public IGateConnection setBidirectional() {
        this.outputOnly = false;
        return this;
    }

    @Override
    public boolean isOutputOnly() {
        return this.outputOnly;
    }

    public abstract double getSignal();

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74757_a("enabled", this.enabled);
        tag.func_74768_a("direction", this.direction.ordinal());
        tag.func_74757_a("outputOnly", this.outputOnly);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.enabled = tag.func_74767_n("enabled");
        this.direction = Dir.values()[tag.func_74762_e("direction")];
        this.outputOnly = tag.func_74767_n("outputOnly");
    }

    @Override
    public void writeData(DataOutput buffer) throws IOException {
        this.setNeedsSyncing(false);
        buffer.writeBoolean(this.enabled);
    }

    @Override
    public void readData(DataInput buffer) throws IOException {
        this.enabled = buffer.readBoolean();
    }

    @Override
    public boolean canConnectRedstone() {
        return !this.isBundled();
    }

    public boolean needsSyncing() {
        return this.needsSyncing;
    }

    protected void setNeedsSyncing(boolean needsSyncing) {
        this.needsSyncing = needsSyncing;
    }

    public GateConnectionBase reset() {
        this.enabled = false;
        return this;
    }
}

