/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.connection;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.IBundledDevice;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.part.gate.GateBase;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import uk.co.qmunity.lib.util.Dir;

public class GateConnectionBundledAnalogue
extends GateConnectionBase {
    private byte[] input = new byte[16];
    private byte[] output = new byte[16];

    public GateConnectionBundledAnalogue(GateBase<?, ?, ?, ?, ?, ?> gate, Dir direction) {
        super(gate, direction);
    }

    @Override
    public void refresh() {
    }

    @Override
    public boolean canConnect(IRedstoneDevice device) {
        return false;
    }

    @Override
    public boolean canConnect(IBundledDevice device) {
        return true;
    }

    @Override
    public boolean isBundled() {
        return true;
    }

    @Override
    public byte getRedstoneOutput() {
        return 0;
    }

    @Override
    public byte[] getBundledOutput() {
        return this.output;
    }

    @Override
    public void setRedstonePower(byte power) {
    }

    @Override
    public void setBundledPower(byte[] power) {
        for (int i = 0; i < power.length; ++i) {
            this.input[i] = power[i];
        }
    }

    public byte[] getInput() {
        return this.input;
    }

    public byte[] getOutput() {
        return this.output;
    }

    public byte getInput(MinecraftColor color) {
        return this.input[color.ordinal()];
    }

    public byte getOutput(MinecraftColor color) {
        return this.output[color.ordinal()];
    }

    public void setInput(byte[] input) {
        this.input = input;
    }

    public void setOutput(byte[] output) {
        this.output = output;
    }

    public void setInput(byte input, MinecraftColor color) {
        this.input[color.ordinal()] = input;
    }

    public void setOutput(byte output, MinecraftColor color) {
        this.output[color.ordinal()] = output;
    }

    @Override
    public GateConnectionBundledAnalogue disable() {
        super.disable();
        return this;
    }

    @Override
    public GateConnectionBundledAnalogue enable() {
        super.enable();
        return this;
    }

    @Override
    public GateConnectionBundledAnalogue setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    @Override
    public GateConnectionBundledAnalogue setOutputOnly() {
        super.setOutputOnly();
        return this;
    }

    @Override
    public GateConnectionBundledAnalogue setBidirectional() {
        super.setBidirectional();
        return this;
    }

    @Override
    public double getSignal() {
        return 0.0;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        int i;
        super.writeToNBT(tag);
        for (i = 0; i < 16; ++i) {
            tag.func_74774_a("input_" + i, this.input[i]);
        }
        for (i = 0; i < 16; ++i) {
            tag.func_74774_a("output_" + i, this.output[i]);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        int i;
        super.readFromNBT(tag);
        for (i = 0; i < 16; ++i) {
            this.input[i] = tag.func_74771_c("input_" + i);
        }
        for (i = 0; i < 16; ++i) {
            this.output[i] = tag.func_74771_c("output_" + i);
        }
    }

    @Override
    public void writeData(DataOutput buffer) throws IOException {
        int i;
        super.writeData(buffer);
        for (i = 0; i < 16; ++i) {
            buffer.writeByte(this.input[i]);
        }
        for (i = 0; i < 16; ++i) {
            buffer.writeByte(this.output[i]);
        }
    }

    @Override
    public void readData(DataInput buffer) throws IOException {
        int i;
        super.readData(buffer);
        for (i = 0; i < 16; ++i) {
            this.input[i] = buffer.readByte();
        }
        for (i = 0; i < 16; ++i) {
            this.output[i] = buffer.readByte();
        }
    }

    @Override
    public void notifyUpdateIfNeeded() {
    }

    @Override
    public GateConnectionBundledAnalogue reset() {
        super.reset();
        this.input = new byte[16];
        this.output = new byte[16];
        return this;
    }
}

